#include <iostream>
#include <cstdlib>
#include "smtp.h"

using namespace std;
using namespace mail_tools;

int
main(int argc, char ** argv)
{
   if(argc != 7) {
      cerr << "usage: sendmsg <host> <port> <to_address> <from_address> <subject> <message>" << endl;
      exit(1);
   }
   const char * host = argv[1];
   int port = atoi(argv[2]);
   const char * to_address = argv[3];
   const char * from_address = argv[4];
   const char * subject = argv[5];
   const char * message = argv[6];
   smtp email_message(host, port);
   email_message.set_from(from_address);
   email_message.set_to(to_address);
   email_message.set_subject(subject);
   email_message.set_message(message);
   email_message.send();
   return 0;
}
