/*

(C) Copyright 2011.  All rights reserved.
This source code is the intellectual property of Matthew William Coan.

Shell code.

Author: Matthew W. Coan
Date: Mon Jun  6 06:07:39 EST 2011

*/
#ifndef _SHELL_H
#define _SHELL_H

#include <cstdio>

namespace shell_tools {

using namespace std;

class shell {
public:
   shell();
   ~shell();

   string execute(const string & cmd);
};

inline
shell::shell()
{
}

inline
shell::~shell()
{
}

inline
string
shell::execute(const string & cmd)
{
   FILE * sh = popen(cmd.c_str(), "r");
   string str_ret;
   int ch;

   if(sh != NULL) {
      while((ch = fgetc(sh)) != EOF) {
          str_ret += static_cast< char >(ch);
      }
      
      pclose(sh);
   }

   return str_ret;
}

}

#endif /* _SHELL_H */
