#ifndef _SOUNDEX_H
#define _SOUNDEX_H

namespace text_tools {

#define SNDMAX (1 + 6 + 6*6 + 6*6*6)
#define SNDLEN (26 * SNDMAX)
#define NUL '\0'

inline
char *soundex(char *instr, char *outstr)
{                   /* ABCDEFGHIJKLMNOPQRSTUVWXYZ */
        const char *table = "01230120022455012623010202";
        char *outptr = outstr;
        int count = 0;

        while(!isalpha(instr[0]) && instr[0])
                ++instr;

        if(!instr[0])     /* Hey!  Where'd the string go? */
                return(NULL);

        if(toupper(instr[0]) == 'P' && toupper(instr[1]) == 'H')
        {
                instr[0] = 'F';
                instr[1] = 'A';
        }

        *outptr++ = (char)toupper(*instr++);

        while(*instr && count < 8/*5*/)
        {
                if(isalpha(*instr) && *instr != *(instr-1))
                {
                        *outptr = table[toupper(instr[0]) - 'A'];
                        if(*outptr != '0')
                        {
                                ++outptr;
                                ++count;
                        }
                }
                ++instr;
        }

        *outptr = '\0';
        return(outstr);
}

}

#endif /* _SOUNDEX_H */
