#ifndef _REGEX_H
#define _REGEX_H

#include <regex.h>
#include <string>
#include <assert.h>

namespace string_tools {

using namespace std;


class RegExpr {
   regex_t re;
   regmatch_t matches[10];
public:
   RegExpr(const string & regex)
   {
      int rc = regcomp(&re, regex.c_str(), REG_EXTENDED);
      assert(rc == 0);
   }

   int match(const string & data, string & value) {
      int index = -1;
      int rc = regexec(&re, data.c_str(),
              sizeof(matches)/sizeof(matches[0]),
              (regmatch_t*)&matches,0);
      if(rc == 0) {
         index = matches[0].rm_so;
         value = data.substr(matches[0].rm_so, 
                 matches[0].rm_eo - matches[0].rm_so);
      }
      return index;
   }

   ~RegExpr() {
      regfree(&re);
   }
};

}

#endif /* _REGEX_H */
