#ifndef _STR_TOK_H
#define _STR_TOK_H

#include <string>
#include <list>
#include <cstring>

using namespace std;

class string_tokenizer {
public:
   typedef list< string > string_list_type;

private:
   string_list_type _token_list;
   string_list_type::iterator _pointer;

public:
   string_tokenizer(const string & str, const string & sep) { 
      char * buffer = new char[str.size()+1];
      memset(buffer, 0, str.size()+1);
      strcpy(buffer, str.c_str());
      char * ptr = strtok(buffer, sep.c_str());
      while(ptr != NULL) {
         _token_list.push_back(string(ptr));
         ptr = strtok(NULL, sep.c_str());
      }
      delete [] buffer;
      _pointer = _token_list.begin();
   }

   string_tokenizer(const string_tokenizer & cp) { 
       _token_list = cp._token_list;
      _pointer = cp._pointer;
   }

   virtual ~string_tokenizer() { }

   string_tokenizer & operator=(const string_tokenizer & right) {
      _token_list = right._token_list;
      _pointer = right._pointer;
      return *this;
   }

   string get_next() { 
      string token;

      if(_pointer != _token_list.end()) {
         token = *_pointer; 
         _pointer++;
      } 

      return token;
   }

   bool has_next() { 
      return (_pointer != _token_list.end());
   }
};

#endif /* _STR_TOK_H */
