#ifndef _HASHTABLE_H
#define _HASHTABLE_H

#include <sys/types.h>
#include <cstdio>
#include <cstring>
#include <cstdlib>
#include <db.h>

namespace db_tools {

using namespace std;

struct db_exception { };

template< class Key,
          class Data >
class hashtable_iterator {
public:
   typedef Data (*GetData_type)(DBT *);
   typedef Key (*GetKey_type)(DBT *);

private:
   DBC * dbc;
   DBT key,data;
   GetData_type GetData;
   GetKey_type GetKey;

public:
   hashtable_iterator() { 
      memset(&key, 0, sizeof(DBT));
      memset(&data, 0, sizeof(DBT));
      dbc = 0;
   }

   hashtable_iterator(const hashtable_iterator & cp) {
      dbc = cp.dbc;
      GetData = cp.GetData;
      GetKey = cp.GetKey;
      key = cp.key;
      data = cp.data;
   }

   hashtable_iterator(DBC * dbc,
                  GetKey_type gk,
                  GetData_type gd) {
      this->dbc = dbc;
      GetData = gd;
      GetKey = gk;
      memset(&key, 0, sizeof(DBT));
      memset(&data, 0, sizeof(DBT));
   }

   ~hashtable_iterator() {

   }

   void close() {
      dbc->close(dbc);
   }

   hashtable_iterator & operator=(const hashtable_iterator & cp) {
      dbc = cp.dbc;
      GetData = cp.GetData;
      GetKey = cp.GetKey;
      key = cp.key; 
      data = cp.data;
      return *this;
   }

   Data get_data() {
      return GetData(&data);
   }

   Key get_key() {
      return GetKey(&key);
   }

   bool next() {
      bool ret;

      memset(&key, 0, sizeof(DBT));
      memset(&data, 0, sizeof(DBT));

      if(dbc->get(dbc, &key, &data, DB_NEXT) == 0) {
         ret = true; 
      }
      else {
         ret = false;
      }

      return ret;
   }
};

template< class Key, 
          class Data >
class hashtable {
   DB *dbp;
   DBT key,data;
   typedef void (*GetKeyDBT_type)(const Key &, DBT *);
   typedef void (*GetDataDBT_type)(const Data &, DBT *);
   typedef Data (*GetData_type)(DBT *);
   typedef Key (*GetKey_type)(DBT *);
   GetKeyDBT_type GetKeyDBT;
   GetDataDBT_type GetDataDBT;
   GetData_type GetData;
   GetKey_type GetKey;

public:
   typedef hashtable_iterator< Key, Data > iterator;

   hashtable(const char * filename,
         GetKeyDBT_type gk,
         GetDataDBT_type gd,
         GetKey_type gk2,
         GetData_type gd2) {
      GetKeyDBT = gk;
      GetDataDBT = gd;
      GetData = gd2;
      GetKey = gk2;
      int ret;
      if ((ret = db_create(&dbp, NULL, 0)) != 0) {
         throw db_exception();
      }

      if ((ret = dbp->open(dbp,
           NULL, filename, NULL, DB_HASH, DB_CREATE, 0664)) != 0) {
         throw db_exception();
      }
   }

   virtual ~hashtable() {
      if (dbp->close(dbp, 0) != 0)
         throw db_exception();
   }

   bool get(const Key & k, Data & d) {
      memset(&key, 0, sizeof(key));
      memset(&data, 0, sizeof(data));
      GetKeyDBT(k,&key);
      data.data = 0;
      data.size = 0;
      int ret;
      bool r;

      if ((ret = dbp->get(dbp, NULL, &key, &data, 0)) == 0) {
         d = GetData(&data);
         r = true;
      }
      else {
         r = false;
      }
      return r;
   }

   void put(const Key & k, const Data & d) {
      memset(&key, 0, sizeof(key));
      memset(&data, 0, sizeof(data));
      GetKeyDBT(k, &key);
      GetDataDBT(d, &data);
      int ret;

      if((ret = dbp->put(dbp, NULL, &key, &data, 0)) == 0)
         ;
      else {
         throw db_exception();
      }
   }

   void del(const Key & k) {
      memset(&key, 0, sizeof(key));
      memset(&data, 0, sizeof(data));
      GetKeyDBT(k,  &key);
      data.data = 0;
      data.size = 0;
      int ret;

      if ((ret = dbp->del(dbp, NULL, &key, 0)) == 0)
         ;
      else {
         throw db_exception();
      }
   } 

   iterator begin() {
      DBC * dbc;

      if(dbp->cursor(dbp, NULL, &dbc, 0) != 0) {
         throw db_exception();
      }

      return iterator(dbc, GetKey, GetData);
   }
};

}

#endif /* _HASHTABLE_H */
