#ifndef _REC_TABLE_H
#define _REC_TABLE_H

#include <sys/types.h>
#include <cstdio>
#include <cstring>
#include <cstdlib>
#include <db.h>

namespace db_tools {

using namespace std;

struct db_exception { };

template< class Data >
class rec_table_iterator {
public:
   typedef Data (*GetData_type)(DBT *);

private:
   DBC * dbc;
   DBT key,data;
   GetData_type GetData;

public:
   rec_table_iterator() { 
      memset(&key, 0, sizeof(DBT));
      memset(&data, 0, sizeof(DBT));
      dbc = 0;
   }

   rec_table_iterator(const rec_table_iterator & cp) {
      dbc = cp.dbc;
      GetData = cp.GetData;
      key = cp.key;
      data = cp.data;
   }

   rec_table_iterator(DBC * dbc,
                      GetData_type gd) {
      this->dbc = dbc;
      GetData = gd;
      memset(&key, 0, sizeof(DBT));
      memset(&data, 0, sizeof(DBT));
   }

   ~rec_table_iterator() {

   }

   void close() {
      dbc->close(dbc);
   }

   rec_table_iterator & operator=(const rec_table_iterator & cp) {
      dbc = cp.dbc;
      GetData = cp.GetData;
      key = cp.key; 
      data = cp.data;
      return *this;
   }

   Data get_data() {
      return GetData(&data);
   }

   bool next() {
      bool ret;

      memset(&key, 0, sizeof(DBT));
      memset(&data, 0, sizeof(DBT));

      if(dbc->get(dbc, &key, &data, DB_NEXT) == 0) {
         ret = true; 
      }
      else {
         ret = false;
      }

      return ret;
   }
};

template< class Data > 
class rec_table {
   DB *dbp;
   DBT key,data;
   typedef void (*GetDataDBT_type)(const Data &, DBT *);
   typedef Data (*GetData_type)(DBT *);
   GetDataDBT_type GetDataDBT;
   GetData_type GetData;

public:
   typedef rec_table_iterator< Data > iterator;

   rec_table(const char * filename,
             GetDataDBT_type gd,
             GetData_type gd2) {
      GetDataDBT = gd;
      GetData = gd2;
      int ret;
      if ((ret = db_create(&dbp, NULL, 0)) != 0) {
         throw db_exception();
      }

      if ((ret = dbp->open(dbp,
           NULL, filename, NULL, DB_RECNO, DB_CREATE, 0664)) != 0) {
         throw db_exception();
      }
   }

   virtual ~rec_table() {
      if (dbp->close(dbp, 0) != 0)
         throw db_exception();
   }

   bool get(const db_recno_t & k, Data & d) {
      memset(&key, 0, sizeof(key));
      memset(&data, 0, sizeof(data));
      key.data = (void*)&k;
      key.size = sizeof(db_recno_t);
      data.data = 0;
      data.size = 0;
      int ret;
      bool r;

      if ((ret = dbp->get(dbp, NULL, &key, &data, 0)) == 0) {
         d = GetData(&data);
         r = true;
      }
      else {
         r = false;
      }
      return r;
   }

   void put(db_recno_t index, const Data & d) {
      memset(&key, 0, sizeof(key));
      memset(&data, 0, sizeof(data));
      key.data = (void*)&index;
      key.size = sizeof(db_recno_t);
     
      GetDataDBT(d, &data);
      int ret;

      if((ret = dbp->put(dbp, NULL, &key, &data, 0)) == 0)
         ;
      else {
         throw db_exception();
      }
   }

   void del(const db_recno_t & k) {
      memset(&key, 0, sizeof(key));
      memset(&data, 0, sizeof(data));
      key.data = (void*)&k;
      key.size = sizeof(db_recno_t);
      data.data = 0;
      data.size = 0;
      int ret;

      if ((ret = dbp->del(dbp, NULL, &key, 0)) == 0)
         ;
      else {
         throw db_exception();
      }
   } 

   iterator begin() {
      DBC * dbc;

      if(dbp->cursor(dbp, NULL, &dbc, 0) != 0) {
         throw db_exception();
      }

      return iterator(dbc, GetData);
   }
};

}

#endif /* _REC_TABLE_H */
