#include <iostream>
#include <fstream>
#include <string>
#include <sstream>
#ifdef WINDOWS_OS
#include <windows.h>
#endif
#include "detect_hacking.h"
#include "md5.h"

using namespace std;
using namespace security_tools;

void
security_tools::detect_hacking() throw(hacking_exception)
{
   string hash,the_name;

#ifdef UNIX_OS
   the_name = getprogname() + string(".md5");
   if(!compute_md5(getprogname(), hash)) {
      throw hacking_exception();
   }
#endif

#ifdef WINDOWS_OS
   TCHAR name[MAX_PATH + 1];
   GetModuleFileName(NULL, name, MAX_PATH + 1);
   the_name = (char*)name + string(".md5");
   if(!compute_md5(name, hash)) {
      throw hacking_exception();
   }
#endif

 
   string md5;
   ifstream fin(the_name.c_str(), ios::in);
   if(fin) {
      fin >> md5;
      fin.close();
   }
   else {
      throw hacking_exception();
   }

cerr << "PROG=" << md5 << endl;
cerr << hash << " == " << md5 << endl;
   
   if(hash != md5) {
      throw hacking_exception();
   }
}
