/*

BINARY FILE SEARCH TREE...

Author: Matthew W. Coan
Date: Thu Jun 22 15:33:34 EDT 2017

*/

#ifndef _D_MAP_H
#define _D_MAP_H

#include <iostream>
#include <algorithm>
#include <stack>
#include <list>
#include "disk_tools.h"
#include "bfstream.h"
#include "bsstream.h"


namespace disk_tools {

using namespace std;

enum { TREE_ORDER = 64 };

template< class Key, class Data >
class d_pair {
public:
   Key key;
   Data data;

   bool operator<(const d_pair< Key, Data > & val) const {
      return key < val.key;
   }

   d_pair< Key, Data > & operator=(const d_pair< Key, Data> & right) {
      key = right.key;
      data = right.data;
      return *this;
   }
};

template< class Key, class Data >
class d_map_node {
public:
   typedef list< d_map_node< Key, Data > * > node_list_type;
   typedef d_pair< Key, Data > pair_type;
   pair_type data[TREE_ORDER];
   offset_type address;
   offset_type left;
   offset_type right;
   offset_type parent;
   size_t size;
   d_map_node< Key, Data > * left0;
   d_map_node< Key, Data > * right0;
   d_map_node< Key, Data > * parent0;
   node_list_type * node_list;

   d_map_node(node_list_type * nl = 0) {
      left = right = address = parent = -1L;
      size = 0U;
      left0 = 0;
      right0 = 0;
      node_list = nl;
   }

   d_map_node(const d_map_node & node) {
      address = node.address;
      left = node.left;
      right = node.right;
      parent = node.parent;
      size = node.size;
      left0 = 0;
      right0 = 0;
      node_list = node.node_list;
      for(size_t i = 0; i < TREE_ORDER; i++)
         data[i] = node.data[i];
   }

   ~d_map_node() {
      //if(left0) delete left0;
      //if(right0) delete right0;
   }

   d_map_node & operator=(const d_map_node & right) {
      address = right.address;
      left = right.left;
      this->right = right.right;
      parent = right.parent;
      size = right.size;
      for(size_t i = 0; i < size; i++) {
         data[i].key = right.data[i].key;
         data[i].data = right.data[i].data;
      }
      node_list = right.node_list;
      left0 = 0;
      right0 = 0;
      parent0 = 0;
      return *this;
   }

   d_map_node * get_parent(bfstream & in) {
      if(parent == -1L) {
         return 0;
      }
      if(parent0) {
         return parent0;
      }
      d_map_node * ret = new d_map_node(node_list);
      ret->address = parent;
      ret->load(in);
      parent0 = ret;
      return ret;
   }

   d_map_node * get_left(bfstream & in) {
      if(left == -1L) {
         return 0;
      }
      if(left0) {
         return left0;
      }
      d_map_node * ret = new d_map_node(node_list);
      ret->address = left;
      ret->load(in);
      left0 = ret;
      return ret; 
   }

   d_map_node * get_right(bfstream & in) {
      if(right == -1L) {
         return 0;
      }
      if(right0) {
         return right0;
      }
      d_map_node * ret = new d_map_node(node_list);
      ret->address = right;
      ret->load(in);
      right0 = ret;
      return ret;
   }

   int get_left_count(bfstream & file) {
//cout << "get_left_count()..." << endl;
/*
      int ret = 0;
      d_map_node< Key, Data > * n = this;
      while(n) {
         n = n->get_left(file);
         ret++;
      }
      return ret;
*/
      int ret = 1;
      d_map_node< Key, Data > n;
      n.address = address;
      n.load(file);
      while(n.left != -1L) {
         ret++;
         n.address = n.left;
         n.load(file);
      }
      return ret;
   }

   int get_right_count(bfstream & file) {
//cout << "get_right_count()..." << endl;
/*
      int ret = 0;
      d_map_node< Key, Data > * n = this;
      while(n) {
//cout << "n->right == " << n->right << endl;
         n = n->get_right(file);
         ret++;
      }
      return ret;
*/
      int ret = 1;
      d_map_node< Key, Data > n;
      n.address = address;
      n.load(file);
      while(n.right != -1L) {
         ret++;
cout << "n.right == " << n.right << endl;
         n.address = n.right;
         n.load(file);
      }
      return ret;
   }

/*
   int get_left_count(bfstream & file) {
//cout << "get_left_count()..." << endl;
      int ret = 1;
      d_map_node< Key, Data > n;
      n.address = address;
      n.load(file);
      while(n.left != -1L) {
      	 ret++;
         n.address = n.left;
      	 n.load(file);
      }
      return ret;
   }

   int get_right_count(bfstream & file) {
//cout << "get_right_count()..." << endl;
      int ret = 1;
      d_map_node< Key, Data > n;
      n.address = address;
      n.load(file);
      while(n.right != -1L) {
      	 ret++;
         n.address = n.right;
      	 n.load(file);
      }
      return ret;
   }
*/

    void set_far_left(d_map_node * n, bfstream * file) {
       d_map_node * nn = get_left(*file), * temp;
 
       if(nn) {
       while(nn->left != -1L) {
 cout << "ADDRESS1: " << nn->address << endl;
          temp = nn;
          nn = n->get_left(*file);
          if(nn == 0) break;
       }
 
       if(nn == 0) {
          nn = temp;
       }
 
       nn->left = n->address;
       n->parent = nn->address;
 
       n->left0 = n->right0 = n->parent0 = 0;
       nn->left0 = nn->right0 = nn->parent0 = 0;
 
       n->store(*file);
       nn->store(*file);
       }
       else {
          left = n->address;
          left0 = 0;
          n->parent = address;
          store(*file);
       }
    }
 
    void set_far_right(d_map_node * n, bfstream * file) {
       d_map_node * nn = get_right(*file), * temp;
       if(nn) {
       while(nn->right != -1L) {
 cout << "ADDRESS2: " << nn->address << endl;
          temp = nn;
          nn = n->get_right(*file);
          if(nn == 0) break;
       }
 
       if(nn == 0) {
          nn = temp;
       }
 
       nn->right = n->address;
       n->parent = nn->address;
 
       n->left0 = n->right0 = n->parent0 = 0;
       nn->left0 = nn->right0 = nn->parent0 = 0;
 
       n->store(*file);
       nn->store(*file);
       }
       else {
          right = n->address;
          right0 = 0;
          n->parent = address;
          store(*file);
       }
    }


   void shift_right4(bfstream & file, d_map_node< Key, Data > & root) {
      d_map_node< Key, Data > *n1,*n2,*n3,*n4,*n5,*n6/*,temp1,temp2,temp3*/;

      //n1.address = address;
      //n1.load(file);

      //n2.address = right;
      //n2.load(file);

      //n3.address = n2.right;
      //n3.load(file);

      n1 = this;

      n2 = n1->get_right(file);

      n3 = n2->get_right(file);

      if(n1->parent != -1L) {
         n6 = n1->get_parent(file);
         n6->load(file);
	 if(n6->right == n1->address)
            n6->right = n3->address;
         else
            n6->left = n3->address;
         n6->store(file);
         if(n6->address == root.address)
            root.load(file);
      }

      offset_type temp1, temp2;

      temp1 = n3->left;
      n3->left = n2->address;
      n3->parent = n1->parent;

      temp2 = n2->left;
      n2->right = temp1;
      n2->left = n1->address;
      n2->parent = n3->address;

      n1->right = temp2;
      n1->parent = n2->address;

      n1->store(file);
      n2->store(file);
      n3->store(file);

      if(address == root.address) {
         root.address = n3->address;
         root.load(file);
      }
      address = n3->address;
      load(file);
   }

   void shift_left4(bfstream & file, d_map_node< Key, Data > & root) {
      d_map_node< Key, Data > *n1,*n2,*n3,*n4,*n5,*n6/*,temp1,temp2,temp3*/;

/*
      n1.address = address;
      n1.load(file);

      n2.address = left;
      n2.load(file);

      n3.address = n2.left;
      n3.load(file);

      n4.address = n3.left;
      n4.load(file);
*/

      n1 = this;

      n2 = n1->get_left(file);
 
      n3 = n2->get_left(file);

      n4 = n3->get_left(file);

      if(n1->parent != -1L) {
         n6= n1->get_parent(file);
         n6->load(file);
         if(n6->left == n1->address)
            n6->left = n3->address;
         else
            n6->right = n3->address;
         n6->store(file);
         if(n6->address == root.address)
            root.load(file);
      }

      offset_type temp1, temp2;

      temp1 = n3->right;
      n3->right = n2->address;
      n3->parent = n1->parent;

      temp2 = n2->right;
      n2->left = temp1;
      n2->right = n1->address;
      n2->parent = n3->address;

      n1->left = temp2;
      n1->parent = n2->address;

      n1->store(file);
      n2->store(file);
      n3->store(file);

      if(address == root.address) {
         root.address = n3->address;
         root.load(file);
      }

      address = n3->address;
      load(file);
   }

   void shift_left(bfstream & file, d_map_node< Key, Data > & root) {
      d_map_node< Key, Data> *n1,*n2,*n3,*n4;

/*
      n1.address = address;
      n1.load(file);

      n2.address = left;
      n2.load(file);

      n3.address = n2.left;
      n3.load(file);
*/

      n1 = this;

      n2 = n1->get_left(file);

      n3 = n2->get_left(file);

      if(n1->parent != -1L) {
         n4 = n1->get_parent(file);
         n4->load(file);
         if(n4->right == n1->address)
            n4->right = n2->address;
         else
            n4->left = n2->address;
         n4->store(file);
         if(n4->address == root.address)
            root.load(file);
      }

      n1->parent = n2->address;
      n3->parent = n2->address;
      n2->parent = parent;

      n1->left = n2->right;

      n2->left = n3->address;
      n2->right = n1->address;

      n1->store(file);
      n2->store(file);
      n3->store(file);

      if(address == root.address) {
         root.address = n2->address;
         root.load(file);
      }

      address = n2->address;
      load(file);
   }

   void shift_right(bfstream & file, d_map_node< Key, Data > & root) {
      d_map_node< Key, Data > *n1,*n2,*n3,*n4;

/*
      n1.address = address;
      n1.load(file);

      n2.address = right;
      n2.load(file);

      n3.address = n2.right;
      n3.load(file);
*/

      n1 = this;

      n2 = n1->get_right(file);
 
      n3 = n2->get_right(file);

      if(n1->parent != -1L) {
         n4 = n1->get_parent(file);
         n4->load(file);
         if(n4->right == n1->address)
            n4->right = n2->address;
         else
            n4->left = n2->address;
         n4->store(file);
         if(n4->address == root.address) 
            root.load(file);
      }

      n2->parent = parent;
      n1->parent = n2->address;
      n3->parent = n2->address;

      n1->right = n2->left;

      n2->left = n1->address;
      n2->right = n3->address;
 
      n1->store(file);
      n2->store(file);
      n3->store(file);

      if(address == root.address) {
         root.address = n2->address;
         root.load(file);
      }

      address = n2->address;
      load(file);
   } 
   
   void load(bfstream & in) {
      left0 = 0;
      right0 = 0;
      parent0 = 0;
      if(address != -1L) {
         in.seek(address);
         in >> left;
         in >> right;
         in >> parent;
         in >> size;
         in >> address;
         for(size_t i = 0; i < size; i++) {
            in >> data[i].key;
            in >> data[i].data;
         }
      }
   }

   void store(bfstream & out) {
      if(address != -1L) {
         out.seek(address);
         out << left;
         out << right;
         out << parent;
         out << size;
         out << address;
         for(size_t i = 0; i < TREE_ORDER; i++) {
            out << data[i].key;
            out << data[i].data;
         }
      }
   }

   void sort() {
      std::sort(data, data+size);
   }

   Key get_right_most_value(bfstream & file) {
      Key key;
      if(right != -1L) {
         d_map_node< Key, Data > n;
//cout << "LOAD A: " << right << endl;
         n.address = right;
         n.load(file);
         while(n.left != -1L) {
            n.address = n.left;
            n.load(file);
         } 
         key = n.data[0].key;
      }
      return key;
   }

   Key get_left_most_value(bfstream & file) {
      Key key;
      if(left != -1L) {
         d_map_node< Key, Data > n;
//cout << "LOAD B: " << left << endl;
         n.address = left;
         n.load(file);
         while(n.right != -1L) {
            n.address = n.right;
            n.load(file);
         }
         key = n.data[n.size-1].key;
      }
      return key;
   }
};

template< class Key, class Data >
class d_map {
public:
   typedef d_map_node< Key, Data > node_type;
   typedef list< d_map_node< Key, Data > * > node_list_type;

private:
   node_type root;
   d_alloc * alloc;
   offset_type addr;
   d_database * db_ptr;
   offset_type the_size;
   bfstream * file;
   int full_count;
   node_list_type node_list;
   size_t cash_size;

public:
   d_map(const string & name, d_env * env = p_d_env) {
      file = 0;
      alloc = 0;
      addr = -1L;
      the_size = 0L;
      db_ptr = env->get_db();
      alloc = env->get_alloc();
      db_ptr->grab(name, *this);
      full_count = 0;
      cash_size = 1024;
   }

   void grab(bfstream * file, offset_type addr, d_alloc * alloc, d_database * db_ptr) {
      this->file = file;
      this->alloc = alloc;
      this->addr = addr;
      this->db_ptr = db_ptr;
      file->seek(addr);
      *file >> the_size;
      if(the_size == -1L) {
         the_size = 0L;
         file->seek(addr);
         *file << the_size;
      }
      root.address = alloc->allocate(sizeof(node_type));
      root.store(*file);
   }

   void clear_node_list() {
      //if(node_list.size() >= cash_size) {
         for(typename node_list_type::iterator ptr = node_list.begin(); ptr != node_list.end(); ptr++) {
            if((*ptr)->left0) delete (*ptr)->left0;
            if((*ptr)->right0) delete (*ptr)->right0;
            delete *ptr;
         }
         node_list.clear();
         root.left0 = root.right0 = 0;
      //}
   }

   void make_even() {
cout << "staiten..." << endl;
      stack< node_type* > stk;
      map< offset_type, bool > visited;
      //stk.push(&root);
      node_type * n, * left, * right, * temp_left, * temp_right;
      bool new_st = true;
      while(new_st) {
cout << "new_st" << endl;
         new_st = false;
         stk = stack< node_type* >();
         stk.push(&root);
         //visited.clear();
         while(stk.size()) {
//cout << "stk=" << stk.size() << endl;
            n = stk.top();
            stk.pop();
//cout << "[" << n->address << "]" << endl;
            if((left = n->get_left(*file)) && visited.find(left->address) == visited.end()) {
               stk.push(left);
            }
            if((right = n->get_right(*file)) && visited.find(right->address) == visited.end()) {
               stk.push(right);
            }
            if(visited.find(n->address) != visited.end())
               continue;
            visited[n->address] = true;
//cout << "NODE: " << n->address << endl;
            if(left == 0 && right != 0) {
               temp_left = right->get_left(*file);
               temp_right = right->get_right(*file);
               if(temp_left != 0 && temp_right == 0) {
                  temp_left->parent = n->address;
                  n->right = temp_left->address;
                  temp_left->set_far_right(right, file);

                  n->left0 = n->right0 = n->parent0 = 0;
                  right->left0 = right->right0 = right->parent0 = 0;
                  temp_left->left0 = temp_left->right0 = temp_left->parent0 = 0;

                  n->store(*file);
                  right->store(*file);
                  temp_left->store(*file);

                  visited[n->address] = true;
                  visited[right->address] = true;
                  visited[temp_left->address] = true;

                  //stk = stack< node_type* >();
                  //stk.push(&root);

                  //new_st = true;
                  //break;
cout << "RIGHT SWAP..." << endl;
cout << "ADDRESS: " << n->address << endl;
               }
            }
            else if(left != 0 && right == 0) {
               temp_left = left->get_left(*file);
               temp_right = left->get_right(*file);
               if(temp_left == 0 && temp_right != 0) {
                  temp_right->parent = n->address;
                  n->left = temp_right->address;
                  temp_right->set_far_left(left, file);

                  n->left0 = n->right0 = n->parent0 = 0;
                  left->left0 = left->right0 = left->parent0 = 0;
                  temp_right->left0 = temp_right->right0 = temp_right->parent0 = 0;

                  n->store(*file);
                  left->store(*file);
                  temp_right->store(*file);

                  visited[n->address] = true;
                  visited[left->address] = true;
                  visited[temp_right->address] = true;

                  //stk = stack< node_type* >();
                  //stk.push(&root);

                  //new_st = true;
                  //break;
cout << "LEFT SWAP..." << endl;
cout << "ADDRESS: " << n->address << endl;
               }
            }
         }
      }
cout << "done staiten..." << endl;
   }

   void balance() {
      stack< offset_type > stk;
      map< offset_type, bool > visit;
      node_type n;
      bool do_it = true;
      int l,r;
      bool first = true;
      clear_node_list();
      //while(do_it) {
         do_it = false;
         stk = stack< offset_type >();
         stk.push(root.address); 
         visit.clear();
         while(stk.size()) {
            n.address = stk.top();
            stk.pop();
            n.load(*file);
/*
            if(visit.find(n.address) != visit.end()) {
               if(n.right != -1L && visit.find(n.right) == visit.end())
                  stk.push(n.right);
               if(n.left != -1L && visit.find(n.left) == visit.end())
                  stk.push(n.left);
               continue;
            }
            visit[n.address] = true;
*/
            if(n.address == root.address) {
               root.parent0 = root.left0 = root.right0 = 0;
            }
            //n.parent0 = n.left0 = n.right0 = 0;
            if((l = n.get_left_count(*file)) > (r = n.get_right_count(*file))) {
            	while((l - r) >= 3) {
cout << "while1" << endl;
                  //n.parent0 = n.left0 = n.right0 = 0;
                  n.shift_left4(*file, root);
cout << "did shift_left4" << endl;
                  //n.parent0 = n.left0 = n.right0 = 0;
                  l = n.get_left_count(*file);
                  r = n.get_right_count(*file);
                  do_it = true;
               }

               while((l - r) >= 2) {
cout << "while2" << endl;
                  //n.parent0 = n.left0 = n.right0 = 0;
                  n.shift_left(*file, root);
                  //n.parent0 = n.left0 = n.right0 = 0;
                  l = n.get_left_count(*file);
                  r = n.get_right_count(*file);
                  do_it = true;
               }

               //if(do_it) break;
            }
            else if((r = n.get_right_count(*file)) > (l = n.get_left_count(*file))) {
               while((r - l) >= 3) {
cout << "while3" << endl;
                  //n.parent0 = n.left0 = n.right0 = 0;
                  n.shift_right4(*file, root);
                  //n.parent0 = n.left0 = n.right0 = 0;
                  l = n.get_left_count(*file);
                  r = n.get_right_count(*file);
                  do_it = true;
               }

               while((r - l) >= 2) {
cout << "while4" << endl;
                  //n.parent0 = n.left0 = n.right0 = 0;
                  n.shift_right(*file, root);
                  //n.parent0 = n.left0 = n.right0 = 0;
                  l = n.get_left_count(*file);
                  r = n.get_right_count(*file);
                  do_it = true;
               }
 
               //if(do_it) break;
            }
            //n.parent0 = n.left0 = n.right0 = 0;
            if(n.left != -1L /*&& visit.find(n.left) == visit.end()*/)
               stk.push(n.left);
            if(n.right != -1L /*&& visit.find(n.right) == visit.end()*/)
               stk.push(n.right);
         }
      //}
cout << "done in balance..." << endl;
   }

   bool insert(const Key & key, const Data & data) {
cout << "insert(" << key << "," << data << ")" << endl;
      bool ret = false;
      node_type * n = &root, * temp;
      bool full = false;
      Key temp_key;
      //full_count = 0;
      while(n) {
         if(n->size < TREE_ORDER && key > n->data[0].key && n->right == -1L) {
cout << "1" << endl;
            the_size++;
            file->seek(addr);
            *file << the_size;
            n->size++; 
            n->data[n->size-1].key = key;
            n->data[n->size-1].data = data;
            n->sort();
            n->store(*file);
            if(n->size == TREE_ORDER) {
               full_count++;
               full = true;
            }
            ret = true;
            break;
         }
         else if(n->size < TREE_ORDER && key < n->data[n->size-1].key && n->left == -1L) {
cout << "2" << endl;
            the_size++;
            file->seek(addr);
            *file << the_size;
            n->size++;
            n->data[n->size-1].key = key;
            n->data[n->size-1].data = data;
            n->sort();
            n->store(*file);
            if(n->size == TREE_ORDER) {
               full_count++;
               full = true;
            }
            ret = true;
cout << "done..." << endl;
            break;
         }
         else if(n->size < TREE_ORDER && key > n->data[0].key && key < n->data[n->size-1].key) {
cout << "3" << endl;
            the_size++;
            the_size++;
            file->seek(addr);
            *file << the_size;
            n->size++;
            n->data[n->size-1].key = key;
            n->data[n->size-1].data = data;
            n->sort();
            n->store(*file);
            if(n->size == TREE_ORDER) {
               full_count++;
               full = true;
            }
            ret = true;
            break;
         }
         else if(n->size < TREE_ORDER && n->left != -1L && key > n->get_left_most_value(*file) && key < n->data[n->size-1].key) {
cout << "4" << endl;
            the_size++;
            file->seek(addr);
            *file << the_size;
            n->size++;
            n->data[n->size-1].key = key;
            n->data[n->size-1].data = data;
            n->sort();
            n->store(*file);
            if(n->size == TREE_ORDER) {
               full_count++;
               full = true;
            }
            ret = true;
            break;
         }
         else if(n->size < TREE_ORDER && n->right != -1L && key > n->data[0].key && key < n->get_right_most_value(*file)) {
cout << "5" << endl;
            the_size++;
            file->seek(addr);
            *file << the_size;
            n->size++;
            n->data[n->size-1].key = key;
            n->data[n->size-1].data = data;
            n->sort();
            n->store(*file);
            if(n->size == TREE_ORDER) {
               full_count++;
               full = true;
            }
            ret = true;
            break;
         }
         else if(n->size == TREE_ORDER && key > n->data[0].key && key < n->data[n->size-1].key) {
cout << "6" << endl;
            ret = true;
            Key temp_key = n->data[0].key;
            Data temp_data = n->data[0].data;
            for(int i = 0; i < n->size-1; i++) {
               n->data[i] = n->data[i+1];
            }
            n->data[n->size-1].key = key;
            n->data[n->size-1].data = data;
            n->sort();
            n->store(*file);
            insert(temp_key, temp_data);
cout << "done in 6" << endl;
            break;
         }
         else {
            if(key < n->data[0].key && n->size == TREE_ORDER) {
//cout << "7" << endl;
               temp = n->get_left(*file);
               if(temp) {
                  n = temp;
               }
               else {
                  offset_type tt = n->left;
                  the_size++;
                  file->seek(addr);
                  *file << the_size;
                  n->left = alloc->allocate(sizeof(node_type));
                  n->left0 = 0;
                  n->store(*file);
                  node_type t;
                  t.address = n->left;
                  t.parent = n->address;
                  t.data[0].key = key;
                  t.data[0].data = data;
                  t.size = 1;
                  t.left = tt;
                  t.store(*file);
                  ret = true;
                  break;
               }
            }
            else if(key > n->data[n->size-1].key && n->size == TREE_ORDER) {
cout << "8" << endl;
               temp = n->get_right(*file);
               if(temp) {
                  n = temp;
               }
               else {
                  offset_type tt = n->right;
                  n->right = alloc->allocate(sizeof(node_type));
                  n->right0 = 0;
                  n->store(*file);
                  the_size++;
                  file->seek(addr);
                  node_type t;
                  *file << the_size;
                  t.address = n->right;
                  t.parent = n->address;
                  t.data[0].key = key;
                  t.data[0].data = data;
                  t.size = 1;
                  t.right = tt;
                  t.store(*file);
                  ret = true;
                  break;
               }
            }
            else if(n->size < TREE_ORDER && key > n->data[n->size-1].key) {
cout << "9" << endl;
               temp = n->get_right(*file);
               if(temp) {
                  n = temp;
               }
               else {
                  the_size++;
                  file->seek(addr);
                  *file << the_size;
                  n->size++;
                  n->right0 = 0;
                  n->data[n->size-1].key = key;
                  n->data[n->size-1].data = data;
                  n->sort();
                  n->store(*file);
                  ret = true;
                  break;
               }
            }
            else if(n->size < TREE_ORDER && key < n->data[0].key) {
cout << "10" << endl;
               temp = n->get_left(*file);
               
               if(temp) {
               	  n = temp;
               }
               else {
                  the_size++;
                  file->seek(addr);
                  *file << the_size;
                  n->size++;
                  n->left0 = 0;
                  n->data[n->size-1].key = key;
                  n->data[n->size-1].data = data;
                  n->sort();
                  n->store(*file);
                  ret = true;
                  break;
               }
               
            }
            else {
cout << "UNKNOWN..." << endl;
cout << "key = " << key << endl;
cout << "n->size = " << n->size << endl;
cout << "n->data[0] = " << n->data[0].key << endl;
cout << "n->data[n->size-1] = " << n->data[n->size-1].key << endl;
cout << "n->left = " << n->left << endl;
cout << "n->right = " << n->right << endl;
cout << "n->get_left_most_value() = " << n->get_left_most_value(*file) << endl;
cout << "n->get_right_most_value() = " << n->get_right_most_value(*file) << endl;
cin.get();cin.get();
            }
         }
      }
cout << "insert almost done..." << endl;

      //make_even();

      if(full_count == 3) {
      	 full_count = 0;
cout << "balnce next..." << endl;
         balance();
cout << "done balance..." << endl;
         //clear_node_list();
      }

      return ret;
   }

   bool update(const Key & key, const Data & data) {
      bool ret = false;
      node_type * n = &root, * temp;
      n->load(*file);
      d_pair< Key, Data > val;
      int index;
      while(n) {
         if(n->size == 0) {
            break;
         }
         else {
            if(key < n->data[0].key) {
               temp = n;
               n = n->get_left(*file);
            }
            else if(key > n->data[n->size-1].key) {
               temp = n;
               n = n->get_right(*file);
            }
            else {
               if((index = bin_search(n, key)) >= 0) {
                  ret = true;
                  n->data[index].data = data;
                  n->store(*file);
               }
               break;
            }
         }
      }

      return ret;
   }

   bool put(const Key & key, const Data & data) {
      bool ret = false;
      if(the_size == 0L) {
         root.address = alloc->allocate(sizeof(node_type));
         root.data[0].key = key;
         root.data[0].data = data;
         root.size++;
         root.store(*file);
         the_size++;
         file->seek(addr);
         *file << the_size << root.address;
         ret = true;
      }
      else if(!update(key, data)) {
         insert(key, data);
cout << "done in put" << endl;
         ret = true;
      }
      return ret;
   }

   int bin_search(node_type * n, const Key & key) {
      int ret = -1;
      for(int i = 0; i < n->size; i++) {
         if(key == n->data[i].key) {
            ret = i;
            break;
         }
      }
      return ret;
/*
      int max = n->size -1 , min = 0;
      int mid;
      while(max >= min) {
         mid = (min + max) / 2;
         if(n->data[mid].key < key) 
            min = mid + 1;
         else if(n->data[mid].key > key)
            max = mid - 1;
         else 
            return mid;
      }
      return std::min(min, max);
*/
   }

   bool get(const Key & key, Data & data) {
      bool ret = false;
      node_type * n = &root, * temp;
      int index;
      while(n) {
         if(key < n->data[0].key) {
            temp = n;
            n = n->get_left(*file);
         }
         else if(key > n->data[n->size-1].key) {
            temp = n;
            n = n->get_right(*file);
         }
         else {
            if((index = bin_search(n, key)) != -1) {
               data = n->data[index].data;
               ret = true;
            }
            break;
         }
      }

      return ret;
   }

   void print_indent(ostream & out, int indent) {
      for(size_t i = 0; i < indent; i++)
         out << "   " << flush;
   }

   void print_tree_node(d_map_node< Key, Data > * n, ostream & out, int indent = 0) {
      print_indent(out, indent);
      out << n->data[0].key << endl;
      if(n->left != -1L) {
         node_type nn;
         nn.address = n->left;
         nn.load(*file);
         print_tree_node(&nn, out, indent+1);
      }
      if(n->right != -1L) {
         node_type nn;
         nn.address = n->right;
         nn.load(*file);
         print_tree_node(&nn, out, indent+1);
      }
   }

   void print_tree(ostream & out) {
      d_map_node< Key, Data > temp;
      temp.address = root.address;
      temp.load(*file);
      print_tree_node(&temp, out);
   }
};

}

#endif
