#include "disk_tools.h"
#include "d_hashmap.h"
#include "../text_tools/hashpjw.h"
#include <iostream>
#include <limits.h>

using namespace std;
using namespace io_tools;
using namespace disk_tools;

class string_hash {
public:
   offset_type operator()(const string & str) const {
      offset_type ret = 0L;
      ret = hashpjw(str.c_str(), 500029);
      return LONG_MAX - ret;
/*
      for(size_t i = 0; i < str.size(); i++)
         ret += str[i] * i;
      return ret * 100;
*/
   }
};

int
main(int argc, char ** argv)
{
   d_env env;

   p_d_env = & env;

   d_database * db = open_database("english");

   d_hashmap< string, string, string_hash >  word_map("word_map", 500029);
  
   string word;

   if(argc == 2) {
      word = argv[1];
   }
   else {
      cout << "word> ";
      cin >> word;
   }

   cout << (string)word_map[word] << endl;

   close_database(db);

   return 0;
}
