/**
 *
 * BTREE TEST PROGRAM...
 *
 * Author: Matthew W. Coan
 * Date: 7:44 PM 9/15/2016
 * 
 */

#include "btree.h"
#include <iostream>

using namespace std;

int
int_comp(const void * arg1, const void * arg2)
{
   int * p1 = (int*)arg1;
   int * p2 = (int*)arg2;
   int ret;
   
   if(p1[0] < p2[0]) 
      ret = -1;
   else if(p1[0] > p2[0]) 
      ret = 1;
   else 
      ret = 0;

   return ret;
}

int main(int argc, char* argv[])
{
   BTREE bt;
   int i;
   int key[2];
   int data[2];
   enum { N = 10 };

   bt = btree_Create(sizeof(int)*2, int_comp);
   
   if(bt == NULL) {
      cerr << "fail to create btree..." << endl;
      exit(1);
   }
   
   for(i = 0; i < N; i++) {
      key[0] = i;
      key[1] = 100 + i;

      btree_Insert(bt, key);
   }
   
   for(i = 0; i < N; i++) {
      key[0] = i;
      key[1] = 0;

      data[0] = 0;
      data[1] = 0;

      if(btree_Search(bt, key, data) == 0) {
         cout << data[0] << " -> " << data[1] << endl;
      }
   }

   btree_Destroy(bt);
	
   return 0;
}
