#include "tcp_server.h"

net_tools::tcp_server::tcp_server(const char * the_ip, 
                                  const int the_port)
:_ip_address(the_ip), _port(the_port)
{
   _fd = socket(AF_INET, SOCK_STREAM, 0);

   memset((char*)(&_svr), 0, sizeof(_svr));
   memset((char*)(&_cli), 0, sizeof(_cli));

   _svr.sin_family = AF_INET;
   _svr.sin_port = htons(_port);
   _svr.sin_addr.s_addr = inet_addr(_ip_address);
   
   bind(_fd, (const sockaddr *)(&_svr), sizeof(_svr));

   listen(_fd, SOMAXCONN);
}

net_tools::tcp_server::~tcp_server()
{
   ::closesocket(_fd);
}

int
net_tools::tcp_server::accept()
{
   socklen_t client = sizeof(_cli);
   return ::accept(_fd, (sockaddr*)(&_cli), &client);
}

void
net_tools::tcp_server::close()
{
   ::shutdown(_fd, SHUT_RDWR);
   ::closesocket(_fd);
}
