#!perl
#
#  DNS2Go perl script for Mac v1.0          http://www.dns2go.com
#
#  Deerfield.com					http://www.deerfield.com
#
#########################################################################

use LWP::UserAgent;
use HTTP::Request;

#########################################################################
# Put your DNS2Go domain name here
#########################################################################

$DNS2GoDomain = "";

#########################################################################
# Put your DNS2Go key here
#########################################################################

$DNS2GoKey = "";


#########################################################################
#
# result = DNS2GoUpdate( domain, key, state, [ip] )
#
#    domain =	Your DNS2Go domain name
#	 key =	Your DNS2Go key
#	 state =    1 = online, 0 = offline
#	 ip =		Your IP address. Optional, default is auto-detect
#
#########################################################################
sub DNS2GoUpdate
{
	# validate domain name
	if ( length($_[0]) < 5 )
	{
		return "Invalid domain name";
	}

	# validate key
	if ( length($_[1]) < 22 )
	{
		return "Invalid key";
	}

	$ua = new LWP::UserAgent;

	$ua->agent("DNS2GoPerlUpdater/0.1 " . $ua->agent);

	# build the requested URL
	$url = new URI::URL'http:://dns2go.com:83/';

	if( defined( $_[3] ) )
	{
		# specify the IP (online only)
		$url->query_form( fqdn => $_[0], key => $_[1], online => $_[2], ip => $_[3] );
	}
	else
	{
		# auto-detect the IP
		$url->query_form( fqdn => $_[0], key => $_[1], online => $_[2] );
	}

	# Create a request
	my $req = new HTTP::Request GET => $url;

	# Use a simple request because we expect a redirect
	my $res = $ua->simple_request($req);

	if ($res->is_redirect)
	{	
		$uri = URI->new( $res->header("Location") );

		%params = $uri->query_form();

		# get the results from the URL parameters 
		$result = $params{"statusMsg"};

		return $result;
	}
	else
	{
		# Error
		return $res->status_line;
	}		
}
