#ifndef _dynamic_code
#define _dynamic_code

/*

Copyright (C) 2011.  All rights reserved.
This software is the intellectual property of Matthew William Coan.


Author: Matthew William Coan
Date: Fri Jul 20 15:41:25 EDT 2012

*/

#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <stack>
#include <map>
#include <cstring>
#include <cstdlib>

namespace dynamic_code {

using namespace std;

typedef stack< int > int_stack_type;

int_stack_type * int_stack = 0;

const unsigned char START_CODE[] = { 85,137,229, };
const unsigned char CALL_CODE[] = { 104,0,0,0,0,186,0,0,0,0,255,226, };
const unsigned char CALL2_CODE[] = { 104,0,0,0,0,104,0,0,0,0,186,0,0,0,0,255,226, };
const unsigned char END_CODE[] = { 184,0,0,0,0,201,195, };
const unsigned char JMP_CODE[] = { 186,0,0,0,0,255,226, };
const unsigned char JZ_CODE[] = { 131,248,0,15,132,251,255,255,255, };

unsigned char PROGRAM[] = {
85,                     // push ebp
137,229,		// mov ebp,esp
104,0,0,0,0,		// push L1
186,0,0,0,0,		// mov edx,function
255,226,		// jmp edx
			// L1:
184,0,0,0,0, 		// mov eax,0
201, 			// leave
195			// ret 
};

int result = 0;

extern void dc_push(int arg);
extern void dc_jz(int arg);
extern void dc_je(int arg);
extern void dc_jmp(int arg);
extern void dc_print();
extern void dc_cmp(int arg);
extern void dc_pop();
extern void dc_iadd();
extern void dc_isub();
extern void dc_idiv();
extern void dc_imul();

extern "C" {
extern void do_jmp(unsigned int);
}

void dc_print() 
{
cout << "PRINT" << endl << flush;
   printf("%d\n", int_stack->top());
}

void dc_jmp(int arg)
{
cout << "JMP" << endl << flush;
   do_jmp(arg);
}

void dc_jz(int arg)
{
cout << "JZ " << arg << endl << flush;
   if(!result) {
//cout << "DO JMP" << endl << flush;
      do_jmp(arg);
//cout << "DID JMP" << endl << flush;
   }
}

void dc_je(int arg)
{
cout << "JE" << endl << flush;
   if(result) {
      do_jmp(arg);
   }
}

void dc_cmp(int arg)
{
cout << "CMP " << arg << endl << flush;
//cout << "int_stack->top() == " << int_stack->top() << endl << flush;
//cout << "int_stack->size() == " << int_stack->size() << endl << flush;
   if(int_stack->top() == arg) {
      result = 1;
   }
   else {
      result = 0;
   }
//cout << "result == " << result << endl << flush;
}

void dc_push(int arg)
{
cout << "PUSH " << arg << endl << flush;
   int_stack->push(arg);  
}

void dc_pop()
{
cout << "POP" << endl << flush;
   int ret  = 0;
   if(int_stack->size() >= 1) {
       ret = int_stack->top();
       int_stack->pop();
   }
}

void dc_iadd()
{
cout << "IADD" << endl << flush;
   int arg1;
   int arg2;

   arg1 = int_stack->top();
   int_stack->pop();

   arg2 = int_stack->top();
   int_stack->pop();

   int_stack->push(arg1+arg2);
}

void dc_isub()
{
cout << "ISUB" << endl << flush;
   int arg1;
   int arg2;

   arg1 = int_stack->top();
   int_stack->pop();

   arg2 = int_stack->top();
   int_stack->pop();

   int_stack->push(arg2-arg1);
}

void dc_idiv()
{
cout << "IDIV" << endl << flush;
   int arg1;
   int arg2;

   arg1 = int_stack->top();
   int_stack->pop();

   arg2 = int_stack->top();
   int_stack->pop();

   int_stack->push(arg1/arg2);
}

void dc_imul()
{
cout << "IMUL" << endl << flush;
   int arg1;
   int arg2;

   arg1 = int_stack->top();
   int_stack->pop();

   arg2 = int_stack->top();
   int_stack->pop();

   int_stack->push(arg1*arg2);
}


typedef void (*pf_t)();
typedef void (*pf2_t)(int);
typedef int (*pf3_t)();

void link_program(unsigned char * program, pf_t f) {
   unsigned int * push_addr = (unsigned int*)&program[4-3];
   unsigned int * jmp_addr = (unsigned int*)&program[9-3];
   *push_addr = (unsigned int)&program[16-3];
   *jmp_addr = (unsigned int)(f);
}

void link_program(unsigned char * program, pf2_t f) {
   unsigned int * push_addr = (unsigned int*)&program[4-3];
   unsigned int * jmp_addr = (unsigned int*)&program[9-3];
   *push_addr = (unsigned int)&program[16-3];
   *jmp_addr = (unsigned int)(f);
}
void link_program(unsigned char * program, pf3_t f) {
   unsigned int * push_addr = (unsigned int*)&program[4-3];
   unsigned int * jmp_addr = (unsigned int*)&program[9-3];
   *push_addr = (unsigned int)&program[16-3];
   *jmp_addr = (unsigned int)(f);
}

void link_program2(unsigned char * program, int arg) {
   unsigned int * arg_addr = (unsigned int*)&program[4-3];
   unsigned int * push_addr = (unsigned int*)&program[4-3+5];
   unsigned int * jmp_addr = (unsigned int*)&program[9-3+5];
   *arg_addr = arg;
   *push_addr = (unsigned int)&program[16-3+5];
   *jmp_addr = (unsigned int)(dc_push);
}

void link_program2(unsigned char * program, int arg, pf2_t f) {
   unsigned int * arg_addr = (unsigned int*)&program[4-3];
   unsigned int * push_addr = (unsigned int*)&program[4-3+5];
   unsigned int * jmp_addr = (unsigned int*)&program[9-3+5];
   *arg_addr = arg;
   *push_addr = (unsigned int)&program[16-3+5];
   *jmp_addr = (unsigned int)(f);
}

class Instruction {
public:
   string label;
   string op;
   string arg1; 

   Instruction(const string & label,
               const string & op,
               const string & arg1)
   {
      this->label = label;
      this->op = op;
      this->arg1 = arg1;
   }
};

class DynamicCodeException {
public:
   const char * message;
   DynamicCodeException(const char * m) { message = m; }
};

class DynamicCode {
public:
   typedef vector< Instruction* > instruction_vector_type;
   typedef map< string, unsigned int > label_map_type;

private:
   unsigned char * code;
   instruction_vector_type instruction_vec;
   label_map_type label_map;

   string read_line(ifstream & fin) {
      string str;
      char ch;
      ch = fin.get();
      while(fin && str.size() < 1024) {
         if(ch == '\n') break;
         str += ch;
         ch = fin.get();
      }
      return str;
   }

   Instruction* parse_instruction(const string & line) {
      string str;
      string label;
      string op;
      string arg1;
      if(line.find(":") != string::npos) {
         label = line.substr(0, line.size()-1);
         return new Instruction(label, "", "");
      }
      for(size_t i = 0; i < line.size(); i++) {
         if(isspace(line[i])) {
            if(str.size()) {
               op = str;
               str = "";
            } 
         }
         else {
            str += line[i];
         }
      }
      if(str.size() && op.size()) {
         arg1 = str;
      }
      else {
         op = str;
      }
      return new Instruction(label, op, arg1);
   }

   void read_program(const string & filename) {
      ifstream txt_in(filename.c_str(), ios::in);
      if(txt_in) {
         string line;
         Instruction * instruction;

         line = read_line(txt_in);
         while(txt_in) {
            instruction = parse_instruction(line);
            if(!instruction) break;
            instruction_vec.push_back(instruction);
            line = read_line(txt_in);
         }

         txt_in.close();
      }
   }

public:
   DynamicCode(const string & filename) {
     read_program(filename);
   }

   ~DynamicCode() {
cout << "DynamicCode..." << endl << flush;
      for(size_t i = 0; i < instruction_vec.size(); i++) {
         delete instruction_vec[i];
      }
cout << "Done Dynamic_code..." << endl << flush;
      instruction_vec.clear();
      if(code) delete [] code;
   }

   void bin_strcat(unsigned char * ptr, const unsigned char * ptr1, const size_t size)
   {
cout << "SIZE=" << size << endl << flush;
      for(size_t i = 0; i < size; i++) {
         (*ptr) = (*ptr1);
         ptr++;
         ptr1++;
      }
   }

   void write_address(unsigned char * ptr, unsigned char * ptr2) {
      (*((int*)ptr)) = (int)ptr2;
   }

   void print(unsigned char * ch, size_t size) {
      for(size_t i = 0; i < size; i++) {
         cout << "code == " << (int)(ch[i]) << endl << flush;
      }
   }

   void generate_code() {
      code = new unsigned char[1024 * 10];
      memset(code, 0, 1024*10);
      unsigned char * ptr = code;
      bin_strcat(ptr, START_CODE, 3);
      ptr += 3;
      for(size_t i = 0; i < instruction_vec.size(); i++) {
if(instruction_vec[i]->op.size())
cout << "INSTRUCTION: " << instruction_vec[i]->op << endl << flush;
else
cout << "INSTRUCTION: " << instruction_vec[i]->label << endl << flush;
         if(instruction_vec[i]->label.size()) {
            label_map[instruction_vec[i]->label] = (unsigned int)ptr;
            continue;
         }
         if(instruction_vec[i]->op == "push") {
            bin_strcat(ptr, CALL2_CODE, 17);
            link_program2(ptr, atoi(instruction_vec[i]->arg1.c_str()));
            ptr += 18;
         }
         else if(instruction_vec[i]->op == "cmp") {
            bin_strcat(ptr, CALL2_CODE, 17);
            link_program2(ptr, atoi(instruction_vec[i]->arg1.c_str()), dc_cmp);
            ptr += 18;
         }
         else if(instruction_vec[i]->op == "print") {
            bin_strcat(ptr, CALL_CODE, 12);
            link_program(ptr, dc_print);
            ptr += 13;
         }
         else if(instruction_vec[i]->op == "jz") {
            bin_strcat(ptr, CALL2_CODE, 17);
            unsigned int addr = label_map[instruction_vec[i]->arg1];
            link_program2(ptr, addr, dc_jz);
            ptr += 18;
         }
         else if(instruction_vec[i]->op == "je") {
            bin_strcat(ptr, CALL2_CODE, 17);
            unsigned int addr = label_map[instruction_vec[i]->arg1];
            link_program2(ptr, addr, dc_je);
            ptr += 18;
         }
         else if(instruction_vec[i]->op == "jmp") {
            bin_strcat(ptr, JMP_CODE, 7);
            unsigned int * p = (unsigned int*)&ptr[1];
            unsigned int addr = label_map[instruction_vec[i]->arg1];
            *p = (unsigned int)addr;
            ptr += 8;
         }
         else if(instruction_vec[i]->op == "pop") {
            bin_strcat(ptr, CALL_CODE, 12);
            link_program(ptr, dc_pop);
            ptr += 13;
         }
         else if(instruction_vec[i]->op == "iadd") {
            bin_strcat(ptr, CALL_CODE, 12);
            link_program(ptr, dc_iadd);
            ptr += 13;
         }
         else if(instruction_vec[i]->op == "isub") {
            bin_strcat(ptr, CALL_CODE, 12);
            link_program(ptr, dc_isub);
            ptr += 13;
         }
         else if(instruction_vec[i]->op == "idiv") {
            bin_strcat(ptr, CALL_CODE, 12);
            link_program(ptr, dc_idiv);
            ptr += 13;
         }
         else if(instruction_vec[i]->op == "imul") {
            bin_strcat(ptr, CALL_CODE, 12);
            link_program(ptr, dc_imul);
            ptr += 13;
         }
         else {
            throw DynamicCodeException("bad instruction...");
         }
      }
      bin_strcat(ptr, END_CODE, 7);
      ptr += 7;
   }

   void show_result() {
      cout << "stack size == " << int_stack->size() << endl << flush;
      if(int_stack->size()) {
         cout << "result == " << int_stack->top() << endl << flush;
      }
      else {
         cout << "empty stack..." << endl << flush;
      }
   }

   void run() {
cout << "dc_iadd: " << (unsigned int)(dc_iadd) << endl << flush;
cout << "dc_push: " << (unsigned int)(dc_push) << endl << flush;
cout << "dc_pop: " << (unsigned int)(dc_pop) << endl << flush;

      typedef void (*pf_t)();

      //link_program(code + 3);

      pf_t function = (pf_t)(code);

/*
      test_link();

      pf_t function = (pf_t)(PROGRAM);

      unsigned int * push_addr = (unsigned int*)&PROGRAM[4];

      unsigned int * jmp_addr = (unsigned int*)&PROGRAM[9];

      *push_addr = (unsigned int)&PROGRAM[16];

      *jmp_addr = (unsigned int)(dc_push);
*/

cout << "RUN NEXT..." << endl << flush;
 
      function();

cout << "DID RUN..." << endl << flush;
   }
};


}

#endif /* _dynamic_code */
