#include <fstream> 
#include <iostream>
#include <vector>
#include <cstring>

using namespace std;

enum { BUFFER_SIZE = 1024 };

void get_code(unsigned char * buffer, 
              ifstream & fin,  
              size_t & sz)
{
   unsigned char ch = fin.get();
   for(unsigned char * p = buffer; fin; p++) {
      *p = ch;
      sz++;
      ch = fin.get();
   }
}

int
main(int argc, char ** argv, char ** envp)
{
   int rc = 0;
   unsigned char buffer[BUFFER_SIZE];
   ifstream fin("code.o", ios::in | ios::binary);
   vector< unsigned char > code;
   if(fin) {
      size_t size = 0;
      get_code(buffer, fin, size);
      unsigned char START[] = "--START--";
      unsigned char END[] = "--END--";
      size_t i = 0;
      bool in = false;
      for(unsigned char * p = buffer; i < size; i++) {
         if(strncmp((char*)p, (const char*)START, 10) == 0) {
            cout << "START..." << endl << flush;
            code.clear();
            i += 10;
            p += 10;
            in = true;
         }
         else if(strncmp((char*)p, (const char*)END, 8) == 0) {
            for(size_t j = 0; j < code.size(); j++) {
               cout << (int)code[j] << "," << flush;
            }
            code.clear();
            cout << endl << flush;
            cout << "END..." << endl << flush;
            i += 8;
            p += 8;
            in = false;
         }
         else {
            if(in) code.push_back(*p);
            //cout << "CODE: " << (unsigned int)(*p) << endl << flush;
            p++;
         }
      }
      fin.close();
   }
   return rc;
}
