%{
#include "parser.h"
extern FILE * yyin;
using namespace parser;

int yyerror(const char * msg);

parser::Parser * parser::parser_pointer;

%}

%%

"+" {
   parser_pointer->add_token(Token(yytext, TOKEN_0));
   return TOKEN_0;
}

"-" {
   parser_pointer->add_token(Token(yytext, TOKEN_1));
   return TOKEN_1;
}

"*" {
   parser_pointer->add_token(Token(yytext, TOKEN_2));
   return TOKEN_2;
}

"/" {
   parser_pointer->add_token(Token(yytext, TOKEN_3));
   return TOKEN_3;
}

"(" {
   parser_pointer->add_token(Token(yytext, TOKEN_4));
   return TOKEN_4;
}

")" {
   parser_pointer->add_token(Token(yytext, TOKEN_5));
   return TOKEN_5;
}

"=" {
   parser_pointer->add_token(Token(yytext, TOKEN_6));
   return TOKEN_6;
}

[A-Za-z]([A-Za-z0-9])* {
   parser_pointer->add_token(Token(yytext, EXPR_TOKEN_0));
   return EXPR_TOKEN_0;
}

[0-9]+([\.][0-9]+)? {
   parser_pointer->add_token(Token(yytext, EXPR_TOKEN_1));
   return EXPR_TOKEN_1;
}

[\n] {
   parser_pointer->add_token(Token(yytext, EXPR_TOKEN_2));
   return EXPR_TOKEN_2;
}

[#](.*) {
   yywrap();
}

[\n\r] {
   yywrap();
}

[ \t] {
}

<<EOF>> {
  return 0;
}

[.] {
  throw "lex error...";
}


%%


int yywrap()
{
   return 1;
}

int yyerror(const char * msg)
{
   cerr << "error: " << msg << endl;
   exit(1);
   return 0;
}

#include "main.cpp"

