#include <string>
#include <fstream>

using namespace std;

int main(int argc, char ** argv, char ** envp)
{
   int rc = 0;

   yyin = stdin;

   try {
      map< string, double > sym_tbl;

      while(!feof(yyin)) {
         Parser the_parser("the_parser.dat");
         parser_pointer = &the_parser;
         parser_pointer->sym_tbl = sym_tbl;

         cout << "math> " << flush;

         while(yylex() != 1002)
            ;

         try {
            if(!parser_pointer->start()) {
               cout << "parse error..." << endl;
            }
         }
         catch(const char * msg) {
            cerr << "error: " << msg << endl;
         }

         sym_tbl = parser_pointer->sym_tbl;
      }
   } 
   catch(const char * message) {
      cerr << "exception: " << message << endl;
      exit(1);
   } 
   catch(...) {
      cerr << "unknown exception...\n" << endl;
      exit(1);
   }

   return rc;
}
