#ifndef _EBNF_PARSER_H
#define _EBNF_PARSER_H

#include <cctype>
#include <cstdlib>
#include <cstring>
#ifdef BOOTSTRAP
#include "my_new.h"
#endif
#include <string>
#include <typeinfo>
#include <iostream>
#include <fstream>
#include <sstream>
#include <vector>
#include <stack>
#include <list>
#include <map>
#include <sstream>
#include <cmath>
#include <algorithm>
#define error(msg) error_fun(msg,__FILE__,__LINE__)
extern int yylex();

extern FILE * yyin;

namespace parser {

using namespace std;

typedef vector< string > string_vector_type;

typedef list< string > string_list_type;

class Token {
public:
   string value;
   int type;
   Token() { }
   Token(const string & v, const int t) { value = v; type = t; }
   Token(const Token & t) { value = t.value; type = t.type; }
   ~Token() { }
   Token & operator=(const Token & r) { value = r.value; type = r.type; return *this; }
};

class Parser;

extern Parser * parser_pointer;

typedef vector< Token* > token_list_type;

class Parser {
   size_t offset;
   token_list_type token_list;
   string file;
   Token nil;
public:


string value;
string last_id;
int program_counter;
stack< double > stk;
map< string, double > sym_tbl;

class Instruction {
protected:
   Parser * p_parser;
   double arg1;
public:
   virtual ~Instruction() { }
   virtual void run() = 0;
};

class PUSH : public Instruction {
public:
   PUSH(Parser * pp, const string & arg) { arg1 = atof(arg.c_str()); p_parser = pp; }
   void run() {
      p_parser->stk.push(arg1);
      p_parser->program_counter++;
   }
};

class APUSH : public Instruction {
   string sarg1;
public:
   APUSH(Parser * pp, const string & arg) { sarg1 = arg; p_parser = pp; }
   void run() {
      p_parser->stk.push(p_parser->sym_tbl[sarg1]);
      p_parser->program_counter++;
   }
};

class APOP : public Instruction {
   string sarg1;
public:
   APOP(Parser * pp, const string & arg) { sarg1 = arg; p_parser = pp; }
   void run() {
      double value = p_parser->stk.top();
      p_parser->stk.pop();
      p_parser->sym_tbl[sarg1] = value;
      p_parser->program_counter++;
   }
};


class ADD : public Instruction {
public:
   ADD(Parser * pp) { p_parser = pp; }
   void run() {
      double arg2 = p_parser->stk.top();
      p_parser->stk.pop();
      double arg1 = p_parser->stk.top();
      p_parser->stk.pop();
      double result = arg1 + arg2;
      p_parser->stk.push(result);
      p_parser->program_counter++;
   } 
};

class SUB : public Instruction {
public:
   SUB(Parser * pp) { p_parser = pp; }
   void run() {
      double arg2 = p_parser->stk.top();
      p_parser->stk.pop();
      double arg1 = p_parser->stk.top();
      p_parser->stk.pop();
      double result = arg1 - arg2;
      p_parser->stk.push(result);
      p_parser->program_counter++;
   }
};

class MUL : public Instruction {
public:
   MUL(Parser * pp) { p_parser = pp; }
   void run() {
      double arg2 = p_parser->stk.top();
      p_parser->stk.pop();
      double arg1 = p_parser->stk.top();
      p_parser->stk.pop();
      double result = arg1 * arg2;
      p_parser->stk.push(result);
      p_parser->program_counter++;
   }
};

class DIV : public Instruction {
public:
   DIV(Parser * pp) { p_parser = pp; }
   void run() {
      double arg2 = p_parser->stk.top();
      p_parser->stk.pop();
      double arg1 = p_parser->stk.top();
      p_parser->stk.pop();
      double result = arg1 / arg2;
      p_parser->stk.push(result);
      p_parser->program_counter++;
   }
};

vector< Instruction* > code;

void clear_parser() {
   for(size_t i = 0; i < code.size(); i++) {
      delete code[i];
   }
   code.clear();
}

void run_program() {
   program_counter = 0;
   try {
      while(program_counter < code.size()) {
         code[program_counter]->run();
      }
   }
   catch(const char * message) {
      cerr << "error: " << message << endl;
   }
   if(stk.size()) {
      cout << stk.top() << endl;
      stk.pop();
   }
   for(size_t i = 0; i < code.size(); i++) {
      delete code[i];
   }
   code.clear();
   offset = 0;
}


   Parser(const string & file) { offset = 0; this->file = file; }
   void add_token(const Token & tok) {
      Token * p_token = new Token(tok);

      if(p_token != 0) {

         token_list.push_back(p_token);

      }

   }

   size_t get_offset() {
      return offset;

   }

   token_list_type & get_token_list() {
      return token_list;

   }

   size_t get_token_list_size() {
      return token_list.size();

   }

   Token & get_token(size_t offset) {
      while(token_list.size() <= offset) {
         if(!yylex()) break;
      }
      if(offset >= token_list.size()
         || token_list.size() == 0) {
         cerr << "index = " << offset << endl;
         cerr << "bad token index..." << endl;
         exit(1);
      }
      if(offset >= token_list.size()) return nil;
      return *token_list[offset];
   }

   bool match(int token_type, size_t offset) {
      bool ret = false;
      if(offset >= token_list.size()) return false;
      if(get_token(offset).type == token_type) {
         ret = true;
      }
      return ret;
   }

   bool match(const string & str, size_t offset) {
      bool ret = false;
      if(offset >= token_list.size()) return false;
      if(get_token(offset).value == str) {
         ret = true;
      }
      return ret;
   }

   void error_fun(const string & str, const char * file, int lineno) {
       offset = 0;

       throw "error...";

   }

   // production list

   bool start_error(bool & arg);
   bool end_error(bool & arg);
   bool IDENTIFIER();
   bool NUMBER();
   bool EOL();
   bool start();
   bool expression();
   bool production__1();
   bool term();
   bool production__2();
   bool factor();
   bool primary();
   bool identifier();
   bool number();
};

}

#define TOKEN_0 100
#define TOKEN_1 101
#define TOKEN_2 102
#define TOKEN_3 103
#define TOKEN_4 104
#define TOKEN_5 105
#define TOKEN_6 106
#define EXPR_TOKEN_0 1000
#define EXPR_TOKEN_1 1001
#define EXPR_TOKEN_2 1002

#endif /* _EBNF_PARSER_H */


