/*

FORM MAIL CGI PROGRAM...

Author: Matthew W. Coan
Date: Wed Apr  5 15:26:20 EDT 2017

*/
#include <iostream>
#include <fstream>
#include <string>
#include <cctype>
#include "cgi.h"
#include "smtp.h"
#include "config.h"

using namespace std;
using namespace cgi_tools;
using namespace mail_tools;

string filter(const string & str) {
   string ret;
   for(size_t i = 0; i < str.size(); i++) {
      if(isalnum(str[i]) || ispunct(str[i]) || isspace(str[i])) {
         ret += str[i];
      }
   }
   return ret;
}

string csv_escape(const string & str) {
   string ret;
   for(size_t i = 0; i < str.size(); i++) {
      if(str[i] == '\"') {
         ret += "\"\"";
      }
      else if(str[i] == '\n') {
         ret += "\\n";
      }
      else if(str[i] == '\r') {
         ret += "\\r";
      }
      else {
         ret += str[i];
      }
   }
   return ret;
}

string no_null(const char * value) {
   string ret;
   if(value != 0)
      ret = value;
   return filter(ret);
}

bool is_alpha(char ch) {
   return ((ch >= 'a' && ch <= 'z') || (ch >= 'A' && ch <= 'Z'));
}

bool is_digit(char ch) {
   return (ch >= '0' && ch <= '9');
}

bool is_good_email(const string & email) {
   bool ret = true;
   bool got_at = false;
   for(size_t i = 0; i < email.size(); i++) {
      if(email[i] == '@')
        got_at = true;
      else if(email[i] == '-' || email[i] == '.'
         || is_digit(email[i]) || is_alpha(email[i])) {
      }
      else { 
         ret = false;
         break;
      }
   }
   if(!got_at) 
      ret = false;
   return ret;
}

class FormMail {
   CGI form_data;
public:
   FormMail() { }
   ~FormMail() { }
   void send_error_page() {
      cout << "Location: " << ERROR_URL << "\r\n\r\n" << flush;
   }
   void run() {
      string name = no_null(form_data["name"]);
      string email = no_null(form_data["email"]);
      string subject = no_null(form_data["subject"]);
      string message = no_null(form_data["message"]);

      if(message.size() > MAX_MESSAGE 
         || name.size() > MAX_NAME
         || subject.size() > MAX_SUBJECT) {
         cout << "Location: " << ERROR_URL << "\r\n\r\n" << flush;
      }
      else if(name.size() && email.size() && subject.size() && message.size()
         && is_good_email(email)) {
         ofstream fout(LOG_FILE, ios::out | ios::app);
         if(fout) {
            fout << "\"" << csv_escape(name) << "\",\"" << csv_escape(email) << "\",\"" 
                 << csv_escape(subject) << "\",\"" << csv_escape(message) << "\"" << endl << flush;
            fout.close();

            smtp mail(SMTP_SERVER, SMTP_PORT);
            mail.set_to(MAIL_RECIPIENT);
            mail.set_from(email);
            mail.set_subject(subject);
            mail.set_message(name + "\r\n"
                             + email + "\r\n"
                             + message + "\r\n");
            mail.send();

            smtp mail2(SMTP_SERVER, SMTP_PORT);
            mail2.set_to(email);
            mail2.set_from(MAIL_FROM);
            mail2.set_subject(MAIL_SUBJECT);
            mail2.set_message(MAIL_MESSAGE);
            mail2.send();
            
            cout << "Location: " << SUCCESS_URL << "\r\n\r\n" << flush;
         }
         else {
            cout << "Location: " << ERROR_URL << "\r\n\r\n" << flush;
         }
      }
      else {
         cout << "Location: " << ERROR_URL << "\r\n\r\n" << flush;
      }
   }
};

int
main()
{
/*
    if(getenv("REQUEST_METHOD") == 0 || getenv("CONTENT_LENGTH") == 0) {
       cout << "Content-type: text/html\r\n\r\n" << flush;
       cout << "Must run as CGI..." << endl;
       exit(0);
    }
    if(strcmp(getenv("REQUEST_METHOD"), "POST") != 0) {
       cout << "Content-type: text/html\r\n\r\n" << flush;
       cout << "Must use METHOD=POST..." << endl;
       exit(0);
    }
*/
    try {
       FormMail form_mail;
       form_mail.run();
    }
    catch(...) {
       cout << "Location: " << ERROR_URL << "\r\n\r\n" << flush;
    }
    return 0;
}
