#ifndef _SMTP_H
#define _SMTP_H

/*

SMTP (SIMPLE MAIL TRANSFER PROTOCOL) CLIENT C++ CLASS...

Author: Matthew W. Coan
Date: Fri Jan  6 16:07:28 EST 2017

*/

#include <iostream>
#include <string>
#include "tcp_stream.h"

//#define SMTP_DEBUG

namespace mail_tools {

using namespace std;
using namespace net_tools;

class smtp {
   string server;
   string to;
   string cc;
   string bcc;
   string from;
   string subject;
   string message;
   int port;

   void read_response(tcp_stream & sock) {
      string buffer;
      char ch;
      ch = sock.get();
      while(sock) {
         if(ch == '\n')
            break;
         buffer += ch;
         ch = sock.get();
      }
#ifdef SMTP_DEBUG
      cout << buffer << endl;
#endif
   }
public:
   smtp(const string & server, const int port = 25) {
      this->server = server;
      this->port = port;
   }

   smtp(const smtp & cp) {
      server = cp.server;
      to = cp.to;
      cc = cp.cc;
      bcc = cp.bcc;
      from = cp.from;
      subject = cp.subject;
      message = cp.message;
      port = cp.port;
   }

   ~smtp() {
   }

   smtp & operator=(const smtp & cp) {
      server = cp.server;
      to = cp.to;
      cc = cp.cc;
      bcc = cp.bcc;
      from = cp.from;
      subject = cp.subject;
      message = cp.message;
      port = cp.port;
      return *this;
   }

   const string & get_to() { return to; }

   const string & get_from() { return from; }

   const string & get_cc() { return cc; }

   const string & get_bcc() { return bcc; }

   const string & get_subject() { return subject; }

   const string & get_message() { return message; }

   void set_to(const string & to) { this->to = to; }

   void set_from(const string & from) { this->from = from; }

   void set_cc(const string & cc) { this->cc = cc; }

   void set_bcc(const string & bcc) { this->bcc = bcc; }

   void set_subject(const string & subject) { this->subject = subject; }

   void set_message(const string & message) { this->message = message; }

   bool send() {
      bool ret = false;
      tcp_stream sock(server, port);
      if(sock) {
         read_response(sock);
         sock << "HELO " << server << "\r\n";
         read_response(sock);
         sock << "MAIL FROM: " << from << "\r\n";
         read_response(sock);
         sock << "RCPT TO: " << to << "\r\n";
         read_response(sock);
         if(cc.size()) {
            sock << "RCPT TO: " << cc << "\r\n";
            read_response(sock);
         }
         if(bcc.size()) {
            sock << "RCPT TO: " << bcc << "\r\n";
            read_response(sock);
         }
         sock << "DATA" << "\r\n";
         read_response(sock);
         sock << "From: " << from << "\r\n";
         sock << "To: " << to << "\r\n";
         if(cc.size()) 
            sock << "Cc: " << to << "\r\n";
         sock << "Subject: " << subject << "\r\n\r\n";
         sock << message << "\r\n";
         sock << ".\r\n";
         read_response(sock);
         sock << "QUIT\r\n";
         read_response(sock);
         sock.close();
         ret = true;
      }
      return ret;
   }
};

}

#endif /* _SMTP_H */
