// HELLO_ISAPI.CPP - Implementation file for your Internet Server
//    hello_isapi Extension

#include "stdafx.h"
#include "hello_isapi.h"

///////////////////////////////////////////////////////////////////////
// The one and only CWinApp object
// NOTE: You may remove this object if you alter your project to no
// longer use MFC in a DLL.

CWinApp theApp;

///////////////////////////////////////////////////////////////////////
// command-parsing map

BEGIN_PARSE_MAP(CHelloExtension, CHttpServer)
	// TODO: insert your ON_PARSE_COMMAND() and 
	// ON_PARSE_COMMAND_PARAMS() here to hook up your commands.
	// For example:

	ON_PARSE_COMMAND(Default, CHelloExtension, ITS_EMPTY)
	DEFAULT_PARSE_COMMAND(Default, CHelloExtension)
END_PARSE_MAP(CHelloExtension)


///////////////////////////////////////////////////////////////////////
// The one and only CHelloExtension object

CHelloExtension theExtension;


///////////////////////////////////////////////////////////////////////
// CHelloExtension implementation

CHelloExtension::CHelloExtension()
{
   count = 100;
}

CHelloExtension::~CHelloExtension()
{
}

BOOL CHelloExtension::GetExtensionVersion(HSE_VERSION_INFO* pVer)
{
	// Call default implementation for initialization
	CHttpServer::GetExtensionVersion(pVer);

	// Load description string
	TCHAR sz[HSE_MAX_EXT_DLL_NAME_LEN+1];
	ISAPIVERIFY(::LoadString(AfxGetResourceHandle(),
			IDS_SERVER, sz, HSE_MAX_EXT_DLL_NAME_LEN));
	_tcscpy(pVer->lpszExtensionDesc, sz);
	return TRUE;
}

BOOL CHelloExtension::TerminateExtension(DWORD dwFlags)
{
	// extension is being terminated
	//TODO: Clean up any per-instance resources
	return TRUE;
}

///////////////////////////////////////////////////////////////////////
// CHelloExtension command handlers

void CHelloExtension::Default(CHttpServerContext* pCtxt)
{
	StartContent(pCtxt);
	WriteTitle(pCtxt);

   count++;

   char buffer[128];
   memset(buffer, 0, 128);
   sprintf(buffer, "%d", count);

   *pCtxt << _T("<HTML>\r\n");
   *pCtxt << _T("<HEAD>\r\n");
   *pCtxt << _T("<TITLE>\r\n");
   *pCtxt << _T("Hello, World!\r\n");
   *pCtxt << _T("</TITLE>\r\n");
   *pCtxt << _T("<BODY BGCOLOR=\"WHITE\">\r\n");
	*pCtxt << _T("<H1>Hello, World!</H1>\r\n");
	*pCtxt << _T("<H1>count = ");
   *pCtxt << _T(buffer);
   *pCtxt << _T("</H1>\r\n");
   *pCtxt << _T("</BODY>\r\n");
   *pCtxt << _T("</HTML>\r\n");

	EndContent(pCtxt);
}

// Do not edit the following lines, which are needed by ClassWizard.
#if 0
BEGIN_MESSAGE_MAP(CHelloExtension, CHttpServer)
	//{{AFX_MSG_MAP(CHelloExtension)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
#endif	// 0



///////////////////////////////////////////////////////////////////////
// If your extension will not use MFC, you'll need this code to make
// sure the extension objects can find the resource handle for the
// module.  If you convert your extension to not be dependent on MFC,
// remove the comments arounn the following AfxGetResourceHandle()
// and DllMain() functions, as well as the g_hInstance global.

/****

static HINSTANCE g_hInstance;

HINSTANCE AFXISAPI AfxGetResourceHandle()
{
	return g_hInstance;
}

BOOL WINAPI DllMain(HINSTANCE hInst, ULONG ulReason,
					LPVOID lpReserved)
{
	if (ulReason == DLL_PROCESS_ATTACH)
	{
		g_hInstance = hInst;
	}

	return TRUE;
}

****/
