/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class AxisFault
extends RemoteException {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$AxisFault == null ? (class$org$apache$axis$AxisFault = AxisFault.class$("org.apache.axis.AxisFault")) : class$org$apache$axis$AxisFault).getName());
    private static final String LS = System.getProperty("line.separator");
    protected QName faultCode;
    protected String faultString = "";
    protected String faultActor;
    protected Vector faultDetails;
    static /* synthetic */ Class class$org$apache$axis$AxisFault;

    public static AxisFault makeFault(Exception e) {
        Throwable t;
        if (e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) instanceof Exception) {
            e = (Exception)t;
        }
        if (e instanceof AxisFault) {
            return (AxisFault)e;
        }
        return new AxisFault(e);
    }

    public AxisFault(String code, String str, String actor, Element[] details) {
        super(str);
        this.setFaultCode(new QName("http://xml.apache.org/axis/", code));
        this.setFaultString(str);
        this.setFaultActor(actor);
        this.setFaultDetail(details);
        if (details == null) {
            this.initFromException(this);
        }
    }

    public AxisFault(QName code, String str, String actor, Element[] details) {
        super(str);
        this.setFaultCode(code);
        this.setFaultString(str);
        this.setFaultActor(actor);
        this.setFaultDetail(details);
        if (details == null) {
            this.initFromException(this);
        }
    }

    protected AxisFault(Exception target) {
        super("", target);
        this.setFaultCode("Server.userException");
        this.initFromException(target);
    }

    public AxisFault(String message) {
        super(message);
        this.setFaultCode("Server.generalException");
        this.setFaultString(message);
        this.initFromException(this);
    }

    public AxisFault() {
        this.setFaultCode("Server.generalException");
        this.initFromException(this);
    }

    public AxisFault(String message, Throwable t) {
        super(message, t);
        this.setFaultCode("Server.generalException");
        this.setFaultString(message);
    }

    private void initFromException(Exception target) {
        Element el;
        int i = 0;
        while (this.faultDetails != null && i < this.faultDetails.size()) {
            Element element = (Element)this.faultDetails.elementAt(i);
            if ("stackTrace".equals(element.getLocalName()) && "http://xml.apache.org/axis/".equals(element.getNamespaceURI())) {
                return;
            }
            ++i;
        }
        this.setFaultString(target.toString());
        if (this.faultDetails == null) {
            this.faultDetails = new Vector();
        }
        if (target instanceof AxisFault && target.getClass() != (class$org$apache$axis$AxisFault == null ? (class$org$apache$axis$AxisFault = AxisFault.class$("org.apache.axis.AxisFault")) : class$org$apache$axis$AxisFault)) {
            el = XMLUtils.StringToElement("http://xml.apache.org/axis/", "exceptionName", target.getClass().getName());
            this.faultDetails.add(el);
        }
        el = XMLUtils.StringToElement("http://xml.apache.org/axis/", "stackTrace", JavaUtils.stackToString(target));
        this.faultDetails.add(el);
    }

    public void dump() {
        log.debug((Object)this.dumpToString());
    }

    public String dumpToString() {
        String details = new String();
        if (this.faultDetails != null) {
            int i = 0;
            while (i < this.faultDetails.size()) {
                Element e = (Element)this.faultDetails.get(i);
                details = details + LS + "\t" + e.getLocalName() + ": " + XMLUtils.getInnerXMLString(e);
                ++i;
            }
        }
        return "AxisFault" + LS + " faultCode: " + this.faultCode + LS + " faultString: " + this.faultString + LS + " faultActor: " + this.faultActor + LS + " faultDetail: " + details + LS;
    }

    public void setFaultCode(QName code) {
        this.faultCode = code;
    }

    public void setFaultCode(String code) {
        this.faultCode = new QName("http://xml.apache.org/axis/", code);
    }

    public QName getFaultCode() {
        return this.faultCode;
    }

    public void setFaultString(String str) {
        this.faultString = str != null ? str : "";
    }

    public String getFaultString() {
        return this.faultString;
    }

    public void setFaultActor(String actor) {
        this.faultActor = actor;
    }

    public String getFaultActor() {
        return this.faultActor;
    }

    public void setFaultDetail(Element[] details) {
        if (details == null) {
            return;
        }
        this.faultDetails = new Vector(details.length);
        int loop = 0;
        while (loop < details.length) {
            this.faultDetails.add(details[loop]);
            ++loop;
        }
    }

    public void setFaultDetailString(String details) {
        this.faultDetails = new Vector();
        Document doc = XMLUtils.newDocument();
        Element element = doc.createElement("string");
        Text text = doc.createTextNode(details);
        element.appendChild(text);
        this.faultDetails.add(element);
    }

    public void addFaultDetailString(String detail) {
        if (this.faultDetails == null) {
            this.faultDetails = new Vector();
        }
        Document doc = XMLUtils.newDocument();
        Element element = doc.createElement("string");
        Text text = doc.createTextNode(detail);
        element.appendChild(text);
        this.faultDetails.add(element);
    }

    public Element[] getFaultDetails() {
        if (this.faultDetails == null) {
            return null;
        }
        Element[] result = new Element[this.faultDetails.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (Element)this.faultDetails.elementAt(i);
            ++i;
        }
        return result;
    }

    public void output(SerializationContext context) throws Exception {
        SOAPEnvelope envelope = new SOAPEnvelope();
        SOAPFault fault = new SOAPFault(this);
        envelope.addBodyElement(fault);
        envelope.output(context);
    }

    public String toString() {
        return this.faultString;
    }

    public void printStackTrace(PrintStream ps) {
        ps.println(this.dumpToString());
        super.printStackTrace(ps);
    }

    public void printStackTrace(PrintWriter pw) {
        pw.println(this.dumpToString());
        super.printStackTrace(pw);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

