/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.attachments;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import org.apache.axis.Part;
import org.apache.axis.attachments.ManagedMemoryDataSource;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.SOAPUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AttachmentPart
extends javax.xml.soap.AttachmentPart
implements Part {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$attachments$AttachmentPart == null ? (class$org$apache$axis$attachments$AttachmentPart = AttachmentPart.class$("org.apache.axis.attachments.AttachmentPart")) : class$org$apache$axis$attachments$AttachmentPart).getName());
    DataHandler datahandler = null;
    private MimeHeaders mimeHeaders = new MimeHeaders();
    private String contentId;
    private String contentLocation;
    private Object contentObject;
    static /* synthetic */ Class class$org$apache$axis$attachments$AttachmentPart;

    public AttachmentPart() {
        this.addMimeHeader("Content-Id", SOAPUtils.getNewContentIdValue());
    }

    public AttachmentPart(DataHandler dh) {
        this.addMimeHeader("Content-Id", SOAPUtils.getNewContentIdValue());
        this.datahandler = dh;
        if (dh != null) {
            this.addMimeHeader("Content-Type", dh.getContentType());
        }
    }

    public DataHandler getActivationDataHandler() {
        return this.datahandler;
    }

    public String getContentType() {
        return this.getFirstMimeHeader("Content-Type");
    }

    public void addMimeHeader(String header, String value) {
        this.mimeHeaders.setHeader(header, value);
    }

    public String getFirstMimeHeader(String header) {
        String[] values = this.mimeHeaders.getHeader(header.toLowerCase());
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public boolean matches(MimeHeaders headers) {
        Iterator i = this.mimeHeaders.getAllHeaders();
        while (i.hasNext()) {
            MimeHeader hdr = (MimeHeader)i.next();
            String[] values = headers.getHeader(hdr.getName());
            boolean found = false;
            if (values != null) {
                int j = 0;
                while (j < values.length) {
                    if (hdr.getValue().equalsIgnoreCase(values[j])) {
                        found = true;
                        break;
                    }
                    ++j;
                }
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public String getContentLocation() {
        return this.getFirstMimeHeader("Content-Location");
    }

    public void setContentLocation(String loc) {
        this.addMimeHeader("Content-Location", loc);
    }

    public void setContentId(String newCid) {
        if (newCid != null && !newCid.toLowerCase().startsWith("cid:")) {
            newCid = "cid:" + newCid;
        }
        this.addMimeHeader("Content-Id", newCid);
    }

    public String getContentId() {
        String ret = this.getFirstMimeHeader("Content-Id");
        if (ret == null) {
            ret = SOAPUtils.getNewContentIdValue();
            this.addMimeHeader("Content-Id", ret);
        }
        if ((ret = ret.trim()).length() == 0) {
            ret = SOAPUtils.getNewContentIdValue();
            this.addMimeHeader("Content-Id", ret);
        }
        return ret;
    }

    public Iterator getMatchingMimeHeaders(String[] match) {
        return this.mimeHeaders.getMatchingHeaders(match);
    }

    public Iterator getNonMatchingMimeHeaders(String[] match) {
        return this.mimeHeaders.getNonMatchingHeaders(match);
    }

    public Iterator getAllMimeHeaders() {
        return this.mimeHeaders.getAllHeaders();
    }

    public void setMimeHeader(String name, String value) {
        this.mimeHeaders.setHeader(name, value);
    }

    public void removeAllMimeHeaders() {
        this.mimeHeaders.removeAllHeaders();
    }

    public void removeMimeHeader(String header) {
        this.mimeHeaders.removeHeader(header);
    }

    public DataHandler getDataHandler() throws SOAPException {
        if (this.datahandler == null) {
            throw new SOAPException(JavaUtils.getMessage("noContent"));
        }
        return this.datahandler;
    }

    public void setDataHandler(DataHandler datahandler) {
        if (datahandler == null) {
            throw new IllegalArgumentException(JavaUtils.getMessage("illegalArgumentException00"));
        }
        this.datahandler = datahandler;
        this.setMimeHeader("Content-Type", datahandler.getContentType());
    }

    public Object getContent() throws SOAPException {
        if (this.contentObject != null) {
            return this.contentObject;
        }
        if (this.datahandler == null) {
            throw new SOAPException(JavaUtils.getMessage("noContent"));
        }
        DataSource ds = this.datahandler.getDataSource();
        if (ds instanceof ManagedMemoryDataSource) {
            ManagedMemoryDataSource mds = (ManagedMemoryDataSource)ds;
            if (ds.getContentType().equals("text/plain")) {
                try {
                    InputStream is = ds.getInputStream();
                    byte[] bytes = new byte[is.available()];
                    is.read(bytes);
                    return new String(bytes);
                }
                catch (IOException io) {
                    log.error((Object)JavaUtils.getMessage("javaIOException00"), (Throwable)io);
                }
            }
        }
        return null;
    }

    public void setContent(Object object, String contentType) {
        if (object instanceof String) {
            try {
                String s = (String)object;
                ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes());
                this.datahandler = new DataHandler((DataSource)new ManagedMemoryDataSource(bais, 1024, contentType, true));
                this.contentObject = object;
                return;
            }
            catch (IOException io) {
                log.error((Object)JavaUtils.getMessage("javaIOException00"), (Throwable)io);
                throw new IllegalArgumentException(JavaUtils.getMessage("illegalArgumentException00"));
            }
        }
        if (object instanceof InputStream) {
            try {
                this.datahandler = new DataHandler((DataSource)new ManagedMemoryDataSource((InputStream)object, 1024, contentType, true));
                this.contentObject = object;
                return;
            }
            catch (IOException io) {
                log.error((Object)JavaUtils.getMessage("javaIOException00"), (Throwable)io);
                throw new IllegalArgumentException(JavaUtils.getMessage("illegalArgumentException00"));
            }
        }
        throw new IllegalArgumentException(JavaUtils.getMessage("illegalArgumentException00"));
    }

    public void clearContent() {
        this.datahandler = null;
        this.contentObject = null;
    }

    public int getSize() throws SOAPException {
        if (this.datahandler == null) {
            return 0;
        }
        ByteBuffer bout = new ByteBuffer();
        try {
            this.datahandler.writeTo((OutputStream)bout);
        }
        catch (IOException ex) {
            log.error((Object)JavaUtils.getMessage("javaIOException00"), (Throwable)ex);
            throw new SOAPException(JavaUtils.getMessage("javaIOException01", ex.getMessage()), (Throwable)ex);
        }
        byte[] bytes = bout.getBytes();
        if (bytes != null) {
            return bytes.length;
        }
        return -1;
    }

    public String[] getMimeHeader(String name) {
        return this.mimeHeaders.getHeader(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ByteBuffer
    extends ByteArrayOutputStream {
        private ByteBuffer() {
        }

        byte[] getBytes() {
            return this.buf;
        }
    }
}

