/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.client;

import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.InternalException;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.client.Service;
import org.apache.axis.client.Transport;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.SerializationContextImpl;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.encoding.ser.BaseDeserializerFactory;
import org.apache.axis.encoding.ser.BaseSerializerFactory;
import org.apache.axis.enum.Style;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Call
implements javax.xml.rpc.Call {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$client$Call == null ? (class$org$apache$axis$client$Call = Call.class$("org.apache.axis.client.Call")) : class$org$apache$axis$client$Call).getName());
    private static Log tlog = LogFactory.getLog((String)"org.apache.axis.TIME");
    private boolean parmAndRetReq = true;
    private Service service = null;
    private QName portTypeName = new QName("");
    private QName operationName = null;
    private QName returnType = null;
    private MessageContext msgContext = null;
    private Hashtable callProperties = new Hashtable();
    private Hashtable scopedProperties = new Hashtable();
    private String username = null;
    private String password = null;
    private boolean maintainSession = false;
    private Style operationStyle = Style.DEFAULT;
    private String encodingStyle = this.operationStyle.getEncoding();
    private boolean useSOAPAction = false;
    private String SOAPActionURI = null;
    private Integer timeout = null;
    private OperationDesc operation = new OperationDesc();
    private boolean invokeOneWay = false;
    private Transport transport = null;
    private String transportName = null;
    private HashMap outParams = null;
    private ArrayList outParamsList = null;
    private Vector myHeaders = null;
    private Class returnJavaType = null;
    public static final String SEND_TYPE_ATTR = "send_type_attr";
    public static final String TRANSPORT_NAME = "transport_name";
    public static final String TRANSPORT_PROPERTY = "java.protocol.handler.pkgs";
    public static final String JAXRPC_SERVICE = "jaxrpc.service";
    public static final String JAXRPC_PORTTYPE_NAME = "jaxrpc.porttype.name";
    public static final boolean FAULT_ON_NO_RESPONSE = false;
    public static final String ATTACHMENT_ENCAPSULATION_FORMAT = "attachment_encapsulation_format";
    public static final String ATTACHMENT_ENCAPSULATION_FORMAT_MIME = "axis.attachment.style.mime";
    public static final String ATTACHMENT_ENCAPSULATION_FORMAT_DIME = "axis.attachment.style.dime";
    private static Hashtable transports = new Hashtable();
    private static Hashtable transportImpls = new Hashtable();
    private static ArrayList propertyNames = new ArrayList();
    private static ArrayList transportPackages;
    private SOAPService myService = null;
    private String targetService = null;
    protected Vector attachmentParts = new Vector();
    static /* synthetic */ Class class$org$apache$axis$client$Call;
    static /* synthetic */ Class class$org$apache$axis$client$Transport;
    static /* synthetic */ Class class$org$apache$axis$transport$local$LocalTransport;
    static /* synthetic */ Class class$org$apache$axis$transport$http$HTTPTransport;

    public Call(Service service) {
        this.service = service;
        this.msgContext = new MessageContext(service.getEngine());
        this.maintainSession = service.getMaintainSession();
        Call.initialize();
    }

    public Call(String url) throws MalformedURLException {
        this(new Service());
        this.setTargetEndpointAddress(new URL(url));
    }

    public Call(URL url) {
        this(new Service());
        this.setTargetEndpointAddress(url);
    }

    public void setProperty(String name, Object value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException(JavaUtils.getMessage(name == null ? "badProp03" : "badProp04"));
        }
        if (name.equals("javax.xml.rpc.security.auth.username")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.setUsername((String)value);
        } else if (name.equals("javax.xml.rpc.security.auth.password")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.setPassword((String)value);
        } else if (name.equals("javax.xml.rpc.http.session.maintain")) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.Boolean", value.getClass().getName()}));
            }
            this.setMaintainSession((Boolean)value);
        } else if (name.equals("javax.xml.rpc.soap.operation.style")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.setOperationStyle((String)value);
        } else if (name.equals("javax.xml.rpc.soap.http.soapaction.use")) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.Boolean", value.getClass().getName()}));
            }
            this.setUseSOAPAction((Boolean)value);
        } else if (name.equals("javax.xml.rpc.soap.http.soapaction.uri")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.setSOAPActionURI((String)value);
        } else if (name.equals("javax.xml.rpc.encodingstyle.namespace.uri")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.setEncodingStyle((String)value);
        } else if (name.equals("javax.xml.rpc.service.endpoint.address")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.setTargetEndpointAddress((String)value);
        } else if (name.equals(TRANSPORT_NAME)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.transportName = (String)value;
            if (this.transport != null) {
                this.transport.setTransportName((String)value);
            }
        } else if (name.equals(ATTACHMENT_ENCAPSULATION_FORMAT)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            if (!value.equals(ATTACHMENT_ENCAPSULATION_FORMAT_MIME) && !value.equals(ATTACHMENT_ENCAPSULATION_FORMAT_DIME)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badattachmenttypeerr", new String[]{(String)value, "axis.attachment.style.mime axis.attachment.style.dime"}));
            }
        } else {
            throw new IllegalArgumentException(JavaUtils.getMessage("badProp05", name));
        }
        this.callProperties.put(name, value);
    }

    public Object getProperty(String name) {
        if (name == null || !this.isPropertySupported(name)) {
            throw new IllegalArgumentException(name == null ? JavaUtils.getMessage("badProp03") : JavaUtils.getMessage("badProp05", name));
        }
        return this.callProperties.get(name);
    }

    public void removeProperty(String name) {
        if (name == null || this.callProperties == null) {
            return;
        }
        this.callProperties.remove(name);
    }

    public void setScopedProperty(String name, Object value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException(JavaUtils.getMessage(name == null ? "badProp03" : "badProp04"));
        }
        this.scopedProperties.put(name, value);
    }

    public Object getScopedProperty(String name) {
        if (name != null) {
            return this.scopedProperties.get(name);
        }
        return null;
    }

    public void removeScopedProperty(String name) {
        if (name == null || this.scopedProperties == null) {
            return;
        }
        this.scopedProperties.remove(name);
    }

    public Iterator getPropertyNames() {
        return ((AbstractList)propertyNames).iterator();
    }

    public boolean isPropertySupported(String name) {
        return propertyNames.contains(name);
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setMaintainSession(boolean yesno) {
        this.maintainSession = yesno;
    }

    public boolean getMaintainSession() {
        return this.maintainSession;
    }

    public void setOperationStyle(String operationStyle) {
        this.operationStyle = Style.getStyle(operationStyle, Style.DEFAULT);
    }

    public Style getOperationStyle() {
        return this.operationStyle;
    }

    public void setUseSOAPAction(boolean useSOAPAction) {
        this.useSOAPAction = useSOAPAction;
    }

    public boolean useSOAPAction() {
        return this.useSOAPAction;
    }

    public void setSOAPActionURI(String SOAPActionURI) throws IllegalArgumentException {
        this.useSOAPAction = true;
        this.SOAPActionURI = SOAPActionURI;
    }

    public String getSOAPActionURI() {
        return this.SOAPActionURI;
    }

    public void setEncodingStyle(String namespaceURI) {
        this.encodingStyle = namespaceURI == null ? "" : namespaceURI;
    }

    public String getEncodingStyle() {
        return this.encodingStyle;
    }

    public void setTargetEndpointAddress(String address) {
        URL urlAddress;
        try {
            urlAddress = new URL(address);
        }
        catch (MalformedURLException mue) {
            throw new JAXRPCException((Throwable)mue);
        }
        this.setTargetEndpointAddress(urlAddress);
    }

    public void setTargetEndpointAddress(URL address) {
        try {
            URL tmpURL;
            String oldProto;
            String oldAddr;
            if (address == null) {
                this.setTransport(null);
                return;
            }
            String protocol = address.getProtocol();
            if (this.transport != null && (oldAddr = this.transport.getUrl()) != null && !oldAddr.equals("") && protocol.equals(oldProto = (tmpURL = new URL(oldAddr)).getProtocol())) {
                this.transport.setUrl(address.toString());
                return;
            }
            Transport transport = (Transport)transportImpls.get(address);
            if (transport != null) {
                this.setTransport(transport);
            } else {
                transport = this.getTransportForProtocol(protocol);
                if (transport == null) {
                    throw new AxisFault("Call.setTargetEndpointAddress", JavaUtils.getMessage("noTransport01", protocol), null, null);
                }
                transport.setUrl(address.toString());
                this.setTransport(transport);
                transportImpls.put(address, transport);
            }
        }
        catch (Exception exp) {
            log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)exp);
        }
    }

    public String getTargetEndpointAddress() {
        try {
            if (this.transport == null) {
                return null;
            }
            return this.transport.getUrl();
        }
        catch (Exception exp) {
            return null;
        }
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public boolean isParameterAndReturnSpecRequired(QName operationName) {
        return this.parmAndRetReq;
    }

    public void addParameter(QName paramName, QName xmlType, ParameterMode parameterMode) {
        Class javaType = null;
        TypeMapping tm = this.getTypeMapping();
        if (tm != null) {
            javaType = tm.getClassForQName(xmlType);
        }
        this.addParameter(paramName, xmlType, javaType, parameterMode);
    }

    public void addParameter(QName paramName, QName xmlType, Class javaType, ParameterMode parameterMode) {
        ParameterDesc param = new ParameterDesc();
        param.setQName(paramName);
        param.setTypeQName(xmlType);
        param.setJavaType(javaType);
        byte mode = 1;
        if (parameterMode == ParameterMode.INOUT) {
            mode = 3;
        } else if (parameterMode == ParameterMode.OUT) {
            mode = 2;
        }
        param.setMode(mode);
        this.operation.addParameter(param);
        this.parmAndRetReq = true;
    }

    public void addParameter(String paramName, QName xmlType, ParameterMode parameterMode) {
        Class javaType = null;
        TypeMapping tm = this.getTypeMapping();
        if (tm != null) {
            javaType = tm.getClassForQName(xmlType);
        }
        this.addParameter(new QName("", paramName), xmlType, javaType, parameterMode);
    }

    public void addParameter(String paramName, QName xmlType, Class javaType, ParameterMode parameterMode) {
        this.addParameter(new QName("", paramName), xmlType, javaType, parameterMode);
    }

    public QName getParameterTypeByName(String paramName) {
        QName paramQName = new QName("", paramName);
        return this.getParameterTypeByQName(paramQName);
    }

    public QName getParameterTypeByQName(QName paramQName) {
        ParameterDesc param = this.operation.getParamByQName(paramQName);
        if (param != null) {
            return param.getTypeQName();
        }
        return null;
    }

    public void setReturnType(QName type) {
        this.returnType = type;
        this.operation.setReturnType(type);
        TypeMapping tm = this.getTypeMapping();
        this.operation.setReturnClass(tm.getClassForQName(type));
        this.parmAndRetReq = true;
    }

    public void setReturnType(QName xmlType, Class javaType) {
        this.setReturnType(xmlType);
        this.returnJavaType = javaType;
    }

    public QName getReturnType() {
        return this.returnType;
    }

    public void setReturnClass(Class cls) {
        this.returnJavaType = cls;
    }

    public void removeAllParameters() {
        this.operation = new OperationDesc();
        this.parmAndRetReq = true;
    }

    public QName getOperationName() {
        return this.operationName;
    }

    public void setOperationName(QName opName) {
        this.operationName = opName;
    }

    public void setOperationName(String opName) {
        this.operationName = new QName(opName);
    }

    public void setOperation(QName portName, String opName) {
        QName type;
        if (this.service == null) {
            throw new JAXRPCException(JavaUtils.getMessage("noService04"));
        }
        this.setPortTypeName(portName);
        this.setOperationName(opName);
        this.setTargetEndpointAddress((URL)null);
        this.setEncodingStyle(null);
        this.setReturnType(null);
        this.removeAllParameters();
        javax.wsdl.Service wsdlService = this.service.getWSDLService();
        if (wsdlService == null) {
            return;
        }
        Port port = wsdlService.getPort(portName.getLocalPart());
        if (port == null) {
            throw new JAXRPCException(JavaUtils.getMessage("noPort00", "" + portName));
        }
        Binding binding = port.getBinding();
        PortType portType = binding.getPortType();
        if (portType == null) {
            throw new JAXRPCException(JavaUtils.getMessage("noPortType00", "" + portName));
        }
        List operations = portType.getOperations();
        if (operations == null) {
            throw new JAXRPCException(JavaUtils.getMessage("noOperation01", opName));
        }
        Operation op = null;
        int i = 0;
        while (i < operations.size()) {
            op = (Operation)operations.get(i);
            if (opName.equals(op.getName())) break;
            ++i;
            op = null;
        }
        if (op == null) {
            throw new JAXRPCException(JavaUtils.getMessage("noOperation01", opName));
        }
        List list = port.getExtensibilityElements();
        int i2 = 0;
        while (list != null && i2 < list.size()) {
            Object obj = list.get(i2);
            if (obj instanceof SOAPAddress) {
                try {
                    SOAPAddress addr = (SOAPAddress)obj;
                    URL url = new URL(addr.getLocationURI());
                    this.setTargetEndpointAddress(url);
                }
                catch (Exception exp) {
                    throw new JAXRPCException(JavaUtils.getMessage("cantSetURI00", "" + exp));
                }
            }
            ++i2;
        }
        BindingOperation bop = binding.getBindingOperation(opName, null, null);
        if (bop == null) {
            throw new JAXRPCException(JavaUtils.getMessage("noOperation02", opName));
        }
        list = bop.getExtensibilityElements();
        int i3 = 0;
        while (list != null && i3 < list.size()) {
            Object obj = list.get(i3);
            if (obj instanceof SOAPOperation) {
                SOAPOperation sop = (SOAPOperation)obj;
                String action = sop.getSoapActionURI();
                if (action != null) {
                    this.setUseSOAPAction(true);
                    this.setSOAPActionURI(action);
                    break;
                }
                this.setUseSOAPAction(false);
                this.setSOAPActionURI(null);
                break;
            }
            ++i3;
        }
        BindingInput bIn = bop.getBindingInput();
        if (bIn != null) {
            list = bIn.getExtensibilityElements();
            int i4 = 0;
            while (list != null && i4 < list.size()) {
                Object obj = list.get(i4);
                if (obj instanceof MIMEMultipartRelated) {
                    MIMEMultipartRelated mpr = (MIMEMultipartRelated)obj;
                    Object part = null;
                    List l = mpr.getMIMEParts();
                    int j = 0;
                    while (l != null && j < l.size() && part == null) {
                        MIMEPart mp = (MIMEPart)l.get(j);
                        List ll = mp.getExtensibilityElements();
                        int k = 0;
                        while (ll != null && k < ll.size() && part == null) {
                            part = ll.get(k);
                            if (!(part instanceof SOAPBody)) {
                                part = null;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    if (null != part) {
                        obj = part;
                    }
                }
                if (obj instanceof SOAPBody) {
                    String ns;
                    SOAPBody sBody = (SOAPBody)obj;
                    list = sBody.getEncodingStyles();
                    if (list != null && list.size() > 0) {
                        this.setEncodingStyle((String)list.get(0));
                    }
                    if ((ns = sBody.getNamespaceURI()) == null || ns.equals("")) break;
                    this.setOperationName(new QName(ns, opName));
                    break;
                }
                ++i4;
            }
        }
        List paramOrder = op.getParameterOrdering();
        Input input = op.getInput();
        javax.wsdl.Message message = null;
        List parts = null;
        if (input != null) {
            message = input.getMessage();
        }
        if (message != null) {
            parts = message.getOrderedParts(paramOrder);
        }
        if (parts != null) {
            int i5 = 0;
            while (i5 < parts.size()) {
                Part part = (Part)parts.get(i5);
                if (part != null) {
                    String name = part.getName();
                    type = part.getTypeName();
                    if (type == null) {
                        type = part.getElementName();
                        if (type != null) {
                            type = new QName("java", "org.w3c.dom.Element");
                        } else {
                            throw new JAXRPCException(JavaUtils.getMessage("typeNotSet00", name));
                        }
                    }
                    QName qname = new QName(type.getNamespaceURI(), type.getLocalPart());
                    ParameterMode mode = ParameterMode.IN;
                    this.addParameter(name, qname, mode);
                }
                ++i5;
            }
        }
        Output output = op.getOutput();
        message = null;
        if (output != null) {
            message = output.getMessage();
        }
        if (message != null) {
            parts = message.getOrderedParts(null);
        }
        if (this.operation != null && this.operation.getNumParams() > 0) {
            this.setReturnType(XMLType.AXIS_VOID);
        }
        if (parts != null) {
            int i6 = 0;
            while (i6 < parts.size()) {
                Part part = (Part)parts.get(i6);
                if (paramOrder == null || !paramOrder.contains(part.getName())) {
                    type = part.getTypeName();
                    if (type == null) {
                        type = part.getElementName();
                        if (type != null) {
                            type = new QName("java", "org.w3c.dom.Element");
                        } else {
                            throw new JAXRPCException(JavaUtils.getMessage("typeNotSet00", "<return>"));
                        }
                    }
                    QName qname = new QName(type.getNamespaceURI(), type.getLocalPart());
                    this.setReturnType(qname);
                    break;
                }
                ++i6;
            }
        }
        this.parmAndRetReq = false;
    }

    public QName getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(QName portType) {
        this.portTypeName = portType;
    }

    public Object invoke(QName operationName, Object[] params) throws RemoteException {
        QName origOpName = this.operationName;
        this.operationName = operationName;
        try {
            return this.invoke(params);
        }
        catch (RemoteException re) {
            this.operationName = origOpName;
            throw re;
        }
        catch (RuntimeException re) {
            this.operationName = origOpName;
            throw re;
        }
        catch (Error e) {
            this.operationName = origOpName;
            throw e;
        }
    }

    public Object invoke(Object[] params) throws RemoteException {
        long t0 = 0L;
        long t1 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        SOAPEnvelope env = null;
        int i = 0;
        while (params != null && i < params.length) {
            if (!(params[i] instanceof SOAPBodyElement)) break;
            ++i;
        }
        if (params != null && params.length > 0 && i == params.length) {
            env = new SOAPEnvelope();
            if (!(params[0] instanceof SOAPEnvelope)) {
                i = 0;
                while (i < params.length) {
                    env.addBodyElement((SOAPBodyElement)params[i]);
                    ++i;
                }
            }
            Message msg = new Message(env);
            this.setRequestMessage(msg);
            this.invoke();
            msg = this.msgContext.getResponseMessage();
            if (msg == null) {
                return null;
            }
            env = msg.getSOAPEnvelope();
            return env.getBodyElements();
        }
        if (this.operationName == null) {
            throw new AxisFault(JavaUtils.getMessage("noOperation00"));
        }
        try {
            Object res = this.invoke(this.operationName.getNamespaceURI(), this.operationName.getLocalPart(), params);
            if (tlog.isDebugEnabled()) {
                t1 = System.currentTimeMillis();
                tlog.debug((Object)("axis.Call.invoke: " + (t1 - t0) + " " + this.operationName));
            }
            return res;
        }
        catch (AxisFault af) {
            throw af;
        }
        catch (Exception exp) {
            log.info((Object)JavaUtils.getMessage("toAxisFault00"), (Throwable)exp);
            throw new AxisFault(JavaUtils.getMessage("errorInvoking00", "\n" + exp));
        }
    }

    public void invokeOneWay(Object[] params) {
        try {
            try {
                this.invokeOneWay = true;
                this.invoke(params);
            }
            catch (Exception exp) {
                throw new JAXRPCException(exp.toString());
            }
            Object var4_2 = null;
            this.invokeOneWay = false;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.invokeOneWay = false;
            throw throwable;
        }
    }

    public SOAPEnvelope invoke(SOAPEnvelope env) throws RemoteException {
        try {
            Message msg = null;
            msg = new Message(env);
            this.setRequestMessage(msg);
            this.invoke();
            msg = this.msgContext.getResponseMessage();
            if (msg == null) {
                return null;
            }
            return msg.getSOAPEnvelope();
        }
        catch (Exception exp) {
            if (exp instanceof AxisFault) {
                throw (AxisFault)exp;
            }
            log.info((Object)JavaUtils.getMessage("toAxisFault00"), (Throwable)exp);
            throw new AxisFault(JavaUtils.getMessage("errorInvoking00", "\n" + exp));
        }
    }

    public static void setTransportForProtocol(String protocol, Class transportClass) {
        if (!(class$org$apache$axis$client$Transport == null ? (class$org$apache$axis$client$Transport = Call.class$("org.apache.axis.client.Transport")) : class$org$apache$axis$client$Transport).isAssignableFrom(transportClass)) {
            throw new InternalException(transportClass.toString());
        }
        transports.put(protocol, transportClass);
    }

    public static synchronized void initialize() {
        Call.addTransportPackage("org.apache.axis.transport");
        Call.setTransportForProtocol("local", class$org$apache$axis$transport$local$LocalTransport == null ? (class$org$apache$axis$transport$local$LocalTransport = Call.class$("org.apache.axis.transport.local.LocalTransport")) : class$org$apache$axis$transport$local$LocalTransport);
        Call.setTransportForProtocol("http", class$org$apache$axis$transport$http$HTTPTransport == null ? (class$org$apache$axis$transport$http$HTTPTransport = Call.class$("org.apache.axis.transport.http.HTTPTransport")) : class$org$apache$axis$transport$http$HTTPTransport);
        Call.setTransportForProtocol("https", class$org$apache$axis$transport$http$HTTPTransport == null ? (class$org$apache$axis$transport$http$HTTPTransport = Call.class$("org.apache.axis.transport.http.HTTPTransport")) : class$org$apache$axis$transport$http$HTTPTransport);
    }

    public static synchronized void addTransportPackage(String packageName) {
        CharSequence currentPackages;
        if (transportPackages == null) {
            transportPackages = new ArrayList();
            currentPackages = AxisEngine.getGlobalProperty(TRANSPORT_PROPERTY);
            if (currentPackages != null) {
                StringTokenizer tok = new StringTokenizer((String)currentPackages, "|");
                while (tok.hasMoreTokens()) {
                    transportPackages.add(tok.nextToken());
                }
            }
        }
        if (transportPackages.contains(packageName)) {
            return;
        }
        transportPackages.add(packageName);
        currentPackages = new StringBuffer();
        Iterator i = ((AbstractList)transportPackages).iterator();
        while (i.hasNext()) {
            String thisPackage = (String)i.next();
            ((StringBuffer)currentPackages).append(thisPackage);
            ((StringBuffer)currentPackages).append('|');
        }
        System.setProperty(TRANSPORT_PROPERTY, ((StringBuffer)currentPackages).toString());
    }

    private Object[] getParamList(Object[] params) {
        int numParams = 0;
        log.debug((Object)("operation=" + this.operation));
        if (this.operation != null) {
            log.debug((Object)("operation.getNumParams()=" + this.operation.getNumParams()));
        }
        if (this.operation.getNumParams() == 0) {
            return params;
        }
        numParams = this.operation.getNumInParams();
        if (params == null || numParams != params.length) {
            throw new JAXRPCException(JavaUtils.getMessage("parmMismatch00", "" + params.length, "" + numParams));
        }
        log.debug((Object)("getParamList number of params: " + params.length));
        Vector<RPCParam> result = new Vector<RPCParam>();
        int j = 0;
        ArrayList parameters = this.operation.getParameters();
        int i = 0;
        while (i < parameters.size()) {
            ParameterDesc param = (ParameterDesc)parameters.get(i);
            if (param.getMode() != 2) {
                Object p;
                QName paramQName = param.getQName();
                RPCParam rpcParam = null;
                rpcParam = (p = params[j++]) instanceof RPCParam ? (RPCParam)p : new RPCParam(paramQName.getNamespaceURI(), paramQName.getLocalPart(), p);
                rpcParam.setParamDesc(param);
                result.add(rpcParam);
            }
            ++i;
        }
        return result.toArray();
    }

    public void setTransport(Transport trans) {
        this.transport = trans;
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("transport00", "" + this.transport));
        }
    }

    public Transport getTransportForProtocol(String protocol) {
        Class transportClass = (Class)transports.get(protocol);
        Transport ret = null;
        if (transportClass != null) {
            try {
                ret = (Transport)transportClass.newInstance();
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return ret;
    }

    public void setRequestMessage(Message msg) {
        Attachments attachments;
        String attachformat = (String)this.getProperty(ATTACHMENT_ENCAPSULATION_FORMAT);
        if (null != attachformat && null != (attachments = msg.getAttachmentsImpl())) {
            if (null != attachformat && attachformat.equals(ATTACHMENT_ENCAPSULATION_FORMAT_MIME)) {
                attachments.setSendType(2);
            } else if (null != attachformat && attachformat.equals(ATTACHMENT_ENCAPSULATION_FORMAT_DIME)) {
                attachments.setSendType(3);
            }
        }
        if (null != this.attachmentParts && !this.attachmentParts.isEmpty()) {
            try {
                attachments = msg.getAttachmentsImpl();
                if (null == attachments) {
                    throw new RuntimeException(JavaUtils.getMessage("noAttachments"));
                }
                attachments.setAttachmentParts(this.attachmentParts);
            }
            catch (AxisFault ex) {
                log.info((Object)JavaUtils.getMessage("axisFault00"), (Throwable)ex);
                throw new RuntimeException(ex.getMessage());
            }
        }
        this.msgContext.setRequestMessage(msg);
        this.attachmentParts.clear();
    }

    public Message getResponseMessage() {
        return this.msgContext.getResponseMessage();
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public void addHeader(SOAPHeaderElement header) {
        if (this.myHeaders == null) {
            this.myHeaders = new Vector();
        }
        this.myHeaders.add(header);
    }

    public void clearHeaders() {
        this.myHeaders = null;
    }

    public TypeMapping getTypeMapping() {
        TypeMappingRegistry tmr = this.msgContext.getTypeMappingRegistry();
        TypeMapping tm = (TypeMapping)tmr.getTypeMapping(this.encodingStyle);
        TypeMapping defaultTM = (TypeMapping)tmr.getDefaultTypeMapping();
        if (tm == null || tm == defaultTM) {
            tm = (TypeMapping)tmr.createTypeMapping();
            tm.setSupportedEncodings(new String[]{this.encodingStyle});
            tmr.register(this.encodingStyle, tm);
        }
        return tm;
    }

    public void registerTypeMapping(Class javaType, QName xmlType, SerializerFactory sf, DeserializerFactory df) {
        this.registerTypeMapping(javaType, xmlType, sf, df, true);
    }

    public void registerTypeMapping(Class javaType, QName xmlType, SerializerFactory sf, DeserializerFactory df, boolean force) {
        TypeMapping tm = this.getTypeMapping();
        if (!force && tm.isRegistered(javaType, xmlType)) {
            return;
        }
        tm.register(javaType, xmlType, sf, df);
    }

    public void registerTypeMapping(Class javaType, QName xmlType, Class sfClass, Class dfClass) {
        this.registerTypeMapping(javaType, xmlType, sfClass, dfClass, true);
    }

    public void registerTypeMapping(Class javaType, QName xmlType, Class sfClass, Class dfClass, boolean force) {
        SerializerFactory sf = BaseSerializerFactory.createFactory(sfClass, javaType, xmlType);
        DeserializerFactory df = BaseDeserializerFactory.createFactory(dfClass, javaType, xmlType);
        if (sf != null || df != null) {
            this.registerTypeMapping(javaType, xmlType, sf, df, force);
        }
    }

    public Object invoke(String namespace, String method, Object[] args) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: Call::invoke(ns, meth, args)");
        }
        if (this.returnType != null && args != null && args.length != 0 && this.operation == null) {
            throw new AxisFault(JavaUtils.getMessage("mustSpecifyParms"));
        }
        RPCElement body = new RPCElement(namespace, method, this.getParamList(args));
        Object ret = this.invoke(body);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: Call::invoke(ns, meth, args)");
        }
        return ret;
    }

    public Object invoke(String method, Object[] args) throws AxisFault {
        return this.invoke("", method, args);
    }

    public Object invoke(RPCElement body) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: Call::invoke(RPCElement)");
        }
        if (!this.invokeOneWay && this.operation.getNumParams() > 0 && this.returnType == null) {
            log.error((Object)JavaUtils.getMessage("mustSpecifyReturnType"));
        }
        SOAPEnvelope reqEnv = new SOAPEnvelope();
        SOAPEnvelope resEnv = null;
        Message reqMsg = new Message(reqEnv);
        Message resMsg = null;
        Vector resArgs = null;
        Object result = null;
        this.outParams = new HashMap();
        this.outParamsList = new ArrayList();
        try {
            body.setEncodingStyle(this.encodingStyle);
            reqEnv.setEncodingStyle(this.encodingStyle);
            this.setRequestMessage(reqMsg);
            reqEnv.addBodyElement(body);
            reqEnv.setMessageType("request");
            this.invoke();
        }
        catch (Exception e) {
            log.info((Object)JavaUtils.getMessage("toAxisFault00"), (Throwable)e);
            throw AxisFault.makeFault(e);
        }
        resMsg = this.msgContext.getResponseMessage();
        if (resMsg == null) {
            return null;
        }
        resEnv = resMsg.getSOAPEnvelope();
        SOAPBodyElement bodyEl = resEnv.getFirstBody();
        if (bodyEl instanceof RPCElement) {
            try {
                resArgs = ((RPCElement)bodyEl).getParams();
            }
            catch (Exception e) {
                log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
                throw AxisFault.makeFault(e);
            }
            if (resArgs != null && resArgs.size() > 0) {
                int outParamStart = 0;
                if (!XMLType.AXIS_VOID.equals(this.returnType)) {
                    RPCParam param = (RPCParam)resArgs.get(0);
                    result = param.getValue();
                    outParamStart = 1;
                }
                int i = outParamStart;
                while (i < resArgs.size()) {
                    RPCParam param = (RPCParam)resArgs.get(i);
                    Class javaType = this.getJavaTypeForQName(param.getQName());
                    Object value = param.getValue();
                    if (javaType != null && !javaType.isAssignableFrom(value.getClass())) {
                        value = JavaUtils.convert(value, javaType);
                    }
                    this.outParams.put(param.getQName(), value);
                    this.outParamsList.add(value);
                    ++i;
                }
            }
        } else {
            try {
                result = bodyEl.getValueAsType(this.returnType);
            }
            catch (Exception e) {
                result = bodyEl;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: Call::invoke(RPCElement)");
        }
        if (this.returnJavaType != null) {
            result = JavaUtils.convert(result, this.returnJavaType);
        }
        return result;
    }

    private Class getJavaTypeForQName(QName name) {
        ParameterDesc param = this.operation.getOutputParamByQName(name);
        return param == null ? null : param.getJavaType();
    }

    public void setOption(String name, Object value) {
        this.service.getEngine().setOption(name, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke() throws AxisFault {
        block25: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Enter: Call::invoke()");
            }
            Message reqMsg = null;
            SOAPEnvelope reqEnv = null;
            this.msgContext.reset();
            this.msgContext.setResponseMessage(null);
            this.msgContext.setProperty(MessageContext.CALL, this);
            this.msgContext.setProperty(JAXRPC_SERVICE, this.service);
            this.msgContext.setProperty(JAXRPC_PORTTYPE_NAME, this.getPortTypeName());
            if (this.username != null) {
                this.msgContext.setUsername(this.username);
            }
            if (this.password != null) {
                this.msgContext.setPassword(this.password);
            }
            this.msgContext.setMaintainSession(this.maintainSession);
            this.msgContext.setOperation(this.operation);
            this.operation.setStyle(this.getOperationStyle());
            this.msgContext.setOperationStyle(this.getOperationStyle());
            if (this.useSOAPAction) {
                this.msgContext.setUseSOAPAction(true);
            }
            if (this.SOAPActionURI != null) {
                this.msgContext.setSOAPActionURI(this.SOAPActionURI);
            }
            if (this.timeout != null) {
                this.msgContext.setTimeout(this.timeout);
            }
            this.msgContext.setEncodingStyle(this.encodingStyle);
            if (this.myService != null) {
                this.msgContext.setService(this.myService);
            } else {
                if (this.targetService != null) {
                    this.msgContext.setTargetService(this.targetService);
                } else {
                    SOAPBodyElement body;
                    reqMsg = this.msgContext.getRequestMessage();
                    reqEnv = reqMsg.getSOAPEnvelope();
                    int i = 0;
                    while (true) {
                        if (this.myHeaders == null || i >= this.myHeaders.size()) {
                            body = reqEnv.getFirstBody();
                            if (body.getNamespaceURI() != null) break;
                            throw new AxisFault("Call.invoke", JavaUtils.getMessage("cantInvoke00", body.getName()), null, null);
                        }
                        reqEnv.addHeader((SOAPHeaderElement)this.myHeaders.get(i));
                        ++i;
                    }
                    this.msgContext.setTargetService(body.getNamespaceURI());
                }
                SOAPService svc = this.msgContext.getService();
                if (svc != null) {
                    svc.setPropertyParent(this.scopedProperties);
                } else {
                    this.msgContext.setPropertyParent(this.scopedProperties);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("targetService", this.msgContext.getTargetService()));
            }
            if (this.transport != null) {
                this.transport.setupMessageContext(this.msgContext, this, this.service.getEngine());
            } else {
                this.msgContext.setTransportName(this.transportName);
            }
            if (log.isDebugEnabled()) {
                StringWriter writer = new StringWriter();
                try {
                    try {
                        SerializationContextImpl ctx = new SerializationContextImpl(writer, this.msgContext);
                        reqEnv.output(ctx);
                        writer.close();
                    }
                    catch (Exception e) {
                        log.debug((Object)JavaUtils.getMessage("exceptionPrinting"), (Throwable)e);
                        Object var6_8 = null;
                        log.debug((Object)writer.getBuffer().toString());
                        break block25;
                    }
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    log.debug((Object)writer.getBuffer().toString());
                    throw throwable;
                }
                log.debug((Object)writer.getBuffer().toString());
            }
        }
        if (!this.invokeOneWay) {
            this.invokeEngine(this.msgContext);
        } else {
            this.invokeEngineOneWay(this.msgContext);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: Call::invoke()");
        }
    }

    private void invokeEngine(MessageContext msgContext) throws AxisFault {
        Message resMsg;
        this.service.getEngine().invoke(msgContext);
        if (this.transport != null) {
            this.transport.processReturnedMessageContext(msgContext);
        }
        if ((resMsg = msgContext.getResponseMessage()) == null) {
            return;
        }
        resMsg.setMessageType("response");
        SOAPEnvelope resEnv = resMsg.getSOAPEnvelope();
        SOAPBodyElement respBody = resEnv.getFirstBody();
        if (respBody instanceof SOAPFault) {
            throw ((SOAPFault)respBody).getFault();
        }
    }

    private void invokeEngineOneWay(final MessageContext msgContext) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    Call.this.service.getEngine().invoke(msgContext);
                }
                catch (AxisFault af) {
                    log.debug((Object)JavaUtils.getMessage("exceptionPrinting"), (Throwable)af);
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public Map getOutputParams() {
        return this.outParams;
    }

    public List getOutputValues() {
        return this.outParamsList;
    }

    public Service getService() {
        return this.service;
    }

    public void setSOAPService(SOAPService service) {
        this.myService = service;
        if (service != null) {
            service.setPropertyParent(this.scopedProperties);
        }
    }

    public void setClientHandlers(Handler reqHandler, Handler respHandler) {
        this.setSOAPService(new SOAPService(reqHandler, null, respHandler));
    }

    public void setTargetService(String targetService) {
        this.targetService = targetService;
    }

    public void addAttachmentPart(Object attachment) {
        this.attachmentParts.add(attachment);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        propertyNames.add("javax.xml.rpc.security.auth.username");
        propertyNames.add("javax.xml.rpc.security.auth.password");
        propertyNames.add("javax.xml.rpc.http.session.maintain");
        propertyNames.add(ATTACHMENT_ENCAPSULATION_FORMAT);
        propertyNames.add("javax.xml.rpc.soap.operation.style");
        propertyNames.add("javax.xml.rpc.soap.http.soapaction.use");
        propertyNames.add("javax.xml.rpc.soap.http.soapaction.uri");
        propertyNames.add("javax.xml.rpc.encodingstyle.namespace.uri");
        propertyNames.add(TRANSPORT_NAME);
        propertyNames.add(ATTACHMENT_ENCAPSULATION_FORMAT);
        transportPackages = null;
    }
}

