/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.deployment.wsdd.WSDDGlobalConfiguration;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.utils.Admin;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class FileProvider
implements EngineConfiguration {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$configuration$FileProvider == null ? (class$org$apache$axis$configuration$FileProvider = FileProvider.class$("org.apache.axis.configuration.FileProvider")) : class$org$apache$axis$configuration$FileProvider).getName());
    protected WSDDDeployment deployment = null;
    private static final String CURRENT_DIR = ".";
    protected String filename;
    protected File configFile = null;
    protected InputStream myInputStream = null;
    protected boolean readOnly = true;
    boolean searchClasspath = true;
    static /* synthetic */ Class class$org$apache$axis$configuration$FileProvider;

    public FileProvider(String filename) {
        this.filename = filename;
        this.configFile = new File(filename);
        this.check();
    }

    public FileProvider(String basepath, String filename) throws ConfigurationException {
        this.filename = filename;
        File dir = new File(basepath);
        if (!dir.isDirectory() || !dir.canRead()) {
            throw new ConfigurationException(JavaUtils.getMessage("invalidConfigFilePath", basepath));
        }
        this.configFile = new File(basepath, filename);
        this.check();
    }

    private void check() {
        this.readOnly = this.configFile.canRead() & !this.configFile.canWrite();
        if (this.readOnly) {
            log.info((Object)JavaUtils.getMessage("readOnlyConfigFile"));
        }
    }

    public FileProvider(InputStream is) {
        this.myInputStream = is;
    }

    public WSDDDeployment getDeployment() {
        return this.deployment;
    }

    public void setDeployment(WSDDDeployment deployment) {
        this.deployment = deployment;
    }

    public void setSearchClasspath(boolean searchClasspath) {
        this.searchClasspath = searchClasspath;
    }

    public void configureEngine(AxisEngine engine) throws ConfigurationException {
        try {
            block6: {
                if (this.myInputStream == null) {
                    try {
                        this.myInputStream = new FileInputStream(this.configFile);
                    }
                    catch (Exception e) {
                        if (!this.searchClasspath) break block6;
                        this.myInputStream = engine.getClass().getClassLoader().getResourceAsStream(this.filename);
                        if (this.myInputStream != null) break block6;
                        this.myInputStream = engine.getClass().getResourceAsStream(this.filename);
                    }
                }
            }
            if (this.myInputStream == null) {
                throw new ConfigurationException(JavaUtils.getMessage("noConfigFile"));
            }
            WSDDDocument doc = new WSDDDocument(XMLUtils.newDocument(this.myInputStream));
            this.deployment = doc.getDeployment();
            this.deployment.configureEngine(engine);
            engine.refreshGlobalOptions();
            this.myInputStream = null;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public void writeEngineConfig(AxisEngine engine) throws ConfigurationException {
        if (!this.readOnly) {
            try {
                Document doc = Admin.listConfig(engine);
                StringWriter writer = new StringWriter();
                XMLUtils.DocumentToWriter(doc, writer);
                writer.close();
                FileOutputStream fos = new FileOutputStream(this.configFile);
                fos.write(writer.getBuffer().toString().getBytes());
                fos.close();
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
        }
    }

    public Handler getHandler(QName qname) throws ConfigurationException {
        return this.deployment.getHandler(qname);
    }

    public SOAPService getService(QName qname) throws ConfigurationException {
        return this.deployment.getService(qname);
    }

    public SOAPService getServiceByNamespaceURI(String namespace) throws ConfigurationException {
        return this.deployment.getServiceByNamespaceURI(namespace);
    }

    public Handler getTransport(QName qname) throws ConfigurationException {
        return this.deployment.getTransport(qname);
    }

    public TypeMappingRegistry getTypeMappingRegistry() throws ConfigurationException {
        return this.deployment.getTypeMappingRegistry();
    }

    public Handler getGlobalRequest() throws ConfigurationException {
        return this.deployment.getGlobalRequest();
    }

    public Handler getGlobalResponse() throws ConfigurationException {
        return this.deployment.getGlobalResponse();
    }

    public Hashtable getGlobalOptions() throws ConfigurationException {
        WSDDGlobalConfiguration globalConfig = this.deployment.getGlobalConfiguration();
        if (globalConfig != null) {
            return globalConfig.getParametersTable();
        }
        return null;
    }

    public Iterator getDeployedServices() throws ConfigurationException {
        ArrayList<ServiceDesc> serviceDescs = new ArrayList<ServiceDesc>();
        WSDDService[] services = this.deployment.getServices();
        int i = 0;
        while (i < services.length) {
            WSDDService service = services[i];
            serviceDescs.add(service.getServiceDesc());
            ++i;
        }
        return ((AbstractList)serviceDescs).iterator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

