/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.description;

import javax.xml.namespace.QName;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.symbolTable.TypeEntry;

public class ParameterDesc {
    public static final byte IN = 1;
    public static final byte OUT = 2;
    public static final byte INOUT = 3;
    private QName name;
    public TypeEntry typeEntry;
    public byte mode = 1;
    private QName typeQName;
    private Class javaType = null;
    private int order = -1;

    public ParameterDesc() {
    }

    public ParameterDesc(QName name, byte mode, QName typeQName) {
        this.name = name;
        this.mode = mode;
        this.typeQName = typeQName;
    }

    public ParameterDesc(QName name, byte mode, QName typeQName, Class javaType) {
        this(name, mode, typeQName);
        this.javaType = javaType;
    }

    public String toString() {
        return "name:  " + this.name + "\ntypeEntry:  " + this.typeEntry + "\nmode:  " + (this.mode == 1 ? "IN" : (this.mode == 3 ? "INOUT" : "OUT:  position:" + this.order)) + "\ntypeQName:  " + this.typeQName + "\njavaType:  " + this.javaType;
    }

    public static byte modeFromString(String modeStr) {
        int ret = 1;
        if (modeStr == null) {
            return 1;
        }
        if (modeStr.equalsIgnoreCase("out")) {
            ret = 2;
        } else if (modeStr.equalsIgnoreCase("inout")) {
            ret = 3;
        }
        return (byte)ret;
    }

    public static String getModeAsString(byte mode) {
        if (mode == 3) {
            return "inout";
        }
        if (mode == 2) {
            return "out";
        }
        if (mode == 1) {
            return "in";
        }
        throw new IllegalArgumentException(JavaUtils.getMessage("badParameterMode", Byte.toString(mode)));
    }

    public QName getQName() {
        return this.name;
    }

    public String getName() {
        return this.name.getLocalPart();
    }

    public void setName(String name) {
        this.name = new QName("", name);
    }

    public void setQName(QName name) {
        this.name = name;
    }

    public QName getTypeQName() {
        return this.typeQName;
    }

    public void setTypeQName(QName typeQName) {
        this.typeQName = typeQName;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public void setJavaType(Class javaType) {
        this.javaType = javaType;
    }

    public byte getMode() {
        return this.mode;
    }

    public void setMode(byte mode) {
        this.mode = mode;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

