/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.description;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.description.FaultDesc;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.enum.Style;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.bytecode.ExtractorFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceDesc {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$description$ServiceDesc == null ? (class$org$apache$axis$description$ServiceDesc = ServiceDesc.class$("org.apache.axis.description.ServiceDesc")) : class$org$apache$axis$description$ServiceDesc).getName());
    private String name = null;
    private List allowedMethods = null;
    private List disallowedMethods = null;
    private Style style = Style.RPC;
    private Class implClass = null;
    private ArrayList operations = new ArrayList();
    private List namespaceMappings = null;
    private String wsdlFileName = null;
    private HashMap properties = null;
    private boolean isSkeletonClass = false;
    private Method skelMethod = null;
    private ArrayList stopClasses = null;
    private HashMap name2OperationsMap = null;
    private HashMap qname2OperationsMap = null;
    private HashMap method2OperationMap = new HashMap();
    private ArrayList completedNames = new ArrayList();
    private TypeMapping tm = null;
    private boolean haveAllSkeletonMethods = false;
    private boolean introspectionComplete = false;
    static /* synthetic */ Class class$org$apache$axis$description$ServiceDesc;
    static /* synthetic */ Class class$org$apache$axis$wsdl$Skeleton;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$rmi$RemoteException;

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public boolean isWrapped() {
        return this.style == Style.RPC || this.style == Style.WRAPPED;
    }

    public String getWSDLFile() {
        return this.wsdlFileName;
    }

    public void setWSDLFile(String wsdlFileName) {
        this.wsdlFileName = wsdlFileName;
    }

    public List getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(List allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public Class getImplClass() {
        return this.implClass;
    }

    public void setImplClass(Class implClass) {
        if (this.implClass != null) {
            throw new IllegalArgumentException(JavaUtils.getMessage("implAlreadySet"));
        }
        this.implClass = implClass;
        if ((class$org$apache$axis$wsdl$Skeleton == null ? (class$org$apache$axis$wsdl$Skeleton = ServiceDesc.class$("org.apache.axis.wsdl.Skeleton")) : class$org$apache$axis$wsdl$Skeleton).isAssignableFrom(implClass)) {
            this.isSkeletonClass = true;
            this.loadSkeletonOperations();
        }
    }

    private void loadSkeletonOperations() {
        Method method = null;
        try {
            method = this.implClass.getDeclaredMethod("getOperationDescs", new Class[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (method == null) {
            return;
        }
        try {
            Collection opers = (Collection)method.invoke((Object)this.implClass, null);
            Iterator i = opers.iterator();
            while (i.hasNext()) {
                OperationDesc skelDesc = (OperationDesc)i.next();
                this.addOperationDesc(skelDesc);
            }
        }
        catch (IllegalAccessException e) {
            return;
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (InvocationTargetException e) {
            return;
        }
        this.haveAllSkeletonMethods = true;
    }

    public TypeMapping getTypeMapping() {
        return this.tm;
    }

    public void setTypeMapping(TypeMapping tm) {
        this.tm = tm;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList getStopClasses() {
        return this.stopClasses;
    }

    public void setStopClasses(ArrayList stopClasses) {
        this.stopClasses = stopClasses;
    }

    public List getDisallowedMethods() {
        return this.disallowedMethods;
    }

    public void setDisallowedMethods(List disallowedMethods) {
        this.disallowedMethods = disallowedMethods;
    }

    public void addOperationDesc(OperationDesc operation) {
        String name;
        ArrayList<OperationDesc> overloads;
        this.operations.add(operation);
        operation.setParent(this);
        if (this.name2OperationsMap == null) {
            this.name2OperationsMap = new HashMap();
        }
        if ((overloads = (ArrayList<OperationDesc>)this.name2OperationsMap.get(name = operation.getName())) == null) {
            overloads = new ArrayList<OperationDesc>();
            this.name2OperationsMap.put(name, overloads);
        }
        overloads.add(operation);
    }

    public ArrayList getOperations() {
        this.loadServiceDescByIntrospection();
        return this.operations;
    }

    public OperationDesc[] getOperationsByName(String methodName) {
        this.getSyncedOperationsForName(this.implClass, methodName);
        if (this.name2OperationsMap == null) {
            return null;
        }
        ArrayList overloads = (ArrayList)this.name2OperationsMap.get(methodName);
        if (overloads == null) {
            return null;
        }
        OperationDesc[] array = new OperationDesc[overloads.size()];
        return overloads.toArray(array);
    }

    public OperationDesc getOperationByName(String methodName) {
        this.getSyncedOperationsForName(this.implClass, methodName);
        if (this.name2OperationsMap == null) {
            return null;
        }
        ArrayList overloads = (ArrayList)this.name2OperationsMap.get(methodName);
        if (overloads == null) {
            return null;
        }
        return (OperationDesc)overloads.get(0);
    }

    public OperationDesc getOperationByElementQName(QName qname) {
        OperationDesc[] overloads = this.getOperationsByQName(qname);
        if (overloads != null && overloads.length > 0) {
            return overloads[0];
        }
        return null;
    }

    public OperationDesc[] getOperationsByQName(QName qname) {
        if (this.style == Style.MESSAGE) {
            if (!this.introspectionComplete) {
                this.loadServiceDescByIntrospection();
            }
            if (this.operations.size() > 0) {
                return new OperationDesc[]{(OperationDesc)this.operations.get(0)};
            }
            return null;
        }
        this.initQNameMap();
        ArrayList overloads = (ArrayList)this.qname2OperationsMap.get(qname);
        if (overloads == null) {
            if (this.style == Style.RPC && this.name2OperationsMap != null) {
                overloads = (ArrayList)this.name2OperationsMap.get(qname.getLocalPart());
            }
            if (overloads == null) {
                return null;
            }
        }
        this.getSyncedOperationsForName(this.implClass, ((OperationDesc)overloads.get(0)).getName());
        OperationDesc[] array = new OperationDesc[overloads.size()];
        return overloads.toArray(array);
    }

    private synchronized void initQNameMap() {
        if (this.qname2OperationsMap == null) {
            this.loadServiceDescByIntrospection();
            this.qname2OperationsMap = new HashMap();
            Iterator i = ((AbstractList)this.operations).iterator();
            while (i.hasNext()) {
                OperationDesc operationDesc = (OperationDesc)i.next();
                ArrayList<OperationDesc> list = (ArrayList<OperationDesc>)this.qname2OperationsMap.get(operationDesc.getElementQName());
                if (list == null) {
                    list = new ArrayList<OperationDesc>();
                    this.qname2OperationsMap.put(operationDesc.getElementQName(), list);
                }
                list.add(operationDesc);
            }
        }
    }

    private void syncOperationToClass(OperationDesc oper, Class implClass) {
        if (oper.getMethod() != null) {
            return;
        }
        Method[] methods = implClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Class<?>[] paramTypes;
            Method method = methods[i];
            if (Modifier.isPublic(method.getModifiers()) && method.getName().equals(oper.getName()) && (paramTypes = method.getParameterTypes()).length == oper.getNumParams()) {
                int j = 0;
                while (j < paramTypes.length) {
                    Class<?> type = paramTypes[j];
                    ParameterDesc param = oper.getParameter(j);
                    QName typeQName = param.getTypeQName();
                    if (typeQName == null) {
                        typeQName = (class$javax$xml$rpc$holders$Holder == null ? ServiceDesc.class$("javax.xml.rpc.holders.Holder") : class$javax$xml$rpc$holders$Holder).isAssignableFrom(type) ? this.tm.getTypeQName(JavaUtils.getHolderValueType(type)) : this.tm.getTypeQName(type);
                        param.setJavaType(type);
                        param.setTypeQName(typeQName);
                    } else {
                        Class paramClass = param.getJavaType();
                        if (paramClass == null) {
                            paramClass = this.tm.getClassForQName(param.getTypeQName());
                        }
                        if (!JavaUtils.isConvertable(paramClass, type)) break;
                        param.setJavaType(type);
                    }
                    ++j;
                }
                if (j == paramTypes.length) {
                    oper.setReturnClass(method.getReturnType());
                    oper.setMethod(method);
                    this.method2OperationMap.put(method, oper);
                    return;
                }
            }
            ++i;
        }
        Class superClass = implClass.getSuperclass();
        if (!(superClass == null || superClass.getName().startsWith("java.") || superClass.getName().startsWith("javax.") || this.stopClasses != null && this.stopClasses.contains(superClass.getName()))) {
            this.syncOperationToClass(oper, superClass);
        }
    }

    public void loadServiceDescByIntrospection() {
        this.loadServiceDescByIntrospection(this.implClass, true);
        this.completedNames = null;
    }

    public void loadServiceDescByIntrospection(Class implClass, boolean searchParents) {
        if (this.introspectionComplete || implClass == null) {
            return;
        }
        if ((class$org$apache$axis$wsdl$Skeleton == null ? (class$org$apache$axis$wsdl$Skeleton = ServiceDesc.class$("org.apache.axis.wsdl.Skeleton")) : class$org$apache$axis$wsdl$Skeleton).equals(implClass)) {
            return;
        }
        Method[] methods = implClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (Modifier.isPublic(methods[i].getModifiers())) {
                this.getSyncedOperationsForName(implClass, methods[i].getName());
            }
            ++i;
        }
        if (implClass.isInterface()) {
            Class<?>[] superClasses = implClass.getInterfaces();
            int i2 = 0;
            while (i2 < superClasses.length) {
                Class<?> superClass = superClasses[i2];
                if (this.stopClasses == null || !this.stopClasses.contains(superClass.getName())) {
                    this.loadServiceDescByIntrospection(superClass, true);
                }
                ++i2;
            }
        } else {
            Class superClass = implClass.getSuperclass();
            if (!(superClass == null || superClass.getName().startsWith("java.") || superClass.getName().startsWith("javax.") || this.stopClasses != null && this.stopClasses.contains(superClass.getName()))) {
                this.loadServiceDescByIntrospection(superClass, true);
            }
        }
        this.introspectionComplete = true;
    }

    public void loadServiceDescByIntrospection(Class cls, TypeMapping tm) {
        this.implClass = cls;
        this.tm = tm;
        this.loadServiceDescByIntrospection();
    }

    private void getSyncedOperationsForName(Class implClass, String methodName) {
        ArrayList currentOverloads;
        Iterator i;
        if (implClass == null) {
            return;
        }
        if (this.completedNames == null || this.completedNames.contains(methodName)) {
            return;
        }
        if (this.allowedMethods != null && !this.allowedMethods.contains(methodName)) {
            return;
        }
        if (this.disallowedMethods != null && this.disallowedMethods.contains(methodName)) {
            return;
        }
        if (this.isSkeletonClass && !this.haveAllSkeletonMethods) {
            if (this.skelMethod == null) {
                try {
                    this.skelMethod = implClass.getDeclaredMethod("getOperationDescByName", class$java$lang$String == null ? (class$java$lang$String = ServiceDesc.class$("java.lang.String")) : class$java$lang$String);
                }
                catch (NoSuchMethodException e) {
                }
                catch (SecurityException e) {
                    // empty catch block
                }
                if (this.skelMethod == null) {
                    return;
                }
            }
            try {
                List skelList = (List)this.skelMethod.invoke((Object)implClass, methodName);
                if (skelList != null) {
                    i = skelList.iterator();
                    while (i.hasNext()) {
                        this.addOperationDesc((OperationDesc)i.next());
                    }
                }
            }
            catch (IllegalAccessException e) {
                return;
            }
            catch (IllegalArgumentException e) {
                return;
            }
            catch (InvocationTargetException e) {
                return;
            }
        }
        if (this.name2OperationsMap != null && (currentOverloads = (ArrayList)this.name2OperationsMap.get(methodName)) != null) {
            i = ((AbstractList)currentOverloads).iterator();
            while (i.hasNext()) {
                OperationDesc oper = (OperationDesc)i.next();
                if (oper.getMethod() != null) continue;
                this.syncOperationToClass(oper, implClass);
            }
        }
        this.createOperationsForName(implClass, methodName);
        this.completedNames.add(methodName);
    }

    private void createOperationsForName(Class implClass, String methodName) {
        Method[] methods = implClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (Modifier.isPublic(method.getModifiers()) && method.getName().equals(methodName)) {
                this.createOperationForMethod(method);
            }
            ++i;
        }
        Class superClass = implClass.getSuperclass();
        if (superClass != null && !superClass.getName().startsWith("java.") && !superClass.getName().startsWith("javax.")) {
            this.createOperationsForName(superClass, methodName);
        }
    }

    private void createOperationForMethod(Method method) {
        ArrayList overloads;
        if (this.method2OperationMap.get(method) != null) {
            return;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        ArrayList arrayList = overloads = this.name2OperationsMap == null ? null : (ArrayList)this.name2OperationsMap.get(method.getName());
        if (overloads != null && !overloads.isEmpty()) {
            int i = 0;
            while (i < overloads.size()) {
                Class<?>[] others;
                OperationDesc op = (OperationDesc)overloads.get(i);
                Method checkMethod = op.getMethod();
                if (checkMethod != null && paramTypes.length == (others = checkMethod.getParameterTypes()).length) {
                    int j = 0;
                    while (j < others.length) {
                        if (!others[j].equals(paramTypes[j])) break;
                        ++j;
                    }
                    if (j == others.length) {
                        return;
                    }
                }
                ++i;
            }
        }
        OperationDesc operation = new OperationDesc();
        operation.setName(method.getName());
        String defaultNS = "";
        if (this.namespaceMappings != null && !this.namespaceMappings.isEmpty()) {
            defaultNS = (String)this.namespaceMappings.get(0);
        }
        operation.setElementQName(new QName(defaultNS, method.getName()));
        operation.setMethod(method);
        Class<?> retClass = method.getReturnType();
        operation.setReturnClass(retClass);
        operation.setReturnType(this.tm.getTypeQName(method.getReturnType()));
        String[] paramNames = ExtractorFactory.getExtractor().getParameterNamesFromDebugInfo(method);
        int k = 0;
        while (k < paramTypes.length) {
            Class<?> type = paramTypes[k];
            ParameterDesc paramDesc = new ParameterDesc();
            if (paramNames != null) {
                paramDesc.setName(paramNames[k + 1]);
            } else {
                paramDesc.setName("in" + k);
            }
            Class heldClass = JavaUtils.getHolderValueType(type);
            if (heldClass != null) {
                paramDesc.setMode((byte)3);
                paramDesc.setTypeQName(this.tm.getTypeQName(heldClass));
            } else {
                paramDesc.setMode((byte)1);
                paramDesc.setTypeQName(this.tm.getTypeQName(type));
            }
            paramDesc.setJavaType(type);
            operation.addParameter(paramDesc);
            ++k;
        }
        Class[] exceptionTypes = new Class[method.getExceptionTypes().length];
        exceptionTypes = method.getExceptionTypes();
        int i = 0;
        while (i < exceptionTypes.length) {
            Class ex = exceptionTypes[i];
            if (ex != (class$java$rmi$RemoteException == null ? ServiceDesc.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException) && !ex.getName().startsWith("java.") && !ex.getName().startsWith("javax.")) {
                ParameterDesc param = new ParameterDesc(new QName("", "fault"), 1, this.tm.getTypeQName(ex));
                param.setJavaType(ex);
                ArrayList<ParameterDesc> exceptionParams = new ArrayList<ParameterDesc>();
                exceptionParams.add(param);
                String pkgAndClsName = ex.getName();
                FaultDesc fault = new FaultDesc();
                fault.setName(pkgAndClsName);
                fault.setParameters(exceptionParams);
                operation.addFault(fault);
            }
            ++i;
        }
        this.addOperationDesc(operation);
        this.method2OperationMap.put(method, operation);
    }

    public void setNamespaceMappings(List namespaces) {
        this.namespaceMappings = namespaces;
    }

    public void setDefaultNamespace(String namespace) {
        if (this.namespaceMappings == null) {
            this.namespaceMappings = new ArrayList();
        }
        this.namespaceMappings.add(0, namespace);
    }

    public void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

