/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.description;

import java.lang.reflect.Method;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.JavaUtils;

public class TypeDesc {
    public static final Class[] noClasses = new Class[0];
    public static final Object[] noObjects = new Object[0];
    private Class javaClass = null;
    private QName xmlType = null;
    private FieldDesc[] fields;
    private HashMap fieldNameMap = new HashMap();
    private boolean _hasAttributes = false;

    public TypeDesc(Class javaClass) {
        this.javaClass = javaClass;
    }

    public static TypeDesc getTypeDescForClass(Class cls) {
        try {
            Method getTypeDesc = null;
            try {
                getTypeDesc = cls.getMethod("getTypeDesc", noClasses);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (getTypeDesc == null) {
                Class helper = ClassUtils.forName(cls.getName() + "_Helper");
                try {
                    getTypeDesc = helper.getMethod("getTypeDesc", noClasses);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (getTypeDesc != null) {
                return (TypeDesc)getTypeDesc.invoke(null, noObjects);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public FieldDesc[] getFields() {
        return this.fields;
    }

    public FieldDesc[] getFields(boolean searchParents) {
        TypeDesc superDesc;
        Class cls;
        if (searchParents && (cls = this.javaClass.getSuperclass()) != null && !cls.getName().startsWith("java.") && (superDesc = TypeDesc.getTypeDescForClass(cls)) != null) {
            FieldDesc[] parentFields = superDesc.getFields(true);
            FieldDesc[] ret = new FieldDesc[parentFields.length + this.fields.length];
            System.arraycopy(this.fields, 0, ret, 0, this.fields.length);
            System.arraycopy(parentFields, 0, ret, this.fields.length, parentFields.length);
        }
        return this.fields;
    }

    public void setFields(FieldDesc[] newFields) {
        this.fieldNameMap = new HashMap();
        this.fields = newFields;
        this._hasAttributes = false;
        int i = 0;
        while (i < newFields.length) {
            FieldDesc field = newFields[i];
            if (field.isElement()) {
                this.fieldNameMap.put(field.getFieldName(), field);
            } else {
                this._hasAttributes = true;
            }
            ++i;
        }
    }

    public void addFieldDesc(FieldDesc field) {
        if (field == null) {
            throw new IllegalArgumentException(JavaUtils.getMessage("nullFieldDesc"));
        }
        int numFields = 0;
        if (this.fields != null) {
            numFields = this.fields.length;
        }
        FieldDesc[] newFields = new FieldDesc[numFields + 1];
        if (this.fields != null) {
            System.arraycopy(this.fields, 0, newFields, 0, numFields);
        }
        newFields[numFields] = field;
        this.fields = newFields;
        this.fieldNameMap.put(field.getFieldName(), field);
        if (!this._hasAttributes && !field.isElement()) {
            this._hasAttributes = true;
        }
    }

    public QName getElementNameForField(String fieldName) {
        FieldDesc desc = (FieldDesc)this.fieldNameMap.get(fieldName);
        if (desc == null) {
            TypeDesc superDesc;
            Class cls = this.javaClass.getSuperclass();
            if (cls != null && !cls.getName().startsWith("java.") && (superDesc = TypeDesc.getTypeDescForClass(cls)) != null) {
                return superDesc.getElementNameForField(fieldName);
            }
        } else if (!desc.isElement()) {
            return null;
        }
        return desc.getXmlName();
    }

    public QName getAttributeNameForField(String fieldName) {
        QName ret;
        FieldDesc desc = (FieldDesc)this.fieldNameMap.get(fieldName);
        if (desc == null) {
            TypeDesc superDesc;
            Class cls = this.javaClass.getSuperclass();
            if (cls != null && !cls.getName().startsWith("java.") && (superDesc = TypeDesc.getTypeDescForClass(cls)) != null) {
                return superDesc.getAttributeNameForField(fieldName);
            }
        } else if (desc.isElement()) {
            return null;
        }
        if ((ret = desc.getXmlName()) == null) {
            ret = new QName("", fieldName);
        }
        return ret;
    }

    public String getFieldNameForElement(QName qname, boolean ignoreNS) {
        TypeDesc superDesc;
        if (this.fields == null) {
            return null;
        }
        int i = 0;
        while (i < this.fields.length) {
            FieldDesc field = this.fields[i];
            if (field.isElement()) {
                QName xmlName = field.getXmlName();
                if (qname.getLocalPart().equals(xmlName.getLocalPart()) && (ignoreNS || qname.getNamespaceURI().equals(xmlName.getNamespaceURI()))) {
                    return field.getFieldName();
                }
            }
            ++i;
        }
        Class cls = this.javaClass.getSuperclass();
        if (cls != null && !cls.getName().startsWith("java.") && (superDesc = TypeDesc.getTypeDescForClass(cls)) != null) {
            return superDesc.getFieldNameForElement(qname, ignoreNS);
        }
        return null;
    }

    public String getFieldNameForAttribute(QName qname) {
        TypeDesc superDesc;
        Class cls;
        if (this.fields == null) {
            return null;
        }
        String possibleMatch = null;
        int i = 0;
        while (i < this.fields.length) {
            FieldDesc field = this.fields[i];
            if (!field.isElement()) {
                if (qname.equals(field.getXmlName())) {
                    return field.getFieldName();
                }
                if (qname.getNamespaceURI().equals("") && qname.getLocalPart().equals(field.getFieldName())) {
                    possibleMatch = field.getFieldName();
                }
            }
            ++i;
        }
        if (possibleMatch == null && (cls = this.javaClass.getSuperclass()) != null && !cls.getName().startsWith("java.") && (superDesc = TypeDesc.getTypeDescForClass(cls)) != null) {
            possibleMatch = superDesc.getFieldNameForAttribute(qname);
        }
        return possibleMatch;
    }

    public FieldDesc getFieldByName(String name) {
        TypeDesc superDesc;
        Class cls;
        FieldDesc ret = (FieldDesc)this.fieldNameMap.get(name);
        if (ret == null && (cls = this.javaClass.getSuperclass()) != null && !cls.getName().startsWith("java.") && (superDesc = TypeDesc.getTypeDescForClass(cls)) != null) {
            ret = superDesc.getFieldByName(name);
        }
        return ret;
    }

    public boolean hasAttributes() {
        return this._hasAttributes;
    }

    public QName getXmlType() {
        return this.xmlType;
    }

    public void setXmlType(QName xmlType) {
        this.xmlType = xmlType;
    }
}

