/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import org.apache.axis.AxisEngine;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.encoding.DefaultTypeMappingImpl;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.enum.Style;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.schema.SchemaVersion;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Mapping;
import org.apache.axis.utils.NSStack;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class SerializationContextImpl
implements SerializationContext {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$encoding$SerializationContextImpl == null ? (class$org$apache$axis$encoding$SerializationContextImpl = SerializationContextImpl.class$("org.apache.axis.encoding.SerializationContextImpl")) : class$org$apache$axis$encoding$SerializationContextImpl).getName());
    private NSStack nsStack = new NSStack();
    private boolean writingStartTag = false;
    private boolean onlyXML = true;
    private int indent = 0;
    private boolean startOfDocument = true;
    private Stack elementStack = new Stack();
    private Writer writer;
    private int lastPrefixIndex = 1;
    private MessageContext msgContext;
    private SOAPConstants soapConstants = SOAPConstants.SOAP11_CONSTANTS;
    private boolean pretty = false;
    private static QName multirefQName = new QName("", "multiRef");
    private boolean doMultiRefs = false;
    private boolean sendXMLDecl = true;
    private boolean sendXSIType = true;
    private HashMap multiRefValues = null;
    private int multiRefIndex = -1;
    private HashSet secondLevelObjects = null;
    private Object forceSer = null;
    private boolean outputMultiRefsFlag = false;
    SchemaVersion schemaVersion = SchemaVersion.SCHEMA_2001;
    static /* synthetic */ Class class$org$apache$axis$encoding$SerializationContextImpl;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$org$apache$axis$encoding$Hex;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class array$B;

    public SerializationContextImpl(Writer writer) {
        this.writer = writer;
    }

    public SerializationContextImpl(Writer writer, MessageContext msgContext) {
        this.writer = writer;
        this.msgContext = msgContext;
        AxisEngine optionSource = null;
        if (msgContext != null) {
            SOAPService service;
            Boolean opt;
            Boolean shouldSendMultiRefs;
            if (optionSource == null) {
                optionSource = msgContext.getAxisEngine();
            }
            this.schemaVersion = msgContext.getSchemaVersion();
            Boolean shouldSendDecl = (Boolean)optionSource.getOption("sendXMLDeclaration");
            if (shouldSendDecl != null) {
                this.sendXMLDecl = shouldSendDecl;
            }
            if ((shouldSendMultiRefs = (Boolean)msgContext.getProperty("sendMultiRefs")) == null) {
                shouldSendMultiRefs = (Boolean)optionSource.getOption("sendMultiRefs");
            }
            if (shouldSendMultiRefs != null) {
                this.doMultiRefs = shouldSendMultiRefs;
            }
            if (!msgContext.isPropertyTrue("send_type_attr", true)) {
                this.sendXSIType = false;
            }
            if ((opt = (Boolean)optionSource.getOption("sendXsiTypes")) != null && opt.equals(Boolean.FALSE)) {
                this.sendXSIType = false;
            }
            if ((service = msgContext.getService()) != null && service.getStyle() != Style.RPC) {
                this.sendXSIType = false;
                this.doMultiRefs = false;
            }
        }
    }

    public boolean getPretty() {
        return this.pretty;
    }

    public void setPretty(boolean pretty) {
        this.pretty = pretty;
    }

    public void setDoMultiRefs(boolean shouldDo) {
        this.doMultiRefs = shouldDo;
    }

    public void setSendDecl(boolean sendDecl) {
        this.sendXMLDecl = sendDecl;
    }

    public boolean shouldSendXSIType() {
        return this.sendXSIType;
    }

    public TypeMapping getTypeMapping() {
        if (this.msgContext == null) {
            return DefaultTypeMappingImpl.getSingleton();
        }
        String encodingStyle = this.msgContext.getEncodingStyle();
        if (encodingStyle == null) {
            encodingStyle = this.soapConstants.getEncodingURI();
        }
        return (TypeMapping)this.msgContext.getTypeMappingRegistry().getTypeMapping(encodingStyle);
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.msgContext == null) {
            return null;
        }
        return this.msgContext.getTypeMappingRegistry();
    }

    public String getPrefixForURI(String uri) {
        return this.getPrefixForURI(uri, null, false);
    }

    public String getPrefixForURI(String uri, String defaultPrefix) {
        return this.getPrefixForURI(uri, defaultPrefix, false);
    }

    public String getPrefixForURI(String uri, String defaultPrefix, boolean attribute) {
        if (uri == null || uri.equals("")) {
            return null;
        }
        String prefix = this.nsStack.getPrefix(uri, attribute);
        if (prefix == null && uri.equals(this.soapConstants.getEncodingURI())) {
            prefix = "soapenc";
            this.registerPrefixForURI(prefix, uri);
        }
        if (prefix == null) {
            prefix = defaultPrefix == null ? "ns" + this.lastPrefixIndex++ : defaultPrefix;
            this.registerPrefixForURI(prefix, uri);
        }
        return prefix;
    }

    public void registerPrefixForURI(String prefix, String uri) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("register00", prefix, uri));
        }
        if (uri != null && prefix != null) {
            this.nsStack.add(uri, prefix);
        }
    }

    public Message getCurrentMessage() {
        if (this.msgContext == null) {
            return null;
        }
        return this.msgContext.getCurrentMessage();
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public String qName2String(QName qName, boolean writeNS) {
        String prefix = null;
        if (qName.getNamespaceURI().equals("")) {
            String defaultNS;
            if (writeNS && (defaultNS = this.nsStack.getNamespaceURI("")) != null) {
                this.registerPrefixForURI("", "");
            }
        } else {
            prefix = this.getPrefixForURI(qName.getNamespaceURI());
        }
        return (prefix != null && !prefix.equals("") ? prefix + ":" : "") + qName.getLocalPart();
    }

    public String qName2String(QName qName) {
        return this.qName2String(qName, false);
    }

    public String attributeQName2String(QName qName) {
        String prefix = null;
        if (!qName.getNamespaceURI().equals("")) {
            prefix = this.getPrefixForURI(qName.getNamespaceURI(), null, true);
        }
        String ret = (prefix != null && !prefix.equals("") ? prefix + ":" : "") + qName.getLocalPart();
        return ret;
    }

    public QName getQNameForClass(Class cls) {
        return this.getTypeMapping().getTypeQName(cls);
    }

    public boolean isPrimitive(Object value, Class javaType) {
        if (value == null) {
            return true;
        }
        if (javaType.isPrimitive()) {
            return true;
        }
        if (javaType == (class$java$lang$String == null ? (class$java$lang$String = SerializationContextImpl.class$("java.lang.String")) : class$java$lang$String)) {
            return true;
        }
        if ((class$java$util$Calendar == null ? (class$java$util$Calendar = SerializationContextImpl.class$("java.util.Calendar")) : class$java$util$Calendar).isAssignableFrom(javaType)) {
            return true;
        }
        if ((class$java$util$Date == null ? (class$java$util$Date = SerializationContextImpl.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(javaType)) {
            return true;
        }
        if ((class$org$apache$axis$encoding$Hex == null ? (class$org$apache$axis$encoding$Hex = SerializationContextImpl.class$("org.apache.axis.encoding.Hex")) : class$org$apache$axis$encoding$Hex).isAssignableFrom(javaType)) {
            return true;
        }
        if ((class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = SerializationContextImpl.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element).isAssignableFrom(javaType)) {
            return true;
        }
        if (javaType == (array$B == null ? (array$B = SerializationContextImpl.class$("[B")) : array$B)) {
            return true;
        }
        if (javaType.isArray()) {
            return true;
        }
        QName qName = this.getQNameForClass(javaType);
        return qName != null && Constants.isSchemaXSD(qName.getNamespaceURI()) && (qName.equals(Constants.XSD_BOOLEAN) || qName.equals(Constants.XSD_DOUBLE) || qName.equals(Constants.XSD_FLOAT) || qName.equals(Constants.XSD_INT) || qName.equals(Constants.XSD_LONG) || qName.equals(Constants.XSD_SHORT) || qName.equals(Constants.XSD_BYTE) || qName.equals(Constants.XSD_STRING) || qName.equals(Constants.XSD_INTEGER) || qName.equals(Constants.XSD_DECIMAL));
    }

    public void serialize(QName elemQName, Attributes attributes, Object value, Class javaType) throws IOException {
        this.serialize(elemQName, attributes, value, javaType, null, true, true);
    }

    public void serialize(QName elemQName, Attributes attributes, Object value, Class javaType, QName xmlType, boolean sendNull, boolean sendType) throws IOException {
        Attachments attachments;
        if (value == null) {
            if (sendNull) {
                AttributesImpl attrs = new AttributesImpl();
                if (attributes != null && 0 < attributes.getLength()) {
                    attrs.setAttributes(attributes);
                }
                if (sendType) {
                    attrs = (AttributesImpl)this.setTypeAttribute(attrs, xmlType);
                }
                String nil = this.schemaVersion.getNilQName().getLocalPart();
                attrs.addAttribute(this.schemaVersion.getXsiURI(), nil, "xsi:" + nil, "CDATA", "true");
                this.startElement(elemQName, attrs);
                this.endElement();
            }
            return;
        }
        Message msg = this.getCurrentMessage();
        if (null != msg && null != (attachments = this.getCurrentMessage().getAttachmentsImpl()) && attachments.isAttachment(value)) {
            this.serializeActual(elemQName, attributes, value, javaType, xmlType, sendType);
            return;
        }
        if (this.doMultiRefs && value != this.forceSer && !this.isPrimitive(value, javaType)) {
            String id;
            MultiRefItem mri;
            if (this.multiRefIndex == -1) {
                this.multiRefValues = new HashMap();
            }
            if ((mri = (MultiRefItem)this.multiRefValues.get("" + System.identityHashCode(value))) == null) {
                ++this.multiRefIndex;
                id = "id" + this.multiRefIndex;
                mri = new MultiRefItem(id, javaType, xmlType, sendType, value);
                this.multiRefValues.put("" + System.identityHashCode(value), mri);
                if (this.outputMultiRefsFlag) {
                    if (this.secondLevelObjects == null) {
                        this.secondLevelObjects = new HashSet();
                    }
                    this.secondLevelObjects.add("" + System.identityHashCode(value));
                }
            } else {
                id = mri.id;
            }
            AttributesImpl attrs = new AttributesImpl();
            if (attributes != null && 0 < attributes.getLength()) {
                attrs.setAttributes(attributes);
            }
            attrs.addAttribute("", "href", "href", "CDATA", "#" + id);
            this.startElement(elemQName, attrs);
            this.endElement();
            return;
        }
        if (value == this.forceSer) {
            this.forceSer = null;
        }
        this.serializeActual(elemQName, attributes, value, javaType, xmlType, sendType);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void outputMultiRefs() throws IOException {
        if (!this.doMultiRefs || this.multiRefValues == null) {
            return;
        }
        this.outputMultiRefsFlag = true;
        attrs = new AttributesImpl();
        attrs.addAttribute("", "", "", "", "");
        encodingURI = this.soapConstants.getEncodingURI();
        prefix = this.getPrefixForURI(encodingURI);
        root = prefix + ":root";
        attrs.addAttribute(encodingURI, "root", root, "CDATA", "0");
        encodingStyle = this.msgContext == null ? this.msgContext.getEncodingStyle() : this.soapConstants.getEncodingURI();
        encStyle = this.getPrefixForURI(this.soapConstants.getEnvelopeURI()) + ":" + "encodingStyle";
        attrs.addAttribute(this.soapConstants.getEnvelopeURI(), "encodingStyle", encStyle, "CDATA", encodingStyle);
        i /* !! */  = ((HashMap)this.multiRefValues.clone()).keySet().iterator();
        ** GOTO lbl25
        {
            val = i /* !! */ .next();
            mri = (MultiRefItem)this.multiRefValues.get(val);
            attrs.setAttribute(0, "", "id", "id", "CDATA", mri.id);
            this.forceSer = mri.value;
            this.serialize(SerializationContextImpl.multirefQName, attrs, mri.value, mri.javaType, mri.xmlType, true, true);
            do {
                if (i /* !! */ .hasNext()) continue block0;
                if (this.secondLevelObjects == null) continue;
                i /* !! */  = this.secondLevelObjects.iterator();
                this.secondLevelObjects = null;
lbl25:
                // 3 sources

            } while (i /* !! */ .hasNext());
        }
        this.forceSer = null;
        this.outputMultiRefsFlag = false;
    }

    public void startElement(QName qName, Attributes attributes) throws IOException {
        Vector<String> vecQNames = new Vector<String>();
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("startElem00", "[" + qName.getNamespaceURI() + "]:" + qName.getLocalPart()));
        }
        if (this.startOfDocument && this.sendXMLDecl) {
            this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            this.startOfDocument = false;
        }
        if (this.writingStartTag) {
            this.writer.write(">");
            if (this.pretty) {
                this.writer.write("\n");
            }
            ++this.indent;
        }
        if (this.pretty) {
            int i = 0;
            while (i < this.indent) {
                this.writer.write(32);
                ++i;
            }
        }
        String elementQName = this.qName2String(qName, true);
        this.writer.write("<");
        this.writer.write(elementQName);
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                String qname = attributes.getQName(i);
                this.writer.write(" ");
                String prefix = "";
                String uri = attributes.getURI(i);
                if (uri != null && !uri.equals("")) {
                    if (qname.equals("")) {
                        prefix = this.getPrefixForURI(uri);
                    } else {
                        int idx = qname.indexOf(58);
                        if (idx > -1) {
                            prefix = qname.substring(0, idx);
                            prefix = this.getPrefixForURI(uri, prefix, true);
                        }
                    }
                    qname = !prefix.equals("") ? prefix + ":" + attributes.getLocalName(i) : attributes.getLocalName(i);
                } else {
                    qname = attributes.getQName(i);
                    if (qname.equals("")) {
                        qname = attributes.getLocalName(i);
                    }
                }
                vecQNames.add(qname);
                this.writer.write(qname);
                this.writer.write("=\"");
                this.writer.write(XMLUtils.xmlEncodeString(attributes.getValue(i)));
                this.writer.write("\"");
                ++i;
            }
        }
        ArrayList currentMappings = this.nsStack.peek();
        int i = 0;
        while (i < currentMappings.size()) {
            Mapping map = (Mapping)currentMappings.get(i);
            StringBuffer sb = new StringBuffer("xmlns");
            if (!map.getPrefix().equals("")) {
                sb.append(":");
                sb.append(map.getPrefix());
            }
            if (vecQNames.indexOf(sb.toString()) == -1) {
                this.writer.write(" ");
                this.writer.write(sb.toString());
                this.writer.write("=\"");
                this.writer.write(map.getNamespaceURI());
                this.writer.write("\"");
            }
            ++i;
        }
        this.writingStartTag = true;
        this.elementStack.push(elementQName);
        this.nsStack.push();
        this.writer.flush();
        this.onlyXML = true;
    }

    public void endElement() throws IOException {
        String elementQName = (String)this.elementStack.pop();
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("endElem00", "" + elementQName));
        }
        this.nsStack.pop();
        this.nsStack.peek().clear();
        if (this.writingStartTag) {
            this.writer.write("/>");
            if (this.pretty) {
                this.writer.write("\n");
            }
            this.writingStartTag = false;
            return;
        }
        if (this.onlyXML) {
            --this.indent;
            if (this.pretty) {
                int i = 0;
                while (i < this.indent) {
                    this.writer.write(32);
                    ++i;
                }
            }
        }
        this.writer.write("</");
        this.writer.write(elementQName);
        this.writer.write(62);
        if (this.pretty && this.indent > 0) {
            this.writer.write(10);
        }
        this.writer.flush();
        this.onlyXML = true;
    }

    public void writeChars(char[] p1, int p2, int p3) throws IOException {
        if (this.writingStartTag) {
            this.writer.write(">");
            this.writingStartTag = false;
        }
        this.writeSafeString(String.valueOf(p1, p2, p3));
        this.writer.flush();
        this.onlyXML = false;
    }

    public void writeString(String string) throws IOException {
        if (this.writingStartTag) {
            this.writer.write(">");
            this.writingStartTag = false;
        }
        this.writer.write(string);
        this.writer.flush();
        this.onlyXML = false;
    }

    public void writeSafeString(String string) throws IOException {
        this.writeString(XMLUtils.xmlEncodeString(string));
    }

    public void writeDOMElement(Element el) throws IOException {
        AttributesImpl attributes = null;
        NamedNodeMap attrMap = el.getAttributes();
        if (attrMap.getLength() > 0) {
            attributes = new AttributesImpl();
            int i = 0;
            while (i < attrMap.getLength()) {
                Attr attr = (Attr)attrMap.item(i);
                String tmp = attr.getNamespaceURI();
                if (tmp != null && tmp.equals("http://www.w3.org/2000/xmlns/")) {
                    String prefix = attr.getLocalName();
                    if (prefix != null) {
                        if (prefix.equals("xmlns")) {
                            prefix = "";
                        }
                        String nsURI = attr.getValue();
                        this.registerPrefixForURI(prefix, nsURI);
                    }
                } else {
                    attributes.addAttribute(attr.getNamespaceURI(), attr.getLocalName(), attr.getName(), "CDATA", attr.getValue());
                }
                ++i;
            }
        }
        String namespaceURI = el.getNamespaceURI();
        String localPart = el.getLocalName();
        if (namespaceURI == null || namespaceURI.length() == 0) {
            localPart = el.getNodeName();
        }
        QName qName = new QName(namespaceURI, localPart);
        this.startElement(qName, attributes);
        NodeList children = el.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element) {
                this.writeDOMElement((Element)child);
            } else if (child instanceof Text) {
                this.writeSafeString(((Text)child).getData());
            }
            ++i;
        }
        this.endElement();
    }

    public final Serializer getSerializerForJavaType(Class javaType) {
        SerializerFactory serF = null;
        Serializer ser = null;
        try {
            serF = (SerializerFactory)this.getTypeMapping().getSerializer(javaType);
            if (serF != null) {
                ser = (Serializer)serF.getSerializerAs("Axis SAX Mechanism");
            }
        }
        catch (JAXRPCException e) {
            // empty catch block
        }
        return ser;
    }

    public Attributes setTypeAttribute(Attributes attributes, QName type) {
        if (type == null || !this.shouldSendXSIType() || type.getLocalPart().indexOf(">") >= 0 || attributes != null && attributes.getIndex("http://www.w3.org/2001/XMLSchema-instance", "type") != -1) {
            return attributes;
        }
        AttributesImpl attrs = new AttributesImpl();
        if (attributes != null && 0 < attributes.getLength()) {
            attrs.setAttributes(attributes);
        }
        String prefix = this.getPrefixForURI("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        attrs.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", prefix + ":type", "CDATA", this.qName2String(type));
        return attrs;
    }

    public void serializeActual(QName elemQName, Attributes attributes, Object value, Class javaType, QName xmlType, boolean sendType) throws IOException {
        if (value != null) {
            TypeMapping tm = this.getTypeMapping();
            if (tm == null) {
                throw new IOException(JavaUtils.getMessage("noSerializer00", value.getClass().getName(), "" + this));
            }
            SerializerInfo info = null;
            if (javaType != null && !javaType.isPrimitive() && !javaType.isArray() && !this.isPrimitive(value, javaType) && Modifier.isAbstract(javaType.getModifiers()) && (info = this.getSerializer(value.getClass(), value)) != null) {
                sendType = true;
                xmlType = null;
            }
            if (info == null && xmlType != null) {
                info = this.getSerializer(javaType, xmlType);
            }
            if (info == null) {
                info = this.getSerializer(javaType, value);
                sendType = true;
                xmlType = null;
            }
            if (info != null) {
                if (sendType) {
                    if (xmlType == null) {
                        xmlType = tm.getTypeQName(info.javaType);
                    }
                    attributes = this.setTypeAttribute(attributes, xmlType);
                }
                info.ser.serialize(elemQName, attributes, value, this);
                return;
            }
            throw new IOException(JavaUtils.getMessage("noSerializer00", value.getClass().getName(), "" + tm));
        }
    }

    private SerializerInfo getSerializer(Class javaType, QName xmlType) {
        SerializerInfo info = null;
        SerializerFactory serFactory = null;
        TypeMapping tm = this.getTypeMapping();
        try {
            if (!javaType.getName().equals("java.lang.Object") && tm.isRegistered(javaType, xmlType)) {
                serFactory = (SerializerFactory)tm.getSerializer(javaType, xmlType);
            }
        }
        catch (JAXRPCException e) {
            // empty catch block
        }
        Serializer ser = null;
        if (serFactory != null) {
            ser = (Serializer)serFactory.getSerializerAs("Axis SAX Mechanism");
        }
        if (ser != null) {
            info = new SerializerInfo();
            info.ser = ser;
            info.javaType = javaType;
        }
        return info;
    }

    private SerializerInfo getSerializer(Class javaType, Object value) {
        SerializerInfo info = null;
        SerializerFactory serFactory = null;
        TypeMapping tm = this.getTypeMapping();
        ArrayList classes = null;
        boolean firstPass = true;
        Class<Object> _class = javaType;
        while (_class != null) {
            try {
                if (!_class.getName().equals("java.lang.Object")) {
                    serFactory = (SerializerFactory)tm.getSerializer(_class);
                }
            }
            catch (JAXRPCException e) {
                // empty catch block
            }
            if (serFactory != null) break;
            if (classes == null) {
                classes = new ArrayList();
            }
            Class<?>[] ifaces = _class.getInterfaces();
            int i = 0;
            while (i < ifaces.length) {
                classes.add(ifaces[i]);
                ++i;
            }
            if ((_class = _class.getSuperclass()) != null && !_class.getName().equals("java.lang.Object")) {
                classes.add(_class);
            }
            Class<Object> clazz = _class = !classes.isEmpty() ? (Class<Object>)classes.remove(0) : null;
            if (_class != null || value == null || value.getClass() == javaType || !firstPass) continue;
            firstPass = false;
            _class = value.getClass();
        }
        Serializer ser = null;
        if (serFactory != null) {
            ser = (Serializer)serFactory.getSerializerAs("Axis SAX Mechanism");
        }
        if (ser != null) {
            info = new SerializerInfo();
            info.ser = ser;
            info.javaType = _class;
        }
        return info;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SerializerInfo {
        Serializer ser;
        Class javaType;

        SerializerInfo() {
        }
    }

    class MultiRefItem {
        String id;
        Class javaType;
        QName xmlType;
        boolean sendType;
        Object value;

        MultiRefItem(String id, Class javaType, QName xmlType, boolean sendType, Object value) {
            this.id = id;
            this.javaType = javaType;
            this.xmlType = xmlType;
            this.sendType = sendType;
            this.value = value;
        }
    }
}

