/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class ArraySerializer
implements Serializer {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$encoding$ser$ArraySerializer == null ? (class$org$apache$axis$encoding$ser$ArraySerializer = ArraySerializer.class$("org.apache.axis.encoding.ser.ArraySerializer")) : class$org$apache$axis$encoding$ser$ArraySerializer).getName());
    QName componentQName;
    static /* synthetic */ Class class$org$apache$axis$encoding$ser$ArraySerializer;
    static /* synthetic */ Class class$java$lang$Object;

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        boolean isEncoded;
        if (value == null) {
            throw new IOException(JavaUtils.getMessage("cantDoNullArray00"));
        }
        Class<?> cls = value.getClass();
        Collection list = null;
        if (!cls.isArray()) {
            if (!(value instanceof Collection)) {
                throw new IOException(JavaUtils.getMessage("cantSerialize00", cls.getName()));
            }
            list = (Collection)value;
        }
        Class componentType = list == null ? cls.getComponentType() : (class$java$lang$Object == null ? (class$java$lang$Object = ArraySerializer.class$("java.lang.Object")) : class$java$lang$Object);
        String dims = "";
        while (componentType.isArray()) {
            componentType = componentType.getComponentType();
            dims = dims + "[]";
        }
        this.componentQName = context.getQNameForClass(componentType);
        if (this.componentQName == null) {
            throw new IOException(JavaUtils.getMessage("noType00", componentType.getName()));
        }
        String prefix = context.getPrefixForURI(this.componentQName.getNamespaceURI());
        String compType = prefix + ":" + this.componentQName.getLocalPart();
        int len = list == null ? Array.getLength(value) : list.size();
        String arrayType = compType + dims + "[" + len + "]";
        int dim2Len = -1;
        boolean enable2Dim = true;
        if (enable2Dim && !dims.equals("") && cls.isArray() && len > 0) {
            boolean okay = true;
            int i = 0;
            while (i < len && okay) {
                Object elementValue = Array.get(value, i);
                if (elementValue == null) {
                    okay = false;
                } else if (dim2Len < 0) {
                    dim2Len = Array.getLength(elementValue);
                    if (dim2Len <= 0) {
                        okay = false;
                    }
                } else if (dim2Len != Array.getLength(elementValue)) {
                    okay = false;
                }
                ++i;
            }
            if (okay) {
                dims = dims.substring(0, dims.length() - 2);
                arrayType = compType + dims + "[" + len + "," + dim2Len + "]";
            } else {
                dim2Len = -1;
            }
        }
        if (isEncoded = context.getMessageContext().isEncoded()) {
            int typeI;
            AttributesImpl attrs = attributes != null ? new AttributesImpl(attributes) : new AttributesImpl();
            if (attrs.getIndex("http://schemas.xmlsoap.org/soap/encoding/", "arrayType") == -1) {
                String encprefix = context.getPrefixForURI("http://schemas.xmlsoap.org/soap/encoding/");
                attrs.addAttribute("http://schemas.xmlsoap.org/soap/encoding/", "arrayType", encprefix + ":arrayType", "CDATA", arrayType);
            }
            if ((typeI = attrs.getIndex("http://www.w3.org/2001/XMLSchema-instance", "type")) != -1) {
                String qname = context.getPrefixForURI("http://www.w3.org/2001/XMLSchema-instance", "xsi") + ":type";
                attrs.setAttribute(typeI, "http://www.w3.org/2001/XMLSchema-instance", "type", qname, "CDATA", context.qName2String(Constants.SOAP_ARRAY));
            }
            attributes = attrs;
        }
        QName elementName = name;
        if (isEncoded) {
            context.startElement(name, attributes);
            elementName = Constants.QNAME_LITERAL_ITEM;
        }
        if (dim2Len < 0) {
            Object aValue;
            if (list == null) {
                int index = 0;
                while (index < len) {
                    aValue = Array.get(value, index);
                    Class<?> aClass = aValue == null ? null : aValue.getClass();
                    context.serialize(elementName, null, aValue, aClass, this.componentQName, true, false);
                    ++index;
                }
            } else {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    aValue = iterator.next();
                    Class<?> aClass = aValue == null ? null : aValue.getClass();
                    context.serialize(elementName, null, aValue, aClass, this.componentQName, true, false);
                }
            }
        } else {
            int index = 0;
            while (index < len) {
                int index2 = 0;
                while (index2 < dim2Len) {
                    Object aValue = Array.get(Array.get(value, index), index2);
                    Class<?> aClass = aValue == null ? null : aValue.getClass();
                    context.serialize(elementName, null, aValue, aClass);
                    ++index2;
                }
                ++index;
            }
        }
        if (isEncoded) {
            context.endElement();
        }
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public boolean writeSchema(Types types) throws Exception {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

