/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.ser.BeanPropertyTarget;
import org.apache.axis.encoding.ser.SimpleDeserializer;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.BeanUtils;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BeanDeserializer
extends DeserializerImpl
implements Serializable {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$encoding$ser$BeanDeserializer == null ? (class$org$apache$axis$encoding$ser$BeanDeserializer = BeanDeserializer.class$("org.apache.axis.encoding.ser.BeanDeserializer")) : class$org$apache$axis$encoding$ser$BeanDeserializer).getName());
    QName xmlType;
    Class javaType;
    protected HashMap propertyMap = new HashMap();
    protected QName prevQName;
    public static final String DESERIALIZE_ANY = "DeserializeAny";
    protected TypeDesc typeDesc = null;
    protected int collectionIndex = -1;
    static /* synthetic */ Class class$org$apache$axis$encoding$ser$BeanDeserializer;

    public BeanDeserializer(Class javaType, QName xmlType) {
        this(javaType, xmlType, TypeDesc.getTypeDescForClass(javaType));
    }

    public BeanDeserializer(Class javaType, QName xmlType, TypeDesc typeDesc) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.typeDesc = typeDesc;
        BeanPropertyDescriptor[] pd = BeanUtils.getPd(javaType, typeDesc);
        int i = 0;
        while (i < pd.length) {
            BeanPropertyDescriptor descriptor = pd[i];
            this.propertyMap.put(descriptor.getName(), descriptor);
            ++i;
        }
        try {
            this.value = javaType.newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void startElement(String namespace, String localName, String qName, Attributes attributes, DeserializationContext context) throws SAXException {
        if (this.value == null) {
            try {
                this.value = this.javaType.newInstance();
            }
            catch (Exception e) {
                throw new SAXException(JavaUtils.getMessage("cantCreateBean00", this.javaType.getName(), e.toString()));
            }
        }
        super.startElement(namespace, localName, qName, attributes, context);
    }

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        BeanPropertyDescriptor propDesc = null;
        QName elemQName = new QName(namespace, localName);
        if (this.prevQName == null || !this.prevQName.equals(elemQName)) {
            this.prevQName = elemQName;
            this.collectionIndex = -1;
        }
        this.prevQName = elemQName;
        if (this.typeDesc != null) {
            String fieldName = this.typeDesc.getFieldNameForElement(elemQName, false);
            if (fieldName == null && (prefix == null || prefix.equals(""))) {
                fieldName = this.typeDesc.getFieldNameForElement(new QName("", elemQName.getLocalPart()), false);
            }
            propDesc = (BeanPropertyDescriptor)this.propertyMap.get(fieldName);
        }
        if (propDesc == null) {
            propDesc = (BeanPropertyDescriptor)this.propertyMap.get(localName);
        }
        if (propDesc == null) {
            Class superClass = this.javaType;
            while (superClass != null && propDesc == null) {
                TypeDesc td;
                if ((superClass = superClass.getSuperclass()) == null || (td = TypeDesc.getTypeDescForClass(superClass)) == null) continue;
                String fieldName = td.getFieldNameForElement(elemQName, false);
                if (fieldName == null && (prefix == null || prefix.equals(""))) {
                    fieldName = td.getFieldNameForElement(new QName("", elemQName.getLocalPart()), false);
                }
                propDesc = (BeanPropertyDescriptor)this.propertyMap.get(fieldName);
            }
        }
        QName qn = null;
        Deserializer dSer = null;
        MessageContext messageContext = context.getMessageContext();
        if (propDesc == null && !messageContext.isEncoded() && (propDesc = this.getObjectPropertyDesc(elemQName, context)) != null) {
            Boolean deserializeAny = (Boolean)messageContext.getProperty(DESERIALIZE_ANY);
            if (deserializeAny != null && deserializeAny.booleanValue()) {
                dSer = context.getDeserializerForType(elemQName);
            }
            if (dSer == null) {
                qn = Constants.XSD_ANY;
                messageContext.setProperty("DeserializeCurrentElement", Boolean.TRUE);
            } else {
                qn = elemQName;
            }
        }
        if (propDesc == null) {
            throw new SAXException(JavaUtils.getMessage("badElem00", this.javaType.getName(), localName));
        }
        if (qn == null) {
            qn = context.getTypeFromAttributes(namespace, localName, attributes);
        }
        if (dSer == null) {
            dSer = context.getDeserializerForType(qn);
        }
        if (dSer == null) {
            dSer = new DeserializerImpl();
            TypeMapping tm = context.getTypeMapping();
            Class type = propDesc.getType();
            dSer.setDefaultType(tm.getTypeQName(type));
        }
        if (propDesc.isWriteable()) {
            if (!propDesc.isIndexed()) {
                this.collectionIndex = -1;
                dSer.registerValueTarget(new BeanPropertyTarget(this.value, propDesc));
            } else {
                ++this.collectionIndex;
                dSer.registerValueTarget(new BeanPropertyTarget(this.value, propDesc, this.collectionIndex));
            }
        }
        return (SOAPHandler)((Object)dSer);
    }

    public BeanPropertyDescriptor getObjectPropertyDesc(QName qname, DeserializationContext context) {
        Iterator iterator = this.propertyMap.values().iterator();
        while (iterator.hasNext()) {
            BeanPropertyDescriptor propertyDesc = (BeanPropertyDescriptor)iterator.next();
            if (!propertyDesc.getName().equals("any") || !propertyDesc.getType().getName().equals("java.lang.Object")) continue;
            return propertyDesc;
        }
        return null;
    }

    public void onStartElement(String namespace, String localName, String qName, Attributes attributes, DeserializationContext context) throws SAXException {
        if (this.value == null) {
            try {
                this.value = this.javaType.newInstance();
            }
            catch (Exception e) {
                throw new SAXException(JavaUtils.getMessage("cantCreateBean00", this.javaType.getName(), e.toString()));
            }
        }
        if (this.typeDesc == null) {
            return;
        }
        int i = 0;
        while (i < attributes.getLength()) {
            BeanPropertyDescriptor bpd;
            QName attrQName = new QName(attributes.getURI(i), attributes.getLocalName(i));
            String fieldName = this.typeDesc.getFieldNameForAttribute(attrQName);
            if (fieldName != null && (bpd = (BeanPropertyDescriptor)this.propertyMap.get(fieldName)) != null && bpd.isWriteable() && !bpd.isIndexed()) {
                Class type;
                TypeMapping tm = context.getTypeMapping();
                QName qn = tm.getTypeQName(type = bpd.getType());
                if (qn == null) {
                    throw new SAXException(JavaUtils.getMessage("unregistered00", type.toString()));
                }
                Deserializer dSer = context.getDeserializerForType(qn);
                if (dSer == null) {
                    throw new SAXException(JavaUtils.getMessage("noDeser00", type.toString()));
                }
                if (!(dSer instanceof SimpleDeserializer)) {
                    throw new SAXException(JavaUtils.getMessage("AttrNotSimpleType00", bpd.getName(), type.toString()));
                }
                try {
                    dSer.onStartElement(namespace, localName, qName, attributes, context);
                    Object val = ((SimpleDeserializer)dSer).makeValue(attributes.getValue(i));
                    bpd.set(this.value, val);
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

