/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.AttributeSerializationContextImpl;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.BeanUtils;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class BeanSerializer
implements Serializer,
Serializable {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$encoding$ser$BeanSerializer == null ? (class$org$apache$axis$encoding$ser$BeanSerializer = BeanSerializer.class$("org.apache.axis.encoding.ser.BeanSerializer")) : class$org$apache$axis$encoding$ser$BeanSerializer).getName());
    QName xmlType;
    Class javaType;
    protected BeanPropertyDescriptor[] propertyDescriptor = null;
    protected TypeDesc typeDesc = null;
    static /* synthetic */ Class class$org$apache$axis$encoding$ser$BeanSerializer;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$org$apache$axis$AxisFault;

    public BeanSerializer(Class javaType, QName xmlType) {
        this(javaType, xmlType, TypeDesc.getTypeDescForClass(javaType));
    }

    public BeanSerializer(Class javaType, QName xmlType, TypeDesc typeDesc) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.typeDesc = typeDesc;
        this.propertyDescriptor = BeanUtils.getPd(javaType, typeDesc);
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        boolean suppressElement;
        Attributes beanAttrs = this.getObjectAttributes(value, attributes, context);
        String encodingStyle = context.getMessageContext().getEncodingStyle();
        boolean bl = suppressElement = !context.getMessageContext().isEncoded() && name.getNamespaceURI().equals("") && name.getLocalPart().equals("any");
        if (!suppressElement) {
            context.startElement(name, beanAttrs);
        }
        try {
            int i = 0;
            while (i < this.propertyDescriptor.length) {
                block16: {
                    boolean isOmittable;
                    QName qname;
                    String propName;
                    block17: {
                        FieldDesc field;
                        propName = this.propertyDescriptor[i].getName();
                        if (propName.equals("class")) break block16;
                        qname = null;
                        isOmittable = false;
                        if (this.typeDesc == null || (field = this.typeDesc.getFieldByName(propName)) == null) break block17;
                        if (!field.isElement()) break block16;
                        qname = field.getXmlName();
                        isOmittable = field.isMinOccursIs0();
                    }
                    if (qname == null) {
                        qname = new QName("", propName);
                    }
                    if (this.propertyDescriptor[i].isReadable()) {
                        Class<?> javaType;
                        Class<?> baseJavaType = this.propertyDescriptor[i].getType();
                        if (!this.propertyDescriptor[i].isIndexed()) {
                            Object propValue = this.propertyDescriptor[i].get(value);
                            if (propValue != null || !isOmittable || Constants.isSOAP_ENC(encodingStyle)) {
                                javaType = propValue == null || baseJavaType.isPrimitive() ? baseJavaType : propValue.getClass();
                                context.serialize(qname, null, propValue, javaType);
                            }
                        } else {
                            int j = 0;
                            while (j >= 0) {
                                Object propValue = null;
                                try {
                                    propValue = this.propertyDescriptor[i].get(value, j);
                                    ++j;
                                }
                                catch (Exception e) {
                                    j = -1;
                                }
                                if (j < 0) continue;
                                javaType = propValue == null || baseJavaType.isPrimitive() ? baseJavaType : propValue.getClass();
                                context.serialize(qname, null, propValue, javaType);
                            }
                        }
                    }
                }
                ++i;
            }
        }
        catch (InvocationTargetException ite) {
            Throwable target = ite.getTargetException();
            log.error((Object)JavaUtils.getMessage("exception00"), target);
            throw new IOException(target.toString());
        }
        catch (Exception e) {
            log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
            throw new IOException(e.toString());
        }
        if (!suppressElement) {
            context.endElement();
        }
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public boolean writeSchema(Types types) throws Exception {
        Element complexType = types.createElement("complexType");
        types.writeSchemaElement(this.xmlType, complexType);
        complexType.setAttribute("name", this.xmlType.getLocalPart());
        Element e = null;
        Class superClass = this.javaType.getSuperclass();
        BeanPropertyDescriptor[] superPd = null;
        List stopClasses = types.getStopClasses();
        if (!(superClass == null || superClass == (class$java$lang$Object == null ? (class$java$lang$Object = BeanSerializer.class$("java.lang.Object")) : class$java$lang$Object) || superClass == (class$java$lang$Exception == null ? (class$java$lang$Exception = BeanSerializer.class$("java.lang.Exception")) : class$java$lang$Exception) || superClass == (class$org$apache$axis$AxisFault == null ? (class$org$apache$axis$AxisFault = BeanSerializer.class$("org.apache.axis.AxisFault")) : class$org$apache$axis$AxisFault) || stopClasses != null && stopClasses.contains(superClass.getName()))) {
            String base = types.writeType(superClass);
            Element complexContent = types.createElement("complexContent");
            complexType.appendChild(complexContent);
            Element extension = types.createElement("extension");
            complexContent.appendChild(extension);
            extension.setAttribute("base", base);
            e = extension;
            superPd = BeanUtils.getPd(superClass, TypeDesc.getTypeDescForClass(superClass));
        } else {
            e = complexType;
        }
        Element all = types.createElement("sequence");
        e.appendChild(all);
        if (Modifier.isAbstract(this.javaType.getModifiers())) {
            complexType.setAttribute("abstract", "true");
        }
        int i = 0;
        while (i < this.propertyDescriptor.length) {
            String propName = this.propertyDescriptor[i].getName();
            boolean writeProperty = true;
            if (propName.equals("class")) {
                writeProperty = false;
            }
            if (superPd != null && writeProperty) {
                int j = 0;
                while (j < superPd.length && writeProperty) {
                    if (propName.equals(superPd[j].getName())) {
                        writeProperty = false;
                    }
                    ++j;
                }
            }
            if (writeProperty) {
                if (this.typeDesc != null) {
                    FieldDesc field = this.typeDesc.getFieldByName(propName);
                    if (field != null) {
                        QName qname = field.getXmlName();
                        if (qname != null) {
                            propName = qname.getLocalPart();
                        }
                        if (!field.isElement()) {
                            this.writeAttribute(types, propName, this.propertyDescriptor[i].getType(), complexType);
                        } else {
                            this.writeField(types, propName, this.propertyDescriptor[i].getType(), this.propertyDescriptor[i].isIndexed(), field.isMinOccursIs0(), all);
                        }
                    } else {
                        this.writeField(types, propName, this.propertyDescriptor[i].getType(), this.propertyDescriptor[i].isIndexed(), false, all);
                    }
                } else {
                    this.writeField(types, propName, this.propertyDescriptor[i].getType(), this.propertyDescriptor[i].isIndexed(), false, all);
                }
            }
            ++i;
        }
        return true;
    }

    protected void writeField(Types types, String fieldName, Class fieldType, boolean isUnbounded, boolean isOmittable, Element where) throws Exception {
        String elementType = types.writeType(fieldType);
        Element elem = types.createElement(fieldName, elementType, types.isNullable(fieldType), isOmittable, where.getOwnerDocument());
        if (isUnbounded) {
            elem.setAttribute("maxOccurs", "unbounded");
        }
        where.appendChild(elem);
    }

    protected void writeAttribute(Types types, String fieldName, Class fieldType, Element where) throws Exception {
        if (!types.isAcceptableAsAttribute(fieldType)) {
            throw new AxisFault(JavaUtils.getMessage("AttrNotSimpleType00", fieldName, fieldType.getName()));
        }
        String elementType = types.writeType(fieldType);
        Element elem = types.createAttributeElement(fieldName, elementType, false, where.getOwnerDocument());
        where.appendChild(elem);
    }

    protected Attributes getObjectAttributes(Object value, Attributes attributes, SerializationContext context) {
        if (this.typeDesc == null || !this.typeDesc.hasAttributes()) {
            return attributes;
        }
        AttributesImpl attrs = attributes != null ? new AttributesImpl(attributes) : new AttributesImpl();
        try {
            int i = 0;
            while (i < this.propertyDescriptor.length) {
                FieldDesc field;
                String propName = this.propertyDescriptor[i].getName();
                if (!propName.equals("class") && (field = this.typeDesc.getFieldByName(propName)) != null && !field.isElement()) {
                    Object propValue;
                    QName qname = field.getXmlName();
                    if (qname == null) {
                        qname = new QName("", propName);
                    }
                    if (this.propertyDescriptor[i].isReadable() && !this.propertyDescriptor[i].isIndexed() && (propValue = this.propertyDescriptor[i].get(value)) != null) {
                        this.setAttributeProperty(propValue, qname, attrs, context);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            return attrs;
        }
        return attrs;
    }

    private void setAttributeProperty(Object propValue, QName qname, AttributesImpl attrs, SerializationContext context) throws Exception {
        StringWriter writer = new StringWriter();
        AttributeSerializationContextImpl attributeContext = new AttributeSerializationContextImpl((Writer)writer, context);
        attributeContext.serialize(qname, null, propValue, propValue.getClass());
        writer.close();
        String propString = writer.getBuffer().toString();
        String namespace = qname.getNamespaceURI();
        String localName = qname.getLocalPart();
        attrs.addAttribute(namespace, localName, context.attributeQName2String(qname), "CDATA", propString);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

