/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.SimpleType;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.BeanUtils;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.fromJava.Types;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class SimpleSerializer
implements Serializer {
    public QName xmlType;
    public Class javaType;
    private BeanPropertyDescriptor[] propertyDescriptor = null;
    private TypeDesc typeDesc = null;
    static /* synthetic */ Class class$org$apache$axis$encoding$SimpleType;
    static /* synthetic */ Class class$java$lang$Object;

    public SimpleSerializer(Class javaType, QName xmlType) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        if ((class$org$apache$axis$encoding$SimpleType == null ? (class$org$apache$axis$encoding$SimpleType = SimpleSerializer.class$("org.apache.axis.encoding.SimpleType")) : class$org$apache$axis$encoding$SimpleType).isAssignableFrom(javaType)) {
            this.typeDesc = TypeDesc.getTypeDescForClass(javaType);
            this.propertyDescriptor = BeanUtils.getPd(javaType, this.typeDesc);
        }
    }

    public SimpleSerializer(Class javaType, QName xmlType, TypeDesc typeDesc) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.typeDesc = typeDesc;
        if ((class$org$apache$axis$encoding$SimpleType == null ? (class$org$apache$axis$encoding$SimpleType = SimpleSerializer.class$("org.apache.axis.encoding.SimpleType")) : class$org$apache$axis$encoding$SimpleType).isAssignableFrom(javaType)) {
            this.propertyDescriptor = BeanUtils.getPd(javaType, typeDesc);
        }
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        if (value != null && value.getClass() == (class$java$lang$Object == null ? (class$java$lang$Object = SimpleSerializer.class$("java.lang.Object")) : class$java$lang$Object)) {
            throw new IOException(JavaUtils.getMessage("cantSerialize02"));
        }
        if (value instanceof SimpleType) {
            attributes = this.getObjectAttributes(value, attributes, context);
        }
        context.startElement(name, attributes);
        if (value != null) {
            if (value instanceof Float || value instanceof Double) {
                double data = 0.0;
                data = value instanceof Float ? ((Float)value).doubleValue() : ((Double)value).doubleValue();
                if (Double.isNaN(data)) {
                    context.writeString("NaN");
                } else if (data == Double.POSITIVE_INFINITY) {
                    context.writeString("INF");
                } else if (data == Double.NEGATIVE_INFINITY) {
                    context.writeString("-INF");
                } else {
                    context.writeString(value.toString());
                }
            } else if (value instanceof String) {
                context.writeString(XMLUtils.xmlEncodeString(value.toString()));
            } else if (value instanceof SimpleType) {
                context.writeString(value.toString());
            } else {
                context.writeString(value.toString());
            }
        }
        context.endElement();
    }

    private Attributes getObjectAttributes(Object value, Attributes attributes, SerializationContext context) {
        if (this.typeDesc == null || !this.typeDesc.hasAttributes()) {
            return attributes;
        }
        AttributesImpl attrs = attributes != null ? new AttributesImpl(attributes) : new AttributesImpl();
        try {
            int i = 0;
            while (i < this.propertyDescriptor.length) {
                FieldDesc field;
                String propName = this.propertyDescriptor[i].getName();
                if (!propName.equals("class") && (field = this.typeDesc.getFieldByName(propName)) != null && !field.isElement()) {
                    Object propValue;
                    QName qname = field.getXmlName();
                    if (qname == null) {
                        qname = new QName("", propName);
                    }
                    if (this.propertyDescriptor[i].isReadable() && !this.propertyDescriptor[i].isIndexed() && (propValue = this.propertyDescriptor[i].get(value)) != null) {
                        String propString = propValue.toString();
                        String namespace = qname.getNamespaceURI();
                        String localName = qname.getLocalPart();
                        attrs.addAttribute(namespace, localName, context.qName2String(qname), "CDATA", propString);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            return attrs;
        }
        return attrs;
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public boolean writeSchema(Types types) throws Exception {
        if (!(class$org$apache$axis$encoding$SimpleType == null ? (class$org$apache$axis$encoding$SimpleType = SimpleSerializer.class$("org.apache.axis.encoding.SimpleType")) : class$org$apache$axis$encoding$SimpleType).isAssignableFrom(this.javaType)) {
            return false;
        }
        Element complexType = types.createElement("complexType");
        types.writeSchemaElement(this.xmlType, complexType);
        complexType.setAttribute("name", this.xmlType.getLocalPart());
        Element simpleContent = types.createElement("simpleContent");
        complexType.appendChild(simpleContent);
        Element extension = types.createElement("extension");
        simpleContent.appendChild(extension);
        String base = "string";
        int i = 0;
        while (i < this.propertyDescriptor.length) {
            String propName = this.propertyDescriptor[i].getName();
            if (!propName.equals("value")) {
                FieldDesc field;
                if (this.typeDesc != null && (field = this.typeDesc.getFieldByName(propName)) != null) {
                    Class fieldType;
                    QName qname;
                    if (field.isElement()) {
                        // empty if block
                    }
                    if ((qname = field.getXmlName()) == null) {
                        qname = new QName("", propName);
                    }
                    if (!types.isAcceptableAsAttribute(fieldType = this.propertyDescriptor[i].getType())) {
                        throw new AxisFault(JavaUtils.getMessage("AttrNotSimpleType00", propName, fieldType.getName()));
                    }
                    String elementType = types.writeType(fieldType);
                    Element elem = types.createAttributeElement(propName, elementType, false, extension.getOwnerDocument());
                    extension.appendChild(elem);
                }
            } else {
                BeanPropertyDescriptor bpd = this.propertyDescriptor[i];
                Class type = bpd.getType();
                if (!types.isAcceptableAsAttribute(type)) {
                    throw new AxisFault(JavaUtils.getMessage("AttrNotSimpleType01", type.getName()));
                }
                base = types.writeType(type);
                extension.setAttribute("base", base);
            }
            ++i;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

