/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.handlers.soap;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.DefaultTypeMappingImpl;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.enum.Style;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.LockableHashtable;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.utils.cache.ClassCache;
import org.apache.axis.utils.cache.JavaClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class SOAPService
extends SimpleTargetedChain {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$handlers$soap$SOAPService == null ? (class$org$apache$axis$handlers$soap$SOAPService = SOAPService.class$("org.apache.axis.handlers.soap.SOAPService")) : class$org$apache$axis$handlers$soap$SOAPService).getName());
    private Vector validTransports = null;
    private TypeMappingRegistry tmr;
    private boolean highFidelityRecording = true;
    private ServiceDesc serviceDescription = new ServiceDesc();
    private AxisEngine engine;
    static /* synthetic */ Class class$org$apache$axis$handlers$soap$SOAPService;

    public SOAPService() {
        this.initHashtable(true);
        this.initTypeMappingRegistry();
    }

    public SOAPService(Handler reqHandler, Handler pivHandler, Handler respHandler) {
        this();
        this.init(reqHandler, new SOAPRequestHandler(), pivHandler, null, respHandler);
    }

    private void initTypeMappingRegistry() {
        this.tmr = new TypeMappingRegistryImpl();
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.tmr;
    }

    public void setTypeMappingRegistry(TypeMappingRegistry map) {
        this.tmr = map;
    }

    public SOAPService(Handler serviceHandler) {
        this.init(null, new SOAPRequestHandler(), serviceHandler, null, null);
        this.initTypeMappingRegistry();
    }

    public void setEngine(AxisEngine engine) {
        this.engine = engine;
        if (engine != null) {
            this.tmr.delegate(engine.getTypeMappingRegistry());
        }
    }

    public boolean availableFromTransport(String transportName) {
        if (this.validTransports != null) {
            int i = 0;
            while (i < this.validTransports.size()) {
                if (((String)this.validTransports.elementAt(i)).equals(transportName)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    public Style getStyle() {
        return this.serviceDescription.getStyle();
    }

    public void setStyle(Style style) {
        this.serviceDescription.setStyle(style);
    }

    public ServiceDesc getServiceDescription() {
        return this.serviceDescription;
    }

    public synchronized ServiceDesc getInitializedServiceDesc(MessageContext msgContext) throws AxisFault {
        String clsName;
        if (this.serviceDescription.getImplClass() == null && (clsName = (String)this.getOption("className")) != null) {
            ClassLoader cl = null;
            cl = msgContext == null ? Thread.currentThread().getContextClassLoader() : msgContext.getClassLoader();
            if (this.engine != null) {
                ClassCache cache = this.engine.getClassCache();
                JavaClass jc = null;
                try {
                    jc = cache.lookup(clsName, cl);
                    this.serviceDescription.setImplClass(jc.getJavaClass());
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
                    throw new AxisFault(JavaUtils.getMessage("noClassForService00", clsName), e);
                }
            }
            try {
                Class cls = ClassUtils.forName(clsName, true, cl);
                this.serviceDescription.setImplClass(cls);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
                throw new AxisFault(JavaUtils.getMessage("noClassForService00", clsName), e);
            }
            TypeMapping tm = msgContext == null ? DefaultTypeMappingImpl.getSingleton() : msgContext.getTypeMapping();
            this.serviceDescription.setTypeMapping(tm);
        }
        return this.serviceDescription;
    }

    public void setServiceDescription(ServiceDesc serviceDescription) {
        if (serviceDescription == null) {
            return;
        }
        this.serviceDescription = serviceDescription;
    }

    public void setPropertyParent(Hashtable parent) {
        if (this.options == null) {
            this.options = new LockableHashtable();
        }
        ((LockableHashtable)this.options).setParent(parent);
    }

    public void generateWSDL(MessageContext msgContext) throws AxisFault {
        if (this.serviceDescription == null || this.serviceDescription.getWSDLFile() == null) {
            super.generateWSDL(msgContext);
            return;
        }
        try {
            Document doc = XMLUtils.newDocument(new FileInputStream(this.serviceDescription.getWSDLFile()));
            msgContext.setProperty("WSDL", doc);
        }
        catch (Exception e) {
            throw AxisFault.makeFault(e);
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public void enableTransport(String transportName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("enableTransport00", "" + this, transportName));
        }
        if (this.validTransports == null) {
            this.validTransports = new Vector();
        }
        this.validTransports.addElement(transportName);
    }

    public void disableTransport(String transportName) {
        if (this.validTransports != null) {
            this.validTransports.removeElement(transportName);
        }
    }

    public boolean needsHighFidelityRecording() {
        return this.highFidelityRecording;
    }

    public void setHighFidelityRecording(boolean highFidelityRecording) {
        this.highFidelityRecording = highFidelityRecording;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SOAPRequestHandler
    extends BasicHandler {
        public void invoke(MessageContext msgContext) throws AxisFault {
            if (BasicHandler.log.isDebugEnabled()) {
                BasicHandler.log.debug((Object)JavaUtils.getMessage("semanticCheck00"));
            }
            ArrayList actors = msgContext.getAxisEngine().getActorURIs();
            SOAPEnvelope env = msgContext.getRequestMessage().getSOAPEnvelope();
            Vector headers = env.getHeadersByActor(actors);
            Vector<SOAPHeaderElement> misunderstoodHeaders = null;
            Enumeration enumeration = headers.elements();
            while (enumeration.hasMoreElements()) {
                SOAPHeaderElement header = (SOAPHeaderElement)enumeration.nextElement();
                if (!header.getMustUnderstand() || header.isProcessed()) continue;
                if (misunderstoodHeaders == null) {
                    misunderstoodHeaders = new Vector<SOAPHeaderElement>();
                }
                misunderstoodHeaders.addElement(header);
            }
            boolean doMisunderstoodHeaders = true;
            if (misunderstoodHeaders != null) {
                if (doMisunderstoodHeaders) {
                    Message respMsg = msgContext.getResponseMessage();
                    if (respMsg == null) {
                        respMsg = new Message(new SOAPEnvelope());
                        msgContext.setResponseMessage(respMsg);
                    }
                    env = respMsg.getSOAPEnvelope();
                    enumeration = misunderstoodHeaders.elements();
                    while (enumeration.hasMoreElements()) {
                        SOAPHeaderElement badHeader = (SOAPHeaderElement)enumeration.nextElement();
                        QName badQName = new QName(badHeader.getNamespaceURI(), badHeader.getName());
                        SOAPHeaderElement newHeader = new SOAPHeaderElement("http://www.w3.org/2001/06/soap-faults", "Misunderstood");
                        newHeader.addAttribute(null, "qname", badQName);
                        env.addHeader(newHeader);
                    }
                }
                throw new AxisFault(Constants.FAULT_MUSTUNDERSTAND, JavaUtils.getMessage("noUnderstand00"), null, null);
            }
        }
    }
}

