/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.enum.Style;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.RPCHandler;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.message.SOAPFaultBuilder;
import org.apache.axis.message.SOAPHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BodyBuilder
extends SOAPHandler {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$message$BodyBuilder == null ? (class$org$apache$axis$message$BodyBuilder = BodyBuilder.class$("org.apache.axis.message.BodyBuilder")) : class$org$apache$axis$message$BodyBuilder).getName());
    private SOAPBodyElement element;
    boolean gotRPCElement = false;
    private SOAPEnvelope envelope;
    static /* synthetic */ Class class$org$apache$axis$message$BodyBuilder;

    BodyBuilder(SOAPEnvelope envelope) {
        this.envelope = envelope;
    }

    public void startElement(String namespace, String localName, String qName, Attributes attributes, DeserializationContext context) throws SAXException {
        super.startElement(namespace, localName, qName, attributes, context);
        if (!context.isDoneParsing()) {
            this.envelope.setBody((SOAPBody)this.myElement);
        }
    }

    public MessageElement makeNewElement(String namespace, String localName, String qName, Attributes attributes, DeserializationContext context) {
        return new SOAPBody(namespace, localName, qName, attributes, context, context.getMessageContext().getSOAPConstants());
    }

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: BodyBuilder::onStartChild()");
        }
        QName qname = new QName(namespace, localName);
        SOAPHandler handler = null;
        boolean isRoot = true;
        String root = attributes.getValue("http://schemas.xmlsoap.org/soap/encoding/", "root");
        if (root != null && root.equals("0")) {
            isRoot = false;
        }
        MessageContext msgContext = context.getMessageContext();
        OperationDesc[] operations = null;
        try {
            operations = msgContext.getPossibleOperationsByQName(qname);
        }
        catch (AxisFault e) {
            throw new SAXException(e);
        }
        if (localName.equals("Fault") && namespace.equals(msgContext.getSOAPConstants().getEnvelopeURI())) {
            this.element = new SOAPFault(namespace, localName, prefix, attributes, context);
            handler = new SOAPFaultBuilder((SOAPFault)this.element, context);
        } else if (!this.gotRPCElement && isRoot && (operations == null || operations[0].getStyle() != Style.MESSAGE)) {
            this.gotRPCElement = true;
            try {
                this.element = new RPCElement(namespace, localName, prefix, attributes, context, operations);
            }
            catch (AxisFault e) {
                throw new SAXException(e);
            }
            if (!(msgContext.isHighFidelity() || operations != null && operations.length != 1)) {
                ((RPCElement)this.element).setNeedDeser(false);
                handler = new RPCHandler((RPCElement)this.element, false);
                if (operations != null) {
                    ((RPCHandler)handler).setOperation(operations[0]);
                    msgContext.setOperation(operations[0]);
                }
            }
        }
        if (this.element == null) {
            this.element = new SOAPBodyElement(namespace, localName, prefix, attributes, context);
            if (this.element.getFixupDeserializer() != null) {
                handler = (SOAPHandler)((Object)this.element.getFixupDeserializer());
            }
        }
        if (handler == null) {
            handler = new SOAPHandler();
        }
        handler.myElement = this.element;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: BodyBuilder::onStartChild()");
        }
        return handler;
    }

    public void onEndChild(String namespace, String localName, DeserializationContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: BodyBuilder::onEndChild()");
        }
        if (this.element != null) {
            this.envelope.addBodyElement(this.element);
            this.element = null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: BodyBuilder::onEndChild()");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

