/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.enum.Style;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.EnvelopeHandler;
import org.apache.axis.message.RPCHandler;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RPCElement
extends SOAPBodyElement {
    protected Vector params = new Vector();
    protected boolean needDeser = false;
    protected boolean elementIsFirstParam = false;
    OperationDesc[] operations = null;

    public RPCElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context, OperationDesc[] operations) throws AxisFault {
        super(namespace, localName, prefix, attributes, context);
        SOAPService service;
        this.encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        this.needDeser = true;
        MessageContext msgContext = context.getMessageContext();
        if (operations == null && (service = msgContext.getService()) != null) {
            ServiceDesc serviceDesc = service.getInitializedServiceDesc(msgContext);
            String lc = Utils.xmlNameToJava(this.name);
            if (serviceDesc == null) {
                AxisFault.makeFault(new ClassNotFoundException(JavaUtils.getMessage("noClassForService00", lc)));
            }
            operations = serviceDesc.getOperationsByName(lc);
        }
        if (operations != null && operations.length > 0) {
            this.elementIsFirstParam = operations[0].getStyle() == Style.DOCUMENT;
        }
        this.operations = operations;
    }

    public RPCElement(String namespace, String methodName, Object[] args) {
        this.setNamespaceURI(namespace);
        this.name = methodName;
        this.encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        int i = 0;
        while (args != null && i < args.length) {
            if (args[i] instanceof RPCParam) {
                this.addParam((RPCParam)args[i]);
            } else {
                String name = null;
                if (name == null) {
                    name = "arg" + i;
                }
                this.addParam(new RPCParam(name, args[i]));
            }
            ++i;
        }
    }

    public RPCElement(String methodName) {
        this.encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        this.name = methodName;
    }

    public String getMethodName() {
        return this.name;
    }

    public void setNeedDeser(boolean needDeser) {
        this.needDeser = needDeser;
    }

    public void deserialize() throws SAXException {
        this.needDeser = false;
        MessageContext msgContext = this.context.getMessageContext();
        Message msg = msgContext.getCurrentMessage();
        boolean isResponse = msg != null && "response".equals(msg.getMessageType());
        RPCHandler rpcHandler = new RPCHandler(this, isResponse);
        if (this.operations != null && !msgContext.isClient()) {
            int numParams = this.getChildren() == null ? 0 : this.getChildren().size();
            SAXException savedException = null;
            int i = 0;
            while (i < this.operations.length) {
                OperationDesc operation = this.operations[i];
                if (operation.getNumInParams() >= numParams || this.elementIsFirstParam) {
                    rpcHandler.setOperation(operation);
                    try {
                        if (this.elementIsFirstParam && operation.getNumInParams() > 0) {
                            this.context.pushElementHandler(rpcHandler);
                            this.context.setCurElement(null);
                        } else {
                            this.context.pushElementHandler(new EnvelopeHandler(rpcHandler));
                            this.context.setCurElement(this);
                        }
                        this.publishToHandler((ContentHandler)((Object)this.context));
                        msgContext.setOperation(operation);
                        return;
                    }
                    catch (SAXException e) {
                        savedException = e;
                        this.params = new Vector();
                    }
                }
                ++i;
            }
            if (savedException != null) {
                throw savedException;
            }
            throw new SAXException(JavaUtils.getMessage("noSuchOperation", this.name));
        }
        if (this.operations != null) {
            rpcHandler.setOperation(this.operations[0]);
        }
        if (this.elementIsFirstParam) {
            this.context.pushElementHandler(rpcHandler);
            this.context.setCurElement(null);
        } else {
            this.context.pushElementHandler(new EnvelopeHandler(rpcHandler));
            this.context.setCurElement(this);
        }
        this.publishToHandler((ContentHandler)((Object)this.context));
    }

    public RPCParam getParam(String name) throws SAXException {
        if (this.needDeser) {
            this.deserialize();
        }
        int i = 0;
        while (i < this.params.size()) {
            RPCParam param = (RPCParam)this.params.elementAt(i);
            if (param.getName().equals(name)) {
                return param;
            }
            ++i;
        }
        return null;
    }

    public Vector getParams() throws SAXException {
        if (this.needDeser) {
            this.deserialize();
        }
        return this.params;
    }

    public void addParam(RPCParam param) {
        param.setRPCCall(this);
        this.params.addElement(param);
    }

    protected void outputImpl(SerializationContext context) throws Exception {
        boolean isRPC;
        MessageContext msgContext = context.getMessageContext();
        boolean bl = isRPC = msgContext == null || msgContext.getOperationStyle() == Style.RPC || msgContext.getOperationStyle() == Style.WRAPPED;
        if (isRPC) {
            if (this.encodingStyle.equals("")) {
                context.registerPrefixForURI("", this.getNamespaceURI());
            }
            context.startElement(new QName(this.namespaceURI, this.name), this.attributes);
        }
        int i = 0;
        while (i < this.params.size()) {
            RPCParam param = (RPCParam)this.params.elementAt(i);
            if (!isRPC && this.encodingStyle.equals("")) {
                context.registerPrefixForURI("", param.getQName().getNamespaceURI());
            }
            param.serialize(context);
            ++i;
        }
        if (isRPC) {
            context.endElement();
        }
    }
}

