/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.encoding.FieldTarget;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RPCHandler
extends SOAPHandler {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$message$RPCHandler == null ? (class$org$apache$axis$message$RPCHandler = RPCHandler.class$("org.apache.axis.message.RPCHandler")) : class$org$apache$axis$message$RPCHandler).getName());
    private RPCElement rpcElem;
    private RPCParam currentParam;
    private boolean isResponse;
    private OperationDesc operation;
    static /* synthetic */ Class class$org$apache$axis$message$RPCHandler;

    public RPCHandler(RPCElement rpcElem, boolean isResponse) throws SAXException {
        this.rpcElem = rpcElem;
        this.isResponse = isResponse;
    }

    public void setOperation(OperationDesc myOperation) {
        this.operation = myOperation;
    }

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: RPCHandler.onStartChild()");
        }
        if (!context.isDoneParsing()) {
            context.pushNewElement(new MessageElement(namespace, localName, prefix + ":" + localName, attributes, context));
        }
        Vector params = this.rpcElem.getParams();
        this.currentParam = new RPCParam(namespace, localName, null);
        this.rpcElem.addParam(this.currentParam);
        MessageElement curEl = context.getCurElement();
        QName type = null;
        QName qname = new QName(namespace, localName);
        ParameterDesc paramDesc = null;
        if (curEl.getHref() != null) {
            MessageElement ref = context.getElementByID(curEl.getHref());
            if (ref != null) {
                type = context.getTypeFromAttributes(ref.getNamespaceURI(), ref.getName(), ref.getAttributes());
            }
        } else {
            type = curEl.getType();
            if (type == null) {
                type = context.getTypeFromAttributes(namespace, localName, attributes);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("typeFromAttr00", "" + type));
        }
        if (this.operation != null) {
            paramDesc = this.isResponse ? this.operation.getOutputParamByQName(qname) : this.operation.getInputParamByQName(qname);
            if (paramDesc == null) {
                paramDesc = this.operation.getParameter(params.size() - 1);
            }
            if (paramDesc != null) {
                Class xsiClass;
                this.currentParam.setParamDesc(paramDesc);
                if (type == null) {
                    type = paramDesc.getTypeQName();
                } else if (paramDesc.getJavaType() != null && !JavaUtils.isConvertable(xsiClass = context.getTypeMapping().getClassForQName(type), paramDesc.getJavaType())) {
                    throw new SAXException("Bad types (" + xsiClass + " -> " + paramDesc.getJavaType() + ")");
                }
            }
        }
        if (JavaUtils.isTrueExplicitly(attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil"))) {
            return new DeserializerImpl();
        }
        Deserializer dser = null;
        if (type == null && namespace != null && !namespace.equals("")) {
            dser = context.getDeserializerForType(qname);
        }
        if (dser == null) {
            dser = type != null ? context.getDeserializerForType(type) : new DeserializerImpl();
        }
        if (dser == null) {
            throw new SAXException(JavaUtils.getMessage("noDeser01", localName, "" + type));
        }
        dser.setDefaultType(type);
        dser.registerValueTarget(new FieldTarget((Object)this.currentParam, RPCParam.getValueField()));
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: RPCHandler.onStartChild()");
        }
        return (SOAPHandler)((Object)dser);
    }

    public void endElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("setProp00", "MessageContext", "RPCHandler.endElement()."));
        }
        context.getMessageContext().setProperty("RPC", this.rpcElem);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

