/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.util.Enumeration;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public class SOAPBody
extends MessageElement
implements javax.xml.soap.SOAPBody {
    private static Log log = LogFactory.getLog((String)(class$org$apache$axis$message$SOAPBody == null ? (class$org$apache$axis$message$SOAPBody = SOAPBody.class$("org.apache.axis.message.SOAPBody")) : class$org$apache$axis$message$SOAPBody).getName());
    private Vector bodyElements = new Vector();
    private SOAPConstants soapConstants;
    static /* synthetic */ Class class$org$apache$axis$message$SOAPBody;

    SOAPBody(SOAPEnvelope env, SOAPConstants soapConsts) {
        this.soapConstants = soapConsts;
        try {
            this.setParentElement(env);
        }
        catch (SOAPException ex) {
            log.fatal((Object)JavaUtils.getMessage("exception00"), (Throwable)ex);
        }
    }

    public SOAPBody(String namespace, String localPart, String qName, Attributes attributes, DeserializationContext context, SOAPConstants soapConsts) {
        super(namespace, localPart, qName, attributes, context);
        this.soapConstants = soapConsts;
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
        if (parent == null) {
            throw new IllegalArgumentException(JavaUtils.getMessage("nullParent00"));
        }
        try {
            super.setParentElement((SOAPEnvelope)parent);
        }
        catch (Throwable t) {
            throw new SOAPException(t);
        }
    }

    public void detachNode() {
        ((SOAPEnvelope)this.parent).removeBody();
        super.detachNode();
    }

    protected void outputImpl(SerializationContext context) throws Exception {
        boolean oldPretty = context.getPretty();
        context.setPretty(true);
        if (this.bodyElements.isEmpty()) {
            // empty if block
        }
        context.startElement(new QName(this.soapConstants.getEnvelopeURI(), "Body"), null);
        Enumeration enumeration = this.bodyElements.elements();
        while (enumeration.hasMoreElements()) {
            SOAPBodyElement body = (SOAPBodyElement)enumeration.nextElement();
            body.output(context);
        }
        context.outputMultiRefs();
        context.endElement();
        context.setPretty(oldPretty);
    }

    Vector getBodyElements() throws AxisFault {
        return this.bodyElements;
    }

    SOAPBodyElement getFirstBody() throws AxisFault {
        if (this.bodyElements.isEmpty()) {
            return null;
        }
        return (SOAPBodyElement)this.bodyElements.elementAt(0);
    }

    void addBodyElement(SOAPBodyElement element) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("addBody00"));
        }
        this.bodyElements.addElement(element);
        try {
            element.setParentElement(this);
        }
        catch (SOAPException ex) {
            log.fatal((Object)JavaUtils.getMessage("exception00"), (Throwable)ex);
        }
    }

    void removeBodyElement(SOAPBodyElement element) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("removeBody00"));
        }
        this.bodyElements.removeElement(element);
    }

    void clearBody() {
        if (!this.bodyElements.isEmpty()) {
            this.bodyElements.removeAllElements();
        }
    }

    SOAPBodyElement getBodyByName(String namespace, String localPart) throws AxisFault {
        return (SOAPBodyElement)this.findElement(this.bodyElements, namespace, localPart);
    }

    protected MessageElement findElement(Vector vec, String namespace, String localPart) {
        if (vec.isEmpty()) {
            return null;
        }
        Enumeration e = vec.elements();
        while (e.hasMoreElements()) {
            MessageElement element = (MessageElement)e.nextElement();
            if (!element.getNamespaceURI().equals(namespace) || !element.getName().equals(localPart)) continue;
            return element;
        }
        return null;
    }

    public javax.xml.soap.SOAPBodyElement addBodyElement(Name name) throws SOAPException {
        SOAPBodyElement bodyElement = new SOAPBodyElement(name);
        this.addBodyElement(bodyElement);
        return bodyElement;
    }

    public javax.xml.soap.SOAPFault addFault() throws SOAPException {
        SOAPFault fault = new SOAPFault(new AxisFault());
        this.addBodyElement(fault);
        return fault;
    }

    public javax.xml.soap.SOAPFault getFault() {
        try {
            return (javax.xml.soap.SOAPFault)this.getBodyByName("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
        }
        catch (AxisFault af) {
            log.fatal((Object)JavaUtils.getMessage("exception00"), (Throwable)af);
            return null;
        }
    }

    public boolean hasFault() {
        try {
            if (this.getBodyByName("http://schemas.xmlsoap.org/soap/envelope/", "Fault") != null) {
                return true;
            }
        }
        catch (AxisFault af) {
            log.fatal((Object)JavaUtils.getMessage("exception00"), (Throwable)af);
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

