/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public class SOAPHeader
extends MessageElement
implements javax.xml.soap.SOAPHeader {
    private static Log log = LogFactory.getLog((String)(class$org$apache$axis$message$SOAPHeader == null ? (class$org$apache$axis$message$SOAPHeader = SOAPHeader.class$("org.apache.axis.message.SOAPHeader")) : class$org$apache$axis$message$SOAPHeader).getName());
    private Vector headers = new Vector();
    private SOAPConstants soapConstants;
    static /* synthetic */ Class class$org$apache$axis$message$SOAPHeader;

    SOAPHeader(SOAPEnvelope env, SOAPConstants soapConsts) {
        this.soapConstants = soapConsts;
        try {
            this.setParentElement(env);
        }
        catch (SOAPException ex) {
            log.fatal((Object)JavaUtils.getMessage("exception00"), (Throwable)ex);
        }
    }

    public SOAPHeader(String namespace, String localPart, String qName, Attributes attributes, DeserializationContext context, SOAPConstants soapConsts) {
        super(namespace, localPart, qName, attributes, context);
        this.soapConstants = soapConsts;
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
        if (parent == null) {
            throw new IllegalArgumentException(JavaUtils.getMessage("nullParent00"));
        }
        try {
            super.setParentElement((SOAPEnvelope)parent);
        }
        catch (Throwable t) {
            throw new SOAPException(t);
        }
    }

    public void detachNode() {
        ((SOAPEnvelope)this.parent).removeHeaders();
        super.detachNode();
    }

    public javax.xml.soap.SOAPHeaderElement addHeaderElement(Name name) throws SOAPException {
        SOAPHeaderElement headerElement = new SOAPHeaderElement(name);
        this.addHeader(headerElement);
        return headerElement;
    }

    private Vector findHeaderElements(String actor) {
        Vector<SOAPHeaderElement> results = new Vector<SOAPHeaderElement>();
        Iterator i = ((AbstractList)this.headers).iterator();
        while (i.hasNext()) {
            SOAPHeaderElement header = (SOAPHeaderElement)i.next();
            String headerActor = header.getActor();
            if (!"http://schemas.xmlsoap.org/soap/actor/next".equals(headerActor) && actor != headerActor && (actor == null || !actor.equals(headerActor))) continue;
            results.add(header);
        }
        return results;
    }

    public Iterator examineHeaderElements(String actor) {
        return ((AbstractList)this.findHeaderElements(actor)).iterator();
    }

    public Iterator extractHeaderElements(String actor) {
        Vector results = this.findHeaderElements(actor);
        Iterator iterator = ((AbstractList)results).iterator();
        while (iterator.hasNext()) {
            ((SOAPHeaderElement)iterator.next()).detachNode();
        }
        return ((AbstractList)results).iterator();
    }

    Vector getHeaders() {
        return this.headers;
    }

    Vector getHeadersByActor(ArrayList actors) {
        Vector<SOAPHeaderElement> results = new Vector<SOAPHeaderElement>();
        Iterator i = ((AbstractList)this.headers).iterator();
        while (i.hasNext()) {
            SOAPHeaderElement header = (SOAPHeaderElement)i.next();
            if (!"http://schemas.xmlsoap.org/soap/actor/next".equals(header.getActor()) && (actors == null || !actors.contains(header.getActor()))) continue;
            results.add(header);
        }
        return results;
    }

    void addHeader(SOAPHeaderElement header) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("addHeader00"));
        }
        this.headers.addElement(header);
        try {
            header.setParentElement(this);
        }
        catch (SOAPException ex) {
            log.fatal((Object)JavaUtils.getMessage("exception00"), (Throwable)ex);
        }
    }

    void removeHeader(SOAPHeaderElement header) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("removeHeader00"));
        }
        this.headers.removeElement(header);
    }

    SOAPHeaderElement getHeaderByName(String namespace, String localPart, boolean accessAllHeaders) {
        MessageContext mc;
        SOAPHeaderElement header = (SOAPHeaderElement)this.findElement(this.headers, namespace, localPart);
        if (!accessAllHeaders && (mc = MessageContext.getCurrentContext()) != null && header != null) {
            String actor = header.getActor();
            ArrayList actors = mc.getAxisEngine().getActorURIs();
            if (!(actor == null || "http://schemas.xmlsoap.org/soap/actor/next".equals(actor) || actors != null && actors.contains(actor))) {
                header = null;
            }
        }
        return header;
    }

    private MessageElement findElement(Vector vec, String namespace, String localPart) {
        if (vec.isEmpty()) {
            return null;
        }
        Enumeration e = vec.elements();
        while (e.hasMoreElements()) {
            MessageElement element = (MessageElement)e.nextElement();
            if (!element.getNamespaceURI().equals(namespace) || !element.getName().equals(localPart)) continue;
            return element;
        }
        return null;
    }

    Enumeration getHeadersByName(String namespace, String localPart, boolean accessAllHeaders) {
        ArrayList actors = null;
        boolean firstTime = false;
        Vector<SOAPHeaderElement> v = new Vector<SOAPHeaderElement>();
        Enumeration e = this.headers.elements();
        while (e.hasMoreElements()) {
            SOAPHeaderElement header = (SOAPHeaderElement)e.nextElement();
            if (!header.getNamespaceURI().equals(namespace) || !header.getName().equals(localPart)) continue;
            if (!accessAllHeaders) {
                String actor;
                if (firstTime) {
                    MessageContext mc = MessageContext.getCurrentContext();
                    if (mc != null) {
                        actors = mc.getAxisEngine().getActorURIs();
                    }
                    firstTime = false;
                }
                if ((actor = header.getActor()) != null && !"http://schemas.xmlsoap.org/soap/actor/next".equals(actor) && (actors == null || !actors.contains(actor))) continue;
            }
            v.addElement(header);
        }
        return v.elements();
    }

    protected void outputImpl(SerializationContext context) throws Exception {
        boolean oldPretty = context.getPretty();
        context.setPretty(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.headers.size() + " " + JavaUtils.getMessage("headers00")));
        }
        if (!this.headers.isEmpty()) {
            context.startElement(new QName(this.soapConstants.getEnvelopeURI(), "Header"), null);
            Enumeration enumeration = this.headers.elements();
            while (enumeration.hasMoreElements()) {
                ((SOAPHeaderElement)enumeration.nextElement()).output(context);
            }
            context.endElement();
        }
        context.setPretty(oldPretty);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

