/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.providers.java;

import java.lang.reflect.Method;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.providers.java.RPCProvider;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EJBProvider
extends RPCProvider {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$providers$java$EJBProvider == null ? (class$org$apache$axis$providers$java$EJBProvider = EJBProvider.class$("org.apache.axis.providers.java.EJBProvider")) : class$org$apache$axis$providers$java$EJBProvider).getName());
    public static final String OPTION_BEANNAME = "beanJndiName";
    public static final String OPTION_HOMEINTERFACENAME = "homeInterfaceName";
    public static final String OPTION_REMOTEINTERFACENAME = "remoteInterfaceName";
    public static final String jndiContextClass = "jndiContextClass";
    public static final String jndiURL = "jndiURL";
    public static final String jndiUsername = "jndiUser";
    public static final String jndiPassword = "jndiPassword";
    private static final Class[] empty_class_array = new Class[0];
    private static final Object[] empty_object_array = new Object[0];
    private static InitialContext cached_context = null;
    static /* synthetic */ Class class$org$apache$axis$providers$java$EJBProvider;

    protected Object makeNewServiceObject(MessageContext msgContext, String clsName) throws Exception {
        Object ejbHome = this.getEJBHome(msgContext, clsName);
        String homeName = this.getStrOption(OPTION_HOMEINTERFACENAME, msgContext.getService());
        if (homeName == null) {
            throw new AxisFault(JavaUtils.getMessage("noOption00", OPTION_HOMEINTERFACENAME, msgContext.getTargetService()));
        }
        Class homeClass = ClassUtils.forName(homeName, true, msgContext.getClassLoader());
        Object ehome = PortableRemoteObject.narrow((Object)ejbHome, (Class)homeClass);
        Method createMethod = homeClass.getMethod("create", empty_class_array);
        Object result = createMethod.invoke(ehome, empty_object_array);
        return result;
    }

    protected String getServiceClassNameOptionName() {
        return OPTION_BEANNAME;
    }

    protected String getStrOption(String optionName, Handler service) {
        String value = null;
        if (service != null) {
            value = (String)service.getOption(optionName);
        }
        if (value == null) {
            value = (String)this.getOption(optionName);
        }
        return value;
    }

    protected Class getServiceClass(MessageContext msgContext, String beanJndiName) throws Exception {
        SOAPService serviceHandler = msgContext.getService();
        Class interfaceClass = null;
        String remoteName = this.getStrOption(OPTION_REMOTEINTERFACENAME, serviceHandler);
        if (remoteName != null) {
            interfaceClass = ClassUtils.forName(remoteName, true, msgContext.getClassLoader());
        } else {
            Object ejbHome = this.getEJBHome(msgContext, beanJndiName);
            String homeName = this.getStrOption(OPTION_HOMEINTERFACENAME, serviceHandler);
            if (homeName == null) {
                throw new AxisFault(JavaUtils.getMessage("noOption00", OPTION_HOMEINTERFACENAME, msgContext.getTargetService()));
            }
            Class homeClass = ClassUtils.forName(homeName, true, msgContext.getClassLoader());
            Object ehome = PortableRemoteObject.narrow((Object)ejbHome, (Class)homeClass);
            Method getEJBMetaData = homeClass.getMethod("getEJBMetaData", empty_class_array);
            Object metaData = getEJBMetaData.invoke(ehome, empty_object_array);
            Method getRemoteInterfaceClass = metaData.getClass().getMethod("getRemoteInterfaceClass", empty_class_array);
            interfaceClass = (Class)getRemoteInterfaceClass.invoke(metaData, empty_object_array);
        }
        return interfaceClass;
    }

    private Object getEJBHome(MessageContext msgContext, String beanJndiName) throws AxisFault {
        Object ejbHome = null;
        try {
            InitialContext context;
            String contextUrl;
            String factoryClass;
            String password;
            SOAPService serviceHandler = msgContext.getService();
            Properties properties = null;
            String username = this.getStrOption(jndiUsername, serviceHandler);
            if (username == null) {
                username = msgContext.getUsername();
            }
            if (username != null) {
                if (properties == null) {
                    properties = new Properties();
                }
                properties.setProperty("java.naming.security.principal", username);
            }
            if ((password = this.getStrOption(jndiPassword, serviceHandler)) == null) {
                password = msgContext.getPassword();
            }
            if (password != null) {
                if (properties == null) {
                    properties = new Properties();
                }
                properties.setProperty("java.naming.security.credentials", password);
            }
            if ((factoryClass = this.getStrOption(jndiContextClass, serviceHandler)) != null) {
                if (properties == null) {
                    properties = new Properties();
                }
                properties.setProperty("java.naming.factory.initial", factoryClass);
            }
            if ((contextUrl = this.getStrOption(jndiURL, serviceHandler)) != null) {
                if (properties == null) {
                    properties = new Properties();
                }
                properties.setProperty("java.naming.provider.url", contextUrl);
            }
            if ((context = this.getContext(properties)) == null) {
                throw new AxisFault(JavaUtils.getMessage("cannotCreateInitialContext00"));
            }
            ejbHome = this.getEJBHome(context, beanJndiName);
            if (ejbHome == null) {
                throw new AxisFault(JavaUtils.getMessage("cannotFindJNDIHome00", beanJndiName));
            }
        }
        catch (Exception exception) {
            log.info((Object)JavaUtils.getMessage("toAxisFault00"), (Throwable)exception);
            throw AxisFault.makeFault(exception);
        }
        return ejbHome;
    }

    protected InitialContext getCachedContext() throws NamingException {
        if (cached_context == null) {
            cached_context = new InitialContext();
        }
        return cached_context;
    }

    protected InitialContext getContext(Properties properties) throws AxisFault, NamingException {
        return properties == null ? this.getCachedContext() : new InitialContext(properties);
    }

    protected Object getEJBHome(InitialContext context, String beanJndiName) throws AxisFault, NamingException {
        return context.lookup(beanJndiName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

