/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.providers.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import javax.xml.rpc.holders.IntHolder;
import javax.xml.rpc.server.ServiceLifecycle;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisServiceConfig;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.enum.Scope;
import org.apache.axis.enum.Style;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.providers.BasicProvider;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.cache.ClassCache;
import org.apache.axis.utils.cache.JavaClass;
import org.apache.axis.wsdl.fromJava.Emitter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public abstract class JavaProvider
extends BasicProvider {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$providers$java$JavaProvider == null ? (class$org$apache$axis$providers$java$JavaProvider = JavaProvider.class$("org.apache.axis.providers.java.JavaProvider")) : class$org$apache$axis$providers$java$JavaProvider).getName());
    public static final String OPTION_CLASSNAME = "className";
    public static final String OPTION_ALLOWEDMETHODS = "allowedMethods";
    public static final String OPTION_IS_STATIC = "isStatic";
    public static final String OPTION_CLASSPATH = "classPath";
    public static final String OPTION_WSDL_PORTTYPE = "wsdlPortType";
    public static final String OPTION_WSDL_SERVICEELEMENT = "wsdlServiceElement";
    public static final String OPTION_WSDL_SERVICEPORT = "wsdlServicePort";
    public static final String OPTION_WSDL_TARGETNAMESPACE = "wsdlTargetNamespace";
    public static final String OPTION_SCOPE = "scope";
    static /* synthetic */ Class class$org$apache$axis$providers$java$JavaProvider;

    public Object getServiceObject(MessageContext msgContext, Handler service, String clsName, IntHolder scopeHolder) throws Exception {
        String serviceName = msgContext.getService().getName();
        Scope scope = Scope.getScope((String)service.getOption(OPTION_SCOPE), Scope.DEFAULT);
        scopeHolder.value = scope.getValue();
        if (scope == Scope.REQUEST) {
            return this.getNewServiceObject(msgContext, clsName);
        }
        if (scope == Scope.SESSION) {
            if (serviceName == null) {
                serviceName = msgContext.getService().toString();
            }
            if (msgContext.getSession() != null) {
                JavaProvider javaProvider = this;
                synchronized (javaProvider) {
                    Object obj = msgContext.getSession().get(serviceName);
                    if (obj == null) {
                        obj = this.getNewServiceObject(msgContext, clsName);
                        msgContext.getSession().set(serviceName, obj);
                    }
                    Object object = obj;
                    return object;
                }
            }
            scopeHolder.value = Scope.DEFAULT.getValue();
            return this.getNewServiceObject(msgContext, clsName);
        }
        if (scope == Scope.APPLICATION) {
            AxisEngine engine = msgContext.getAxisEngine();
            if (engine.getApplicationSession() != null) {
                JavaProvider javaProvider = this;
                synchronized (javaProvider) {
                    Object obj = engine.getApplicationSession().get(serviceName);
                    if (obj == null) {
                        obj = this.getNewServiceObject(msgContext, clsName);
                        engine.getApplicationSession().set(serviceName, obj);
                    }
                    Object object = obj;
                    return object;
                }
            }
            scopeHolder.value = Scope.DEFAULT.getValue();
            return this.getNewServiceObject(msgContext, clsName);
        }
        return null;
    }

    private Object getNewServiceObject(MessageContext msgContext, String clsName) throws Exception {
        Object serviceObject = this.makeNewServiceObject(msgContext, clsName);
        if (serviceObject != null && serviceObject instanceof ServiceLifecycle) {
            ((ServiceLifecycle)serviceObject).init(null);
        }
        return serviceObject;
    }

    public abstract void processMessage(MessageContext var1, String var2, String var3, SOAPEnvelope var4, SOAPEnvelope var5, JavaClass var6, Object var7) throws Exception;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(MessageContext msgContext) throws AxisFault {
        block15: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Enter: JavaProvider::invoke (" + this + ")"));
            }
            String serviceName = msgContext.getTargetService();
            SOAPService service = msgContext.getService();
            String clsName = this.getServiceClassName(service);
            String allowedMethods = this.getAllowedMethods(service);
            if (clsName == null || clsName.equals("")) {
                throw new AxisFault("Server.NoClassForService", JavaUtils.getMessage("noOption00", this.getServiceClassNameOptionName(), serviceName), null, null);
            }
            if (allowedMethods == null || allowedMethods.equals("")) {
                throw new AxisFault("Server.NoMethodConfig", JavaUtils.getMessage("noOption00", OPTION_ALLOWEDMETHODS, serviceName), null, null);
            }
            if (allowedMethods.equals("*")) {
                allowedMethods = null;
            }
            try {
                AxisServiceConfig axisConfig;
                SOAPEnvelope resEnv;
                IntHolder scope = new IntHolder();
                Object obj = this.getServiceObject(msgContext, service, clsName, scope);
                JavaClass jc = JavaClass.find(obj.getClass());
                Message reqMsg = msgContext.getRequestMessage();
                SOAPEnvelope reqEnv = reqMsg.getSOAPEnvelope();
                Message resMsg = msgContext.getResponseMessage();
                SOAPEnvelope sOAPEnvelope = resEnv = resMsg == null ? new SOAPEnvelope(msgContext.getSOAPConstants()) : resMsg.getSOAPEnvelope();
                if (resMsg == null) {
                    resMsg = new Message(resEnv);
                    msgContext.setResponseMessage(resMsg);
                }
                if ((axisConfig = this.getConfiguration(obj)) != null) {
                    allowedMethods = axisConfig.getAllowedMethods();
                }
                try {
                    this.processMessage(msgContext, clsName, allowedMethods, reqEnv, resEnv, jc, obj);
                    Object var16_15 = null;
                    if (scope.value != Scope.REQUEST.getValue()) break block15;
                }
                catch (Throwable throwable) {
                    Object var16_16 = null;
                    if (scope.value == Scope.REQUEST.getValue() && obj instanceof ServiceLifecycle) {
                        ((ServiceLifecycle)obj).destroy();
                    }
                    throw throwable;
                }
                if (obj instanceof ServiceLifecycle) {
                    ((ServiceLifecycle)obj).destroy();
                }
            }
            catch (Exception exp) {
                log.debug((Object)JavaUtils.getMessage("toAxisFault00"), (Throwable)exp);
                throw AxisFault.makeFault(exp);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: JavaProvider::invoke (" + this + ")"));
        }
    }

    public void generateWSDL(MessageContext msgContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: JavaProvider::generateWSDL (" + this + ")"));
        }
        String serviceName = msgContext.getTargetService();
        SOAPService service = msgContext.getService();
        String allowedMethods = this.getAllowedMethods(service);
        if (allowedMethods == null || allowedMethods.equals("")) {
            throw new AxisFault("Server.NoMethodConfig", JavaUtils.getMessage("noOption00", this.getServiceClassNameOptionName(), serviceName), null, null);
        }
        if (allowedMethods.equals("*")) {
            allowedMethods = null;
        }
        try {
            String locationUrl;
            String url = msgContext.getStrProp(MessageContext.TRANS_URL);
            String interfaceNamespace = msgContext.getStrProp(MessageContext.WSDLGEN_INTFNAMESPACE);
            if (interfaceNamespace == null) {
                interfaceNamespace = url;
            }
            if ((locationUrl = msgContext.getStrProp(MessageContext.WSDLGEN_SERV_LOC_URL)) == null) {
                locationUrl = url;
            } else {
                try {
                    URL urlURL = new URL(url);
                    URL locationURL = new URL(locationUrl);
                    URL urlTemp = new URL(urlURL.getProtocol(), locationURL.getHost(), locationURL.getPort(), urlURL.getFile());
                    interfaceNamespace = interfaceNamespace + urlURL.getFile();
                    locationUrl = urlTemp.toString();
                }
                catch (Exception e) {
                    locationUrl = url;
                    interfaceNamespace = url;
                }
            }
            Class cls = this.getServiceClass(msgContext, this.getServiceClassName(service));
            AxisServiceConfig axisConfig = this.getConfiguration(cls);
            if (axisConfig != null) {
                allowedMethods = axisConfig.getAllowedMethods();
            }
            Emitter emitter = new Emitter();
            String alias = (String)service.getOption("alias");
            if (alias != null) {
                emitter.setServiceElementName(alias);
            }
            emitter.setMode(service.getStyle() == Style.RPC ? 0 : 1);
            emitter.setClsSmart(cls, url);
            emitter.setAllowedMethods(allowedMethods);
            String targetNamespace = (String)service.getOption(OPTION_WSDL_TARGETNAMESPACE);
            if (targetNamespace == null || targetNamespace.length() == 0) {
                targetNamespace = interfaceNamespace;
            }
            emitter.setIntfNamespace(targetNamespace);
            emitter.setLocationUrl(locationUrl);
            emitter.setServiceDesc(msgContext.getService().getInitializedServiceDesc(msgContext));
            emitter.setTypeMapping((TypeMapping)msgContext.getTypeMappingRegistry().getTypeMapping("http://schemas.xmlsoap.org/soap/encoding/"));
            emitter.setDefaultTypeMapping((TypeMapping)msgContext.getTypeMappingRegistry().getDefaultTypeMapping());
            String wsdlPortType = (String)service.getOption(OPTION_WSDL_PORTTYPE);
            String wsdlServiceElement = (String)service.getOption(OPTION_WSDL_SERVICEELEMENT);
            String wsdlServicePort = (String)service.getOption(OPTION_WSDL_SERVICEPORT);
            if (wsdlPortType != null && wsdlPortType.length() > 0) {
                emitter.setPortTypeName(wsdlPortType);
            }
            if (wsdlServiceElement != null && wsdlServiceElement.length() > 0) {
                emitter.setServiceElementName(wsdlServiceElement);
            }
            if (wsdlServicePort != null && wsdlServicePort.length() > 0) {
                emitter.setServicePortName(wsdlServicePort);
            }
            Document doc = emitter.emit(0);
            msgContext.setProperty("WSDL", doc);
        }
        catch (NoClassDefFoundError e) {
            log.info((Object)JavaUtils.getMessage("toAxisFault00"), (Throwable)e);
            throw new AxisFault(e.toString(), e);
        }
        catch (Exception e) {
            log.info((Object)JavaUtils.getMessage("toAxisFault00"), (Throwable)e);
            throw AxisFault.makeFault(e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: JavaProvider::generateWSDL (" + this + ")"));
        }
    }

    private String getAllowedMethods(Handler service) {
        String val = (String)service.getOption(OPTION_ALLOWEDMETHODS);
        if (val == null || val.length() == 0) {
            val = (String)service.getOption("methodName");
        }
        return val;
    }

    protected Object makeNewServiceObject(MessageContext msgContext, String clsName) throws Exception {
        ClassLoader cl = msgContext.getClassLoader();
        ClassCache cache = msgContext.getAxisEngine().getClassCache();
        JavaClass jc = cache.lookup(clsName, cl);
        return jc.getJavaClass().newInstance();
    }

    protected String getServiceClassName(Handler service) {
        return (String)service.getOption(this.getServiceClassNameOptionName());
    }

    protected String getServiceClassNameOptionName() {
        return OPTION_CLASSNAME;
    }

    protected Class getServiceClass(MessageContext msgContext, String clsName) throws Exception {
        ClassLoader cl = msgContext.getClassLoader();
        ClassCache cache = msgContext.getAxisEngine().getClassCache();
        JavaClass jc = cache.lookup(clsName, cl);
        return jc.getJavaClass();
    }

    public AxisServiceConfig getConfiguration(Object obj) {
        Class<?> cls = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        try {
            Method method = cls.getDeclaredMethod("getAxisServiceConfig", new Class[0]);
            if (method != null && Modifier.isStatic(method.getModifiers())) {
                return (AxisServiceConfig)method.invoke(null, null);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

