/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.server;

import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.apache.axis.AxisFault;
import org.apache.axis.server.AxisServer;
import org.apache.axis.server.DefaultAxisServerFactory;
import org.apache.axis.utils.JavaUtils;

public class JNDIAxisServerFactory
extends DefaultAxisServerFactory {
    public AxisServer getServer(Map environment) throws AxisFault {
        DefaultAxisServerFactory.log.debug((Object)"Enter: JNDIAxisServerFactory::getServer");
        InitialContext context = null;
        try {
            context = new InitialContext();
        }
        catch (NamingException e) {
            DefaultAxisServerFactory.log.warn((Object)JavaUtils.getMessage("jndiNotFound00"), (Throwable)e);
        }
        ServletContext servletContext = null;
        try {
            servletContext = (ServletContext)environment.get("servletContext");
        }
        catch (ClassCastException e) {
            DefaultAxisServerFactory.log.warn((Object)JavaUtils.getMessage("servletContextWrongClass00"), (Throwable)e);
        }
        AxisServer server = null;
        if (context != null && servletContext != null) {
            String name = servletContext.getRealPath("/WEB-INF/Server");
            try {
                server = (AxisServer)context.lookup(name);
            }
            catch (NamingException e) {
                server = super.getServer(environment);
                try {
                    context.bind(name, (Object)server);
                }
                catch (NamingException e1) {}
            }
        } else {
            server = super.getServer(environment);
        }
        DefaultAxisServerFactory.log.debug((Object)"Exit: JNDIAxisServerFactory::getServer");
        return server;
    }
}

