/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.configuration.ServletEngineConfigurationFactory;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.security.servlet.ServletSecurityProvider;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.AxisHttpSession;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.Admin;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class AxisServlet
extends HttpServlet {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$transport$http$AxisServlet == null ? (class$org$apache$axis$transport$http$AxisServlet = AxisServlet.class$("org.apache.axis.transport.http.AxisServlet")) : class$org$apache$axis$transport$http$AxisServlet).getName());
    private static Log tlog = LogFactory.getLog((String)"org.apache.axis.TIME");
    public static final String INIT_PROPERTY_TRANSPORT_NAME = "transport.name";
    public static final String INIT_PROPERTY_USE_SECURITY = "use-servlet-security";
    public static final String INIT_PROPERTY_ENABLE_LIST = "axis.enableListQuery";
    public static final String INIT_PROPERTY_JWS_CLASS_DIR = "axis.jws.servletClassDir";
    private static final String ATTR_AXIS_ENGINE = "AxisEngine";
    private String transportName;
    private AxisServer axisServer = null;
    private ServletSecurityProvider securityProvider = null;
    private static boolean isDebug = false;
    private boolean enableList = false;
    private String webInfPath = null;
    private String jwsClassDir = null;
    private String homeDir = null;
    static /* synthetic */ Class class$org$apache$axis$transport$http$AxisServlet;

    protected String getWebInfPath() {
        return this.webInfPath;
    }

    protected String getJWSClassDir() {
        return this.jwsClassDir;
    }

    protected String getHomeDir() {
        return this.homeDir;
    }

    public void init() {
        ServletContext context = this.getServletConfig().getServletContext();
        this.webInfPath = context.getRealPath("/WEB-INF");
        this.homeDir = context.getRealPath("/");
        isDebug = log.isDebugEnabled();
        if (isDebug) {
            log.debug((Object)"In servlet init");
        }
        this.transportName = this.getOption(context, INIT_PROPERTY_TRANSPORT_NAME, "http");
        if (JavaUtils.isTrueExplicitly(this.getOption(context, INIT_PROPERTY_USE_SECURITY, null))) {
            this.securityProvider = new ServletSecurityProvider();
        }
        this.enableList = JavaUtils.isTrueExplicitly(this.getOption(context, INIT_PROPERTY_ENABLE_LIST, null));
        this.jwsClassDir = this.getOption(context, INIT_PROPERTY_JWS_CLASS_DIR, null);
        this.jwsClassDir = this.jwsClassDir != null ? this.homeDir + this.jwsClassDir : this.getDefaultJWSClassDir();
    }

    public void destroy() {
        super.destroy();
        if (this.axisServer != null) {
            this.axisServer.cleanup();
        }
    }

    public AxisServer getEngine() throws AxisFault {
        if (this.axisServer == null) {
            this.axisServer = AxisServlet.getEngine(this);
        }
        return this.axisServer;
    }

    public static AxisServer getEngine(HttpServlet servlet) throws AxisFault {
        AxisServer engine = null;
        if (isDebug) {
            log.debug((Object)"Enter: getEngine()");
        }
        ServletContext context = servlet.getServletContext();
        HttpServlet httpServlet = servlet;
        synchronized (httpServlet) {
            engine = (AxisServer)context.getAttribute(ATTR_AXIS_ENGINE);
            if (engine == null) {
                Map environment = AxisServlet.getEngineEnvironment(servlet);
                engine = AxisServer.getServer(environment);
                context.setAttribute(ATTR_AXIS_ENGINE, (Object)engine);
            }
        }
        if (isDebug) {
            log.debug((Object)"Exit: getEngine()");
        }
        return engine;
    }

    private static Map getEngineEnvironment(HttpServlet servlet) {
        HashMap<String, Object> environment = new HashMap<String, Object>();
        String attdir = servlet.getInitParameter("axis.attachments.Directory");
        if (attdir != null) {
            environment.put("axis.attachments.Directory", attdir);
        }
        ServletContext context = servlet.getServletContext();
        environment.put("servletContext", context);
        String webInfPath = context.getRealPath("/WEB-INF");
        if (webInfPath != null) {
            environment.put("servlet.realpath", webInfPath + File.separator + "attachments");
        }
        EngineConfiguration config = new ServletEngineConfigurationFactory(context).getServerEngineConfig();
        environment.put("engineConfig", config);
        return environment;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (isDebug) {
            log.debug((Object)"Enter: doGet()");
        }
        PrintWriter writer = res.getWriter();
        try {
            block31: {
                AxisServer engine = this.getEngine();
                ServletContext servletContext = this.getServletConfig().getServletContext();
                String pathInfo = req.getPathInfo();
                String realpath = servletContext.getRealPath(req.getServletPath());
                if ((pathInfo == null || pathInfo.equals("")) && !realpath.endsWith(".jws")) {
                    res.setContentType("text/html");
                    writer.println("<h2>And now... Some Services</h2>");
                    Iterator i = engine.getConfig().getDeployedServices();
                    writer.println("<ul>");
                    while (i.hasNext()) {
                        ServiceDesc sd = (ServiceDesc)i.next();
                        StringBuffer sb = new StringBuffer();
                        sb.append("<li>");
                        sb.append(sd.getName());
                        sb.append(" <a href=\"../services/");
                        sb.append(sd.getName());
                        sb.append("?wsdl\"><i>(wsdl)</i></a></li>");
                        writer.println(sb.toString());
                        ArrayList operations = sd.getOperations();
                        if (operations.isEmpty()) continue;
                        writer.println("<ul>");
                        Iterator it = ((AbstractList)operations).iterator();
                        while (it.hasNext()) {
                            OperationDesc desc = (OperationDesc)it.next();
                            writer.println("<li>" + desc.getName());
                        }
                        writer.println("</ul>");
                    }
                    writer.println("</ul>");
                } else if (realpath != null) {
                    MessageContext msgContext = this.createMessageContext(engine, req, res);
                    try {
                        String url = HttpUtils.getRequestURL((HttpServletRequest)req).toString();
                        msgContext.setProperty(MessageContext.TRANS_URL, url);
                        msgContext.setProperty(MessageContext.WSDLGEN_INTFNAMESPACE, this.getOption(servletContext, MessageContext.WSDLGEN_INTFNAMESPACE, url));
                        msgContext.setProperty(MessageContext.WSDLGEN_SERV_LOC_URL, this.getOption(servletContext, MessageContext.WSDLGEN_SERV_LOC_URL, url));
                        boolean wsdlRequested = false;
                        boolean listRequested = false;
                        String queryString = req.getQueryString();
                        if (queryString != null) {
                            if (queryString.equalsIgnoreCase("wsdl")) {
                                wsdlRequested = true;
                            } else if (queryString.equalsIgnoreCase("list")) {
                                listRequested = true;
                            }
                        }
                        if (wsdlRequested) {
                            ((BasicHandler)engine).generateWSDL(msgContext);
                            Document doc = (Document)msgContext.getProperty("WSDL");
                            if (doc != null) {
                                res.setContentType("text/xml");
                                XMLUtils.DocumentToWriter(doc, writer);
                            } else {
                                res.setContentType("text/html");
                                writer.println("<h2>" + JavaUtils.getMessage("error00") + "</h2>");
                                writer.println("<p>" + JavaUtils.getMessage("noWSDL00") + "</p>");
                            }
                            break block31;
                        }
                        if (listRequested) {
                            if (this.enableList) {
                                Document doc = Admin.listConfig(engine);
                                if (doc != null) {
                                    res.setContentType("text/xml");
                                    XMLUtils.DocumentToWriter(doc, writer);
                                } else {
                                    res.setContentType("text/html");
                                    writer.println("<h2>" + JavaUtils.getMessage("error00") + "</h2>");
                                    writer.println("<p>" + JavaUtils.getMessage("noDeploy00") + "</p>");
                                }
                            } else {
                                res.setContentType("text/html");
                                writer.println("<h2>" + JavaUtils.getMessage("error00") + "</h2>");
                                writer.println("<p><i>?list</i>" + JavaUtils.getMessage("disabled00") + "</p>");
                            }
                            break block31;
                        }
                        if (req.getParameterNames().hasMoreElements()) {
                            res.setContentType("text/html");
                            Enumeration enumeration = req.getParameterNames();
                            String method = null;
                            String args = "";
                            while (enumeration.hasMoreElements()) {
                                String param = (String)enumeration.nextElement();
                                if (param.equalsIgnoreCase("method")) {
                                    method = req.getParameter(param);
                                    continue;
                                }
                                args = args + "<" + param + ">" + req.getParameter(param) + "</" + param + ">";
                            }
                            if (method == null) {
                                writer.println("<h2>" + JavaUtils.getMessage("error00") + ":  " + JavaUtils.getMessage("invokeGet00") + "</h2>");
                                writer.println("<p>" + JavaUtils.getMessage("noMethod01") + "</p>");
                            } else {
                                String body = "<" + method + ">" + args + "</" + method + ">";
                                String msgtxt = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Body>" + body + "</SOAP-ENV:Body>" + "</SOAP-ENV:Envelope>";
                                ByteArrayInputStream istream = new ByteArrayInputStream(msgtxt.getBytes());
                                Message msg = new Message((Object)istream, false);
                                msgContext.setRequestMessage(msg);
                                ((BasicHandler)engine).invoke(msgContext);
                                Message respMsg = msgContext.getResponseMessage();
                                if (respMsg != null) {
                                    writer.println("<p>" + JavaUtils.getMessage("gotResponse00") + "</p>");
                                    writer.println(respMsg.getSOAPPartAsString());
                                } else {
                                    writer.println("<p>" + JavaUtils.getMessage("noResponse01") + "</p>");
                                }
                            }
                            break block31;
                        }
                        res.setContentType("text/html");
                        writer.println("<h1>" + req.getRequestURI() + "</h1>");
                        writer.println("<p>" + JavaUtils.getMessage("axisService00") + "</p>");
                        writer.println("<i>" + JavaUtils.getMessage("perhaps00") + "</i>");
                    }
                    catch (AxisFault fault) {
                        res.setContentType("text/html");
                        writer.println("<h2>" + JavaUtils.getMessage("error00") + "</h2>");
                        writer.println("<p>" + JavaUtils.getMessage("somethingWrong00") + "</p>");
                        writer.println("<pre>Fault - " + fault.toString() + " </pre>");
                        writer.println("<pre>" + fault.dumpToString() + " </pre>");
                    }
                    catch (Exception e) {
                        res.setContentType("text/html");
                        writer.println("<h2>" + JavaUtils.getMessage("error00") + "</h2>");
                        writer.println("<p>" + JavaUtils.getMessage("somethingWrong00") + "</p>");
                        writer.println("<pre>Exception - " + e + "<br>");
                        writer.println(JavaUtils.stackToString(e));
                        writer.println("</pre>");
                    }
                } else {
                    res.setContentType("text/html");
                    writer.println("<html><h1>Axis HTTP Servlet</h1>");
                    writer.println(JavaUtils.getMessage("reachedServlet00"));
                    writer.println("<p>" + JavaUtils.getMessage("transportName00", "<b>" + this.transportName + "</b>"));
                    writer.println("</html>");
                }
            }
            Object var22_31 = null;
            writer.close();
            if (!isDebug) return;
        }
        catch (Throwable throwable) {
            Object var22_32 = null;
            writer.close();
            if (!isDebug) throw throwable;
            log.debug((Object)"Exit: doGet()");
            throw throwable;
        }
        log.debug((Object)"Exit: doGet()");
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        long t4 = 0L;
        String soapAction = null;
        MessageContext msgContext = null;
        if (isDebug) {
            log.debug((Object)"Enter: doPost()");
        }
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        Message responseMsg = null;
        try {
            AxisServer engine = this.getEngine();
            if (engine == null) {
                ServletException se = new ServletException(JavaUtils.getMessage("noEngine00"));
                log.debug((Object)"No Engine!", (Throwable)se);
                throw se;
            }
            res.setBufferSize(8192);
            msgContext = this.createMessageContext(engine, req, res);
            if (this.securityProvider != null) {
                if (isDebug) {
                    log.debug((Object)("securityProvider:" + this.securityProvider));
                }
                msgContext.setProperty("securityProvider", this.securityProvider);
            }
            Message requestMsg = new Message(req.getInputStream(), false, req.getHeader("Content-Type"), req.getHeader("Content-Location"));
            if (isDebug) {
                log.debug((Object)("Request Message:" + (Object)((Object)requestMsg)));
            }
            msgContext.setRequestMessage(requestMsg);
            try {
                soapAction = this.getSoapAction(req);
                if (soapAction != null) {
                    msgContext.setUseSOAPAction(true);
                    msgContext.setSOAPActionURI(soapAction);
                }
                msgContext.setSession(new AxisHttpSession(req));
                if (tlog.isDebugEnabled()) {
                    t1 = System.currentTimeMillis();
                }
                if (isDebug) {
                    log.debug((Object)"Invoking Axis Engine.");
                }
                ((BasicHandler)engine).invoke(msgContext);
                if (isDebug) {
                    log.debug((Object)"Return from Axis Engine.");
                }
                if (tlog.isDebugEnabled()) {
                    t2 = System.currentTimeMillis();
                }
                responseMsg = msgContext.getResponseMessage();
            }
            catch (AxisFault e) {
                log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
                res.setStatus(this.getHttpServletResponseStatus(e));
                responseMsg = new Message(e);
            }
            catch (Exception e) {
                log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
                res.setStatus(500);
                responseMsg = new Message(AxisFault.makeFault(e));
            }
        }
        catch (AxisFault fault) {
            log.error((Object)JavaUtils.getMessage("axisFault00"), (Throwable)fault);
            responseMsg = new Message(fault);
        }
        if (tlog.isDebugEnabled()) {
            t3 = System.currentTimeMillis();
        }
        if (responseMsg != null) {
            this.sendResponse(this.getProtocolVersion(req), res, responseMsg);
        }
        if (isDebug) {
            log.debug((Object)"Response sent.");
            log.debug((Object)"Exit: doPost()");
        }
        if (tlog.isDebugEnabled()) {
            t4 = System.currentTimeMillis();
            tlog.debug((Object)("axisServlet.doPost: " + soapAction + " pre=" + (t1 - t0) + " invoke=" + (t2 - t1) + " post=" + (t3 - t2) + " send=" + (t4 - t3) + " " + msgContext.getTargetService() + "." + msgContext.getOperation().getName()));
        }
    }

    private int getHttpServletResponseStatus(AxisFault af) {
        return af.getFaultCode().getLocalPart().equals("Server.Unauthorized") ? 401 : 500;
    }

    private void sendResponse(String clientVersion, HttpServletResponse res, Message responseMsg) throws AxisFault, IOException {
        if (responseMsg == null) {
            res.setStatus(204);
            if (isDebug) {
                log.debug((Object)"NO AXIS MESSAGE TO RETURN!");
            }
        } else {
            if (isDebug) {
                log.debug((Object)("Returned Content-Type:" + responseMsg.getContentType()));
            }
            res.setContentType(responseMsg.getContentType());
            try {
                responseMsg.writeTo((OutputStream)res.getOutputStream());
            }
            catch (SOAPException e) {
                log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
            }
        }
        if (!res.isCommitted()) {
            res.flushBuffer();
        }
    }

    private MessageContext createMessageContext(AxisEngine engine, HttpServletRequest req, HttpServletResponse res) {
        MessageContext msgContext = new MessageContext(engine);
        if (isDebug) {
            log.debug((Object)("MessageContext:" + msgContext));
            log.debug((Object)("HEADER_CONTENT_TYPE:" + req.getHeader("Content-Type")));
            log.debug((Object)("HEADER_CONTENT_LOCATION:" + req.getHeader("Content-Location")));
            log.debug((Object)("Constants.MC_HOME_DIR:" + this.getServletConfig().getServletContext().getRealPath("/")));
            log.debug((Object)("Constants.MC_RELATIVE_PATH:" + req.getServletPath()));
            log.debug((Object)("HTTPConstants.MC_HTTP_SERVLETLOCATION:" + this.webInfPath));
            log.debug((Object)("HTTPConstants.MC_HTTP_SERVLETPATHINFO:" + req.getPathInfo()));
            log.debug((Object)("HTTPConstants.HEADER_AUTHORIZATION:" + req.getHeader("Authorization")));
            log.debug((Object)("Constants.MC_REMOTE_ADDR:" + req.getRemoteAddr()));
            log.debug((Object)("configPath:" + this.webInfPath));
        }
        msgContext.setTransportName(this.transportName);
        msgContext.setProperty("jws.classDir", this.jwsClassDir);
        msgContext.setProperty("home.dir", this.homeDir);
        msgContext.setProperty("path", req.getServletPath());
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLET, (Object)this);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, req);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, res);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETLOCATION, this.webInfPath);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO, req.getPathInfo());
        msgContext.setProperty("Authorization", req.getHeader("Authorization"));
        msgContext.setProperty("remoteaddr", req.getRemoteAddr());
        String realpath = this.getServletConfig().getServletContext().getRealPath(req.getServletPath());
        if (realpath != null) {
            msgContext.setProperty("realpath", realpath);
        }
        msgContext.setProperty("configPath", this.webInfPath);
        return msgContext;
    }

    private String getSoapAction(HttpServletRequest req) throws AxisFault {
        String soapAction = req.getHeader("SOAPAction");
        if (isDebug) {
            log.debug((Object)("HEADER_SOAP_ACTION:" + soapAction));
        }
        if (soapAction == null) {
            AxisFault af = new AxisFault("Client.NoSOAPAction", JavaUtils.getMessage("noHeader00", "SOAPAction"), null, null);
            log.error((Object)JavaUtils.getMessage("genFault00"), (Throwable)af);
            throw af;
        }
        if (soapAction.length() == 0) {
            soapAction = req.getContextPath();
        }
        return soapAction;
    }

    private String getOption(ServletContext context, String param, String dephault) {
        String value = AxisEngine.getGlobalProperty(param);
        if (value == null) {
            value = this.getInitParameter(param);
        }
        if (value == null) {
            value = context.getInitParameter(param);
        }
        return value != null ? value : dephault;
    }

    protected String getDefaultJWSClassDir() {
        return this.getWebInfPath() + File.separator + "jwsClasses";
    }

    protected String getProtocolVersion(HttpServletRequest req) {
        String ver;
        int sindex;
        String ret = HTTPConstants.HEADER_PROTOCOL_V10;
        String prot = req.getProtocol();
        if (prot != null && -1 != (sindex = prot.indexOf(47)) && HTTPConstants.HEADER_PROTOCOL_V11.equals((ver = prot.substring(sindex + 1)).trim())) {
            ret = HTTPConstants.HEADER_PROTOCOL_V11;
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

