/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.configuration.ServletEngineConfigurationFactory;
import org.apache.axis.server.AxisServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisServletBase
extends HttpServlet {
    protected AxisServer axisServer = null;
    private static Log log = LogFactory.getLog((String)(class$org$apache$axis$transport$http$AxisServlet == null ? (class$org$apache$axis$transport$http$AxisServlet = AxisServletBase.class$("org.apache.axis.transport.http.AxisServlet")) : class$org$apache$axis$transport$http$AxisServlet).getName());
    private static boolean isDebug = false;
    private static int loadCounter = 0;
    private static Object loadCounterLock = new Object();
    protected static final String ATTR_AXIS_ENGINE = "AxisEngine";
    static /* synthetic */ Class class$org$apache$axis$transport$http$AxisServlet;

    public void init() {
        isDebug = log.isDebugEnabled();
        if (isDebug) {
            log.debug((Object)"In servlet init");
        }
    }

    public void destroy() {
        super.destroy();
        if (this.axisServer != null) {
            this.axisServer.cleanup();
            this.axisServer = null;
        }
    }

    public AxisServer getEngine() throws AxisFault {
        if (this.axisServer == null) {
            this.axisServer = AxisServletBase.getEngine(this);
        }
        return this.axisServer;
    }

    public static AxisServer getEngine(HttpServlet servlet) throws AxisFault {
        ServletContext context;
        AxisServer engine = null;
        if (isDebug) {
            log.debug((Object)"Enter: getEngine()");
        }
        ServletContext servletContext = context = servlet.getServletContext();
        synchronized (servletContext) {
            engine = AxisServletBase.retrieveEngine(context);
            if (engine == null) {
                Map environment = AxisServletBase.getEngineEnvironment(servlet);
                engine = AxisServer.getServer(environment);
                AxisServletBase.storeEngine(context, engine);
            }
        }
        if (isDebug) {
            log.debug((Object)"Exit: getEngine()");
        }
        return engine;
    }

    private static void storeEngine(ServletContext context, AxisServer engine) {
        context.setAttribute(ATTR_AXIS_ENGINE, (Object)engine);
    }

    private static AxisServer retrieveEngine(ServletContext context) {
        Object contextObject = context.getAttribute(ATTR_AXIS_ENGINE);
        if (contextObject instanceof AxisServer) {
            return (AxisServer)contextObject;
        }
        return null;
    }

    private static Map getEngineEnvironment(HttpServlet servlet) {
        HashMap<String, Object> environment = new HashMap<String, Object>();
        String attdir = servlet.getInitParameter("axis.attachments.Directory");
        if (attdir != null) {
            environment.put("axis.attachments.Directory", attdir);
        }
        ServletContext context = servlet.getServletContext();
        environment.put("servletContext", context);
        String webInfPath = context.getRealPath("/WEB-INF");
        if (webInfPath != null) {
            environment.put("servlet.realpath", webInfPath + File.separator + "attachments");
        }
        EngineConfiguration config = new ServletEngineConfigurationFactory(context).getServerEngineConfig();
        environment.put("engineConfig", config);
        return environment;
    }

    public static int getLoadCounter() {
        return loadCounter;
    }

    protected static void incLockCounter() {
        Object object = loadCounterLock;
        synchronized (object) {
            ++loadCounter;
        }
    }

    protected static void decLockCounter() {
        Object object = loadCounterLock;
        synchronized (object) {
            --loadCounter;
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        AxisServletBase.incLockCounter();
        try {
            super.service(req, resp);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            AxisServletBase.decLockCounter();
            throw throwable;
        }
        AxisServletBase.decLockCounter();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

