/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.Base64;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.transport.http.ChunkedInputStream;
import org.apache.axis.transport.http.ChunkedOutputStream;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HTTPSender
extends BasicHandler {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$transport$http$HTTPSender == null ? (class$org$apache$axis$transport$http$HTTPSender = HTTPSender.class$("org.apache.axis.transport.http.HTTPSender")) : class$org$apache$axis$transport$http$HTTPSender).getName());
    static /* synthetic */ Class class$org$apache$axis$transport$http$HTTPSender;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$Socket;

    public void invoke(MessageContext msgContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("enter00", "HTTPSender::invoke"));
        }
        try {
            BooleanHolder useFullURL = new BooleanHolder(false);
            StringBuffer otherHeaders = new StringBuffer();
            URL targetURL = new URL(msgContext.getStrProp(MessageContext.TRANS_URL));
            String host = targetURL.getHost();
            int port = targetURL.getPort();
            Socket sock = null;
            try {
                sock = targetURL.getProtocol().equalsIgnoreCase("https") ? this.getSecureSocket(host, port) : this.getSocket(host, port, otherHeaders, useFullURL);
                if (msgContext.getTimeout() != 0) {
                    sock.setSoTimeout(msgContext.getTimeout());
                }
                this.writeToSocket(sock, msgContext, targetURL, otherHeaders, host, port, useFullURL);
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                throw throwable;
            }
            this.readFromSocket(sock, msgContext);
        }
        catch (Exception e) {
            log.debug((Object)e);
            throw AxisFault.makeFault(e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("exit00", "HTTPDispatchHandler::invoke"));
        }
    }

    private Socket getSecureSocket(String host, int port) throws Exception {
        Socket sock = null;
        if (port == -1) {
            port = 443;
        }
        String tunnelHost = AxisEngine.getGlobalProperty("https.proxyHost");
        String tunnelPortStr = AxisEngine.getGlobalProperty("https.proxyPort");
        String nonProxyHosts = AxisEngine.getGlobalProperty("https.nonProxyHosts");
        if (tunnelHost == null) {
            tunnelHost = AxisEngine.getGlobalProperty("http.proxyHost");
        }
        if (tunnelPortStr == null) {
            tunnelPortStr = AxisEngine.getGlobalProperty("http.proxyPort");
        }
        if (nonProxyHosts == null) {
            nonProxyHosts = AxisEngine.getGlobalProperty("http.nonProxyHosts");
        }
        boolean hostInNonProxyList = this.isHostInNonProxyList(host, nonProxyHosts);
        try {
            Class SSLSocketFactoryClass = ClassUtils.forName("javax.net.ssl.SSLSocketFactory");
            Class SSLSocketClass = ClassUtils.forName("javax.net.ssl.SSLSocket");
            Method createSocketMethod = SSLSocketFactoryClass.getMethod("createSocket", class$java$lang$String == null ? (class$java$lang$String = HTTPSender.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
            Method getDefaultMethod = SSLSocketFactoryClass.getMethod("getDefault", new Class[0]);
            Method startHandshakeMethod = SSLSocketClass.getMethod("startHandshake", new Class[0]);
            Object factory = null;
            String socketFactoryClass = AxisEngine.getGlobalProperty("axis.socketFactory");
            if (socketFactoryClass != null) {
                try {
                    Class c1 = ClassUtils.forName(socketFactoryClass);
                    SocketFactoryFactory sff = (SocketFactoryFactory)c1.newInstance();
                    factory = sff.createFactory();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Created socket factory " + sff.getClass().getName()));
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (factory == null) {
                factory = getDefaultMethod.invoke(null, new Object[0]);
            }
            Object sslSocket = null;
            if (tunnelHost == null || tunnelHost.equals("") || hostInNonProxyList) {
                sslSocket = createSocketMethod.invoke(factory, host, new Integer(port));
            } else {
                Method createSocketMethod2 = SSLSocketFactoryClass.getMethod("createSocket", class$java$net$Socket == null ? (class$java$net$Socket = HTTPSender.class$("java.net.Socket")) : class$java$net$Socket, class$java$lang$String == null ? (class$java$lang$String = HTTPSender.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, Boolean.TYPE);
                int tunnelPort = tunnelPortStr != null ? (Integer.parseInt(tunnelPortStr) < 0 ? 80 : Integer.parseInt(tunnelPortStr)) : 80;
                Socket tunnel = new Socket(tunnelHost, tunnelPort);
                OutputStream tunnelOutputStream = (OutputStream)SSLSocketClass.getMethod("getOutputStream", new Class[0]).invoke((Object)tunnel, new Object[0]);
                PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(tunnelOutputStream)));
                String tunnelUser = AxisEngine.getGlobalProperty("https.proxyUser");
                String tunnelPassword = AxisEngine.getGlobalProperty("https.proxyPassword");
                if (tunnelUser == null) {
                    tunnelUser = AxisEngine.getGlobalProperty("http.proxyUser");
                }
                if (tunnelPassword == null) {
                    tunnelPassword = AxisEngine.getGlobalProperty("http.proxyPassword");
                }
                out.print("CONNECT " + host + ":" + port + " HTTP/1.0\r\n" + "User-Agent: AxisClient");
                if (tunnelUser != null && tunnelPassword != null) {
                    String encodedPassword = XMLUtils.base64encode((tunnelUser + ":" + tunnelPassword).getBytes());
                    out.print("\nProxy-Authorization: Basic " + encodedPassword);
                }
                out.print("\nContent-Length: 0");
                out.print("\nPragma: no-cache");
                out.print("\r\n\r\n");
                out.flush();
                InputStream tunnelInputStream = (InputStream)SSLSocketClass.getMethod("getInputStream", new Class[0]).invoke((Object)tunnel, new Object[0]);
                if (log.isDebugEnabled()) {
                    log.debug((Object)JavaUtils.getMessage("isNull00", "tunnelInputStream", "" + (tunnelInputStream == null)));
                }
                String replyStr = "";
                int newlinesSeen = 0;
                boolean headerDone = false;
                while (newlinesSeen < 2) {
                    int i = tunnelInputStream.read();
                    if (i < 0) {
                        throw new IOException("Unexpected EOF from proxy");
                    }
                    if (i == 10) {
                        headerDone = true;
                        ++newlinesSeen;
                        continue;
                    }
                    if (i == 13) continue;
                    newlinesSeen = 0;
                    if (headerDone) continue;
                    replyStr = replyStr + String.valueOf((char)i);
                }
                if (!replyStr.startsWith("HTTP/1.0 200") && !replyStr.startsWith("HTTP/1.1 200")) {
                    throw new IOException(JavaUtils.getMessage("cantTunnel00", new String[]{tunnelHost, "" + tunnelPort, replyStr}));
                }
                sslSocket = createSocketMethod2.invoke(factory, tunnel, host, new Integer(port), new Boolean(true));
                if (log.isDebugEnabled()) {
                    log.debug((Object)JavaUtils.getMessage("setupTunnel00", tunnelHost, "" + tunnelPort));
                }
            }
            startHandshakeMethod.invoke(sslSocket, new Object[0]);
            sock = (Socket)sslSocket;
        }
        catch (ClassNotFoundException cnfe) {
            if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("noJSSE00"));
            }
            throw AxisFault.makeFault(cnfe);
        }
        catch (NumberFormatException nfe) {
            if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("badProxy00", tunnelPortStr));
            }
            throw AxisFault.makeFault(nfe);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("createdSSL00"));
        }
        return sock;
    }

    private Socket getSocket(String host, int port, StringBuffer otherHeaders, BooleanHolder useFullURL) throws IOException {
        Socket sock = null;
        String proxyHost = AxisEngine.getGlobalProperty("http.proxyHost");
        String proxyPort = AxisEngine.getGlobalProperty("http.proxyPort");
        String nonProxyHosts = AxisEngine.getGlobalProperty("http.nonProxyHosts");
        boolean hostInNonProxyList = this.isHostInNonProxyList(host, nonProxyHosts);
        String proxyUsername = AxisEngine.getGlobalProperty("http.proxyUser");
        String proxyPassword = AxisEngine.getGlobalProperty("http.proxyPassword");
        if (proxyUsername != null) {
            StringBuffer tmpBuf = new StringBuffer();
            tmpBuf.append(proxyUsername).append(":").append(proxyPassword == null ? "" : proxyPassword);
            otherHeaders.append("Proxy-Authorization").append(": Basic ").append(Base64.encode(tmpBuf.toString().getBytes())).append("\r\n");
        }
        if (port == -1) {
            port = 80;
        }
        if (proxyHost == null || proxyHost.equals("") || proxyPort == null || proxyPort.equals("") || hostInNonProxyList) {
            sock = new Socket(host, port);
            if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("createdHTTP00"));
            }
        } else {
            sock = new Socket(proxyHost, (int)new Integer(proxyPort));
            if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("createdHTTP01", proxyHost, proxyPort));
            }
            useFullURL.value = true;
        }
        return sock;
    }

    private void writeToSocket(Socket sock, MessageContext msgContext, URL tmpURL, StringBuffer otherHeaders, String host, int port, BooleanHolder useFullURL) throws IOException {
        Hashtable userHeaderTable;
        String action;
        String userID = null;
        String passwd = null;
        String reqEnv = null;
        userID = msgContext.getUsername();
        passwd = msgContext.getPassword();
        String string = action = msgContext.useSOAPAction() ? msgContext.getSOAPActionURI() : "";
        if (action == null) {
            action = "";
        }
        if (userID == null && tmpURL.getUserInfo() != null) {
            String info = tmpURL.getUserInfo();
            int sep = info.indexOf(58);
            if (sep >= 0 && sep + 1 < info.length()) {
                userID = info.substring(0, sep);
                passwd = info.substring(sep + 1);
            } else {
                userID = info;
            }
        }
        if (userID != null) {
            StringBuffer tmpBuf = new StringBuffer();
            tmpBuf.append(userID).append(":").append(passwd == null ? "" : passwd);
            otherHeaders.append("Authorization").append(": Basic ").append(Base64.encode(tmpBuf.toString().getBytes())).append("\r\n");
        }
        if (msgContext.getMaintainSession()) {
            String cookie = msgContext.getStrProp("Cookie");
            String cookie2 = msgContext.getStrProp("Cookie2");
            if (cookie != null) {
                otherHeaders.append("Cookie").append(": ").append(cookie).append("\r\n");
            }
            if (cookie2 != null) {
                otherHeaders.append("Cookie2").append(": ").append(cookie2).append("\r\n");
            }
        }
        StringBuffer header = new StringBuffer();
        header.append("POST").append(" ");
        if (useFullURL.value) {
            header.append(tmpURL.toExternalForm());
        } else {
            header.append(tmpURL.getFile() == null || tmpURL.getFile().equals("") ? "/" : tmpURL.getFile());
        }
        Message reqMessage = msgContext.getRequestMessage();
        boolean http10 = true;
        boolean httpChunkStream = false;
        String httpConnection = null;
        String httpver = msgContext.getStrProp(MessageContext.HTTP_TRANSPORT_VERSION);
        if (null == httpver) {
            httpver = HTTPConstants.HEADER_PROTOCOL_V10;
        }
        if ((httpver = httpver.trim()).equals(HTTPConstants.HEADER_PROTOCOL_V11)) {
            http10 = false;
        }
        if ((userHeaderTable = (Hashtable)msgContext.getProperty("HTTP-Request-Headers")) != null) {
            if (null == otherHeaders) {
                otherHeaders = new StringBuffer(1024);
            }
            Iterator e = userHeaderTable.entrySet().iterator();
            while (e.hasNext()) {
                String val;
                Map.Entry me = e.next();
                Object keyObj = me.getKey();
                if (null == keyObj) continue;
                String key = keyObj.toString().trim();
                if (key.equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING)) {
                    if (http10 || null == (val = me.getValue().toString()) || !val.trim().equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) continue;
                    httpChunkStream = true;
                    continue;
                }
                if (key.equalsIgnoreCase("Host") || key.equalsIgnoreCase("Content-Type") || key.equalsIgnoreCase("SOAPAction") || key.equalsIgnoreCase("Content-Length") || key.equalsIgnoreCase("Cookie") || key.equalsIgnoreCase("Cookie2") || key.equalsIgnoreCase("Authorization") || key.equalsIgnoreCase("Proxy-Authorization")) continue;
                if (key.equalsIgnoreCase("Connection")) {
                    if (http10 || !(val = me.getValue().toString()).trim().equalsIgnoreCase(HTTPConstants.HEADER_CONNECTION_CLOSE)) continue;
                    httpConnection = HTTPConstants.HEADER_CONNECTION_CLOSE;
                    continue;
                }
                otherHeaders.append(key).append(": ").append(me.getValue()).append("\r\n");
            }
        }
        if (!http10) {
            httpConnection = HTTPConstants.HEADER_CONNECTION_CLOSE;
        }
        header.append(" ");
        header.append(http10 ? "HTTP/1.0" : "HTTP/1.1").append("\r\n").append("Host").append(": ").append(host).append(port == -1 ? "" : ":" + port).append("\r\n").append("Content-Type").append(": ").append(reqMessage.getContentType()).append("\r\n").append("SOAPAction").append(": \"").append(action).append("\"\r\n");
        if (!httpChunkStream) {
            header.append("Content-Length").append(": ").append(reqMessage.getContentLength()).append("\r\n");
        } else {
            header.append(HTTPConstants.HEADER_TRANSFER_ENCODING).append(": ").append(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED).append("\r\n");
        }
        if (null != httpConnection) {
            header.append("Connection");
            header.append(": ");
            header.append(httpConnection);
            header.append("\r\n");
        }
        if (null != otherHeaders) {
            header.append((Object)otherHeaders);
        }
        header.append("\r\n");
        OutputStream out = sock.getOutputStream();
        out.write(header.toString().getBytes("iso-8859-1"));
        out.flush();
        ChunkedOutputStream chunkedOutputStream = null;
        if (httpChunkStream) {
            chunkedOutputStream = new ChunkedOutputStream(out);
            out = chunkedOutputStream;
        }
        out = new BufferedOutputStream(out, 8192);
        try {
            reqMessage.writeTo(out);
        }
        catch (SOAPException e) {
            log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
        }
        if (null != chunkedOutputStream) {
            out.flush();
            chunkedOutputStream.eos();
        }
        out.flush();
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("xmlSent00"));
            log.debug((Object)"---------------------------------------------------");
            log.debug((Object)(header + reqEnv));
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void readFromSocket(Socket sock, MessageContext msgContext) throws IOException {
        block16: {
            outMsg = null;
            len = 0;
            colonIndex = -1;
            headers = new Hashtable<String, String>();
            statusMessage = "";
            returnCode = 0;
            inp /* !! */  = new BufferedInputStream(sock.getInputStream());
            readTooMuch = false;
            b = 0;
            buf = new ByteArrayOutputStream(4097);
            while (true) {
                if (!readTooMuch) {
                    b = (byte)inp /* !! */ .read();
                }
                if (b == -1) break;
                readTooMuch = false;
                if (b != 13 && b != 10) {
                    if (b == 58 && colonIndex == -1) {
                        colonIndex = len;
                    }
                    ++len;
                    buf.write(b);
                    continue;
                }
                if (b == 13) continue;
                if (len == 0) break;
                b = (byte)inp /* !! */ .read();
                readTooMuch = true;
                if (b == 32 || b == 9) continue;
                buf.close();
                hdata = buf.toByteArray();
                buf.reset();
                if (colonIndex != -1) {
                    name = new String(hdata, 0, colonIndex, "iso-8859-1");
                    value = new String(hdata, colonIndex + 1, len - 1 - colonIndex, "iso-8859-1");
                    colonIndex = -1;
                } else {
                    name = new String(hdata, 0, len, "iso-8859-1");
                    value = "";
                }
                if (HTTPSender.log.isDebugEnabled()) {
                    HTTPSender.log.debug((Object)(name + value));
                }
                if (msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE) == null) {
                    start = name.indexOf(32) + 1;
                    tmp = name.substring(start).trim();
                    end = tmp.indexOf(32);
                    if (end != -1) {
                        tmp = tmp.substring(0, end);
                    }
                    returnCode = Integer.parseInt(tmp);
                    msgContext.setProperty(HTTPConstants.MC_HTTP_STATUS_CODE, new Integer(returnCode));
                    statusMessage = name.substring(start + end + 1);
                    msgContext.setProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE, statusMessage);
                } else {
                    headers.put(name.toLowerCase(), value);
                }
                len = 0;
            }
            contentType = (String)headers.get("Content-Type".toLowerCase());
            v0 = contentType = null == contentType ? null : contentType.trim();
            if (returnCode > 199 && returnCode < 300 || contentType != null && !contentType.equals("text/html") && returnCode > 499 && returnCode < 600) break block16;
            buf = new ByteArrayOutputStream(4097);
            if (true) ** GOTO lbl61
            do {
                buf.write(b);
lbl61:
                // 2 sources

                v1 = (byte)inp /* !! */ .read();
                b = v1;
            } while (-1 != v1);
            fault = new AxisFault("HTTP", "(" + returnCode + ")" + statusMessage, null, null);
            fault.setFaultDetailString(JavaUtils.getMessage("return01", "" + returnCode, buf.toString()));
            throw fault;
        }
        if (b != -1) {
            contentLocation = (String)headers.get("Content-Location".toLowerCase());
            contentLocation = null == contentLocation ? null : contentLocation.trim();
            contentLength = (String)headers.get("Content-Length".toLowerCase());
            contentLength = null == contentLength ? null : contentLength.trim();
            transferEncoding = (String)headers.get(HTTPConstants.HEADER_TRANSFER_ENCODING.toLowerCase());
            if (null != transferEncoding && transferEncoding.trim().equals(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) {
                inp /* !! */  = new ChunkedInputStream(inp /* !! */ );
            }
            outMsg = new Message(inp /* !! */ , false, contentType, contentLocation);
            outMsg.setMessageType("response");
            msgContext.setResponseMessage(outMsg);
            if (HTTPSender.log.isDebugEnabled()) {
                if (null == contentLength) {
                    HTTPSender.log.debug((Object)("\n" + JavaUtils.getMessage("no00", "Content-Length")));
                }
                HTTPSender.log.debug((Object)("\n" + JavaUtils.getMessage("xmlRecd00")));
                HTTPSender.log.debug((Object)"-----------------------------------------------");
                HTTPSender.log.debug((Object)outMsg.getSOAPPartAsString());
            }
        }
        if (msgContext.getMaintainSession()) {
            this.handleCookie("Cookie", "Set-Cookie", headers, msgContext);
            this.handleCookie("Cookie2", "Set-Cookie2", headers, msgContext);
        }
    }

    public void handleCookie(String cookieName, String setCookieName, Hashtable headers, MessageContext msgContext) {
        if (headers.containsKey(setCookieName.toLowerCase())) {
            String cookie = (String)headers.get(setCookieName.toLowerCase());
            int index = (cookie = cookie.trim()).indexOf(59);
            if (index != -1) {
                cookie = cookie.substring(0, index);
            }
            msgContext.setProperty(cookieName, cookie);
        }
    }

    private boolean isHostInNonProxyList(String host, String nonProxyHosts) {
        if (nonProxyHosts == null || host == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|\"");
        while (tokenizer.hasMoreTokens()) {
            String pattern = tokenizer.nextToken();
            if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("match00", new String[]{"HTTPSender", host, pattern}));
            }
            if (!HTTPSender.match(pattern, host, false)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean match(String pattern, String str, boolean isCaseSensitive) {
        patArr = pattern.toCharArray();
        strArr = str.toCharArray();
        patIdxStart = 0;
        patIdxEnd = patArr.length - 1;
        strIdxStart = 0;
        strIdxEnd = strArr.length - 1;
        containsStar = false;
        i = 0;
        while (i < patArr.length) {
            if (patArr[i] == '*') {
                containsStar = true;
                break;
            }
            ++i;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            i = 0;
            while (i <= patIdxEnd) {
                ch = patArr[i];
                if (isCaseSensitive && ch != strArr[i]) {
                    return false;
                }
                if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (patIdxEnd != 0) ** GOTO lbl36
        return true;
lbl-1000:
        // 1 sources

        {
            if (isCaseSensitive && ch != strArr[strIdxStart]) {
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart])) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
lbl36:
            // 2 sources

            ** while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd)
        }
lbl37:
        // 1 sources

        if (strIdxStart <= strIdxEnd) ** GOTO lbl51
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            if (isCaseSensitive && ch != strArr[strIdxEnd]) {
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxEnd])) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
lbl51:
            // 2 sources

            ** while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd)
        }
lbl52:
        // 1 sources

        if (strIdxStart <= strIdxEnd) ** GOTO lbl92
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            patIdxTmp = -1;
            i = patIdxStart + 1;
            while (i <= patIdxEnd) {
                if (patArr[i] == '*') {
                    patIdxTmp = i;
                    break;
                }
                ++i;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            patLength = patIdxTmp - patIdxStart - 1;
            strLength = strIdxEnd - strIdxStart + 1;
            foundIdx = -1;
            i = 0;
            while (i <= strLength - patLength) {
                block27: {
                    j = 0;
                    while (j < patLength) {
                        ch = patArr[patIdxStart + j + 1];
                        if (!(isCaseSensitive && ch != strArr[strIdxStart + i + j] || !isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart + i + j]))) {
                            ++j;
                            continue;
                        }
                        break block27;
                    }
                    foundIdx = strIdxStart + i;
                    break;
                }
                ++i;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
lbl92:
            // 3 sources

            ** while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd)
        }
lbl93:
        // 1 sources

        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class BooleanHolder {
        public boolean value;

        public BooleanHolder(boolean value) {
            this.value = value;
        }
    }

    public static interface SocketFactoryFactory {
        public Object createFactory() throws Exception;
    }
}

