/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import org.apache.axis.server.AxisServer;
import org.apache.axis.session.Session;
import org.apache.axis.session.SimpleSession;
import org.apache.axis.transport.http.SimpleAxisWorker;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleAxisServer
implements Runnable {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$transport$http$SimpleAxisServer == null ? (class$org$apache$axis$transport$http$SimpleAxisServer = SimpleAxisServer.class$("org.apache.axis.transport.http.SimpleAxisServer")) : class$org$apache$axis$transport$http$SimpleAxisServer).getName());
    private Hashtable sessions = new Hashtable();
    private static boolean doSessions = true;
    public static int sessionIndex = 0;
    private static AxisServer myAxisServer = null;
    private boolean stopped = false;
    private ServerSocket serverSocket;
    private volatile Thread worker = null;
    static /* synthetic */ Class class$org$apache$axis$transport$http$SimpleAxisServer;

    protected boolean isSessionUsed() {
        return doSessions;
    }

    protected Session createSession(String cooky) {
        Session session = null;
        if (this.sessions.containsKey(cooky)) {
            session = (Session)this.sessions.get(cooky);
        } else {
            session = new SimpleSession();
            this.sessions.put(cooky, session);
        }
        return session;
    }

    protected static synchronized AxisServer getAxisServer() {
        if (myAxisServer == null) {
            myAxisServer = new AxisServer();
        }
        return myAxisServer;
    }

    public void run() {
        log.info((Object)JavaUtils.getMessage("start00", "SimpleAxisServer", new Integer(this.getServerSocket().getLocalPort()).toString()));
        while (!this.stopped) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
            }
            catch (InterruptedIOException iie) {
            }
            catch (Exception e) {
                log.debug((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
                break;
            }
            if (socket == null) continue;
            SimpleAxisWorker worker = new SimpleAxisWorker(this, socket);
            Thread thread = new Thread(worker);
            thread.setDaemon(true);
            thread.start();
        }
        log.info((Object)JavaUtils.getMessage("quit00", "SimpleAxisServer"));
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    public void start(boolean daemon) throws Exception {
        this.worker = new Thread(this);
        this.worker.setDaemon(daemon);
        this.worker.start();
    }

    public void start() throws Exception {
        this.start(false);
    }

    public void stop() throws Exception {
        this.stopped = true;
        try {
            this.serverSocket.close();
        }
        catch (Exception e) {
            log.info((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
        }
        log.info((Object)JavaUtils.getMessage("quit00", "SimpleAxisServer"));
        System.exit(0);
    }

    public static void main(String[] args) {
        SimpleAxisServer sas = new SimpleAxisServer();
        Options opts = null;
        try {
            opts = new Options(args);
        }
        catch (MalformedURLException e) {
            log.error((Object)JavaUtils.getMessage("malformedURLException00"), (Throwable)e);
            return;
        }
        try {
            int port = opts.getPort();
            ServerSocket ss = null;
            int i = 0;
            while (i < 5) {
                try {
                    ss = new ServerSocket(port);
                    break;
                }
                catch (BindException be) {
                    log.debug((Object)JavaUtils.getMessage("exception00"), (Throwable)be);
                    if (i >= 4) {
                        throw new Exception(JavaUtils.getMessage("unableToStartServer00", Integer.toString(port)));
                    }
                    Thread.sleep(3000L);
                    ++i;
                }
            }
            sas.setServerSocket(ss);
            sas.start();
        }
        catch (Exception e) {
            log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

