/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanPropertyDescriptor {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$utils$BeanPropertyDescriptor == null ? (class$org$apache$axis$utils$BeanPropertyDescriptor = BeanPropertyDescriptor.class$("org.apache.axis.utils.BeanPropertyDescriptor")) : class$org$apache$axis$utils$BeanPropertyDescriptor).getName());
    private String name = null;
    private Method getter = null;
    private Method setter = null;
    private Method getterIndexed = null;
    private Method setterIndexed = null;
    private Field field = null;
    private static final Object[] noArgs = new Object[0];
    static /* synthetic */ Class class$org$apache$axis$utils$BeanPropertyDescriptor;

    public BeanPropertyDescriptor(String _name, Method _getter, Method _setter) {
        this.name = _name;
        this.getter = _getter;
        this.setter = _setter;
        if (_getter == null || _setter == null || _name == null) {
            throw new IllegalArgumentException(JavaUtils.getMessage(_getter == null ? "badGetter00" : (_setter == null ? "badSetter00" : "badProp03")));
        }
    }

    public BeanPropertyDescriptor(String _name, Method _getter, Method _setter, Method _getterIndexed, Method _setterIndexed) {
        this(_name, _getter, _setter);
        this.getterIndexed = _getterIndexed;
        this.setterIndexed = _setterIndexed;
        if (_getterIndexed == null || _setterIndexed == null) {
            throw new IllegalArgumentException(JavaUtils.getMessage(_getterIndexed == null ? "badAccessor00" : "badModifier00"));
        }
    }

    public BeanPropertyDescriptor(String _name, Field _field) {
        this.name = _name;
        this.field = _field;
        if (_field == null || _name == null) {
            throw new IllegalArgumentException(JavaUtils.getMessage(_field == null ? "badField00" : "badProp03"));
        }
    }

    public boolean isReadable() {
        return this.getter != null || this.field != null;
    }

    public boolean isWriteable() {
        return this.setter != null || this.field != null;
    }

    public boolean isIndexed() {
        return this.getterIndexed != null && this.setterIndexed != null;
    }

    public Object get(Object obj) throws InvocationTargetException, IllegalAccessException {
        if (this.getter != null) {
            return this.getter.invoke(obj, noArgs);
        }
        if (this.field != null) {
            return this.field.get(obj);
        }
        return null;
    }

    public void set(Object obj, Object newValue) throws InvocationTargetException, IllegalAccessException {
        if (this.setter != null) {
            this.setter.invoke(obj, newValue);
        } else if (this.field != null) {
            this.field.set(obj, newValue);
        }
    }

    public Object get(Object obj, int i) throws InvocationTargetException, IllegalAccessException {
        if (!this.isIndexed()) {
            return Array.get(this.get(obj), i);
        }
        return this.getterIndexed.invoke(obj, new Integer(i));
    }

    public void set(Object obj, int i, Object newValue) throws InvocationTargetException, IllegalAccessException {
        Object array = this.get(obj);
        if (array == null || Array.getLength(array) <= i) {
            Class<?> componentType = null;
            componentType = this.getterIndexed != null ? this.getterIndexed.getReturnType() : (this.getter != null ? this.getter.getReturnType().getComponentType() : this.field.getType().getComponentType());
            Object newArray = Array.newInstance(componentType, i + 1);
            this.set(obj, newArray);
            int len = 0;
            if (array != null) {
                len = Array.getLength(array);
            }
            int index = 0;
            while (index < len) {
                this.set(obj, index, Array.get(array, index));
                ++index;
            }
        }
        if (this.isIndexed()) {
            this.setterIndexed.invoke(obj, new Integer(i), newValue);
        } else {
            Array.set(this.get(obj), i, newValue);
        }
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        if (this.isIndexed()) {
            return this.getterIndexed.getReturnType();
        }
        if (this.getter != null) {
            return this.getter.getReturnType();
        }
        return this.field.getType();
    }

    Method getReadMethod() {
        return this.getter;
    }

    Method getWriteMethod() {
        return this.setter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

