/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.beans.Introspector;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.rpc.holders.Holder;
import org.apache.axis.encoding.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaUtils {
    public static final String LS = System.getProperty("line.separator");
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$utils$JavaUtils == null ? (class$org$apache$axis$utils$JavaUtils = JavaUtils.class$("org.apache.axis.utils.JavaUtils")) : class$org$apache$axis$utils$JavaUtils).getName());
    static final String[] keywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    static final Collator englishCollator = Collator.getInstance(Locale.ENGLISH);
    static final char keywordPrefix = '_';
    private static ResourceBundle messages = null;
    static /* synthetic */ Class class$org$apache$axis$utils$JavaUtils;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$org$apache$axis$encoding$Hex;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;
    static /* synthetic */ Class class$java$lang$String;

    public static Class getWrapperClass(Class primitive) {
        if (primitive == Integer.TYPE) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = JavaUtils.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (primitive == Short.TYPE) {
            return class$java$lang$Short == null ? (class$java$lang$Short = JavaUtils.class$("java.lang.Short")) : class$java$lang$Short;
        }
        if (primitive == Boolean.TYPE) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = JavaUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (primitive == Byte.TYPE) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = JavaUtils.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (primitive == Long.TYPE) {
            return class$java$lang$Long == null ? (class$java$lang$Long = JavaUtils.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (primitive == Double.TYPE) {
            return class$java$lang$Double == null ? (class$java$lang$Double = JavaUtils.class$("java.lang.Double")) : class$java$lang$Double;
        }
        if (primitive == Float.TYPE) {
            return class$java$lang$Float == null ? (class$java$lang$Float = JavaUtils.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (primitive == Character.TYPE) {
            return class$java$lang$Character == null ? (class$java$lang$Character = JavaUtils.class$("java.lang.Character")) : class$java$lang$Character;
        }
        return null;
    }

    public static String getWrapper(String primitive) {
        if (primitive.equals("int")) {
            return "Integer";
        }
        if (primitive.equals("short")) {
            return "Short";
        }
        if (primitive.equals("boolean")) {
            return "Boolean";
        }
        if (primitive.equals("byte")) {
            return "Byte";
        }
        if (primitive.equals("long")) {
            return "Long";
        }
        if (primitive.equals("double")) {
            return "Double";
        }
        if (primitive.equals("float")) {
            return "Float";
        }
        if (primitive.equals("char")) {
            return "Character";
        }
        return null;
    }

    public static Class getPrimitiveClass(Class wrapper) {
        if (wrapper == (class$java$lang$Integer == null ? (class$java$lang$Integer = JavaUtils.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return Integer.TYPE;
        }
        if (wrapper == (class$java$lang$Short == null ? (class$java$lang$Short = JavaUtils.class$("java.lang.Short")) : class$java$lang$Short)) {
            return Short.TYPE;
        }
        if (wrapper == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JavaUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return Boolean.TYPE;
        }
        if (wrapper == (class$java$lang$Byte == null ? (class$java$lang$Byte = JavaUtils.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return Byte.TYPE;
        }
        if (wrapper == (class$java$lang$Long == null ? (class$java$lang$Long = JavaUtils.class$("java.lang.Long")) : class$java$lang$Long)) {
            return Long.TYPE;
        }
        if (wrapper == (class$java$lang$Double == null ? (class$java$lang$Double = JavaUtils.class$("java.lang.Double")) : class$java$lang$Double)) {
            return Double.TYPE;
        }
        if (wrapper == (class$java$lang$Float == null ? (class$java$lang$Float = JavaUtils.class$("java.lang.Float")) : class$java$lang$Float)) {
            return Float.TYPE;
        }
        if (wrapper == (class$java$lang$Character == null ? (class$java$lang$Character = JavaUtils.class$("java.lang.Character")) : class$java$lang$Character)) {
            return Character.TYPE;
        }
        return null;
    }

    public static Object convert(Object arg, Class destClass) {
        Class hintClass;
        if (destClass == null) {
            return arg;
        }
        if (arg != null && destClass.isAssignableFrom(arg.getClass())) {
            return arg;
        }
        if (log.isDebugEnabled()) {
            String clsName = "null";
            if (arg != null) {
                clsName = arg.getClass().getName();
            }
            log.debug((Object)JavaUtils.getMessage("convert00", clsName, destClass.getName()));
        }
        Object destValue = null;
        if (arg instanceof ConvertCache && (destValue = ((ConvertCache)arg).getConvertedValue(destClass)) != null) {
            return destValue;
        }
        Class destHeldType = JavaUtils.getHolderValueType(destClass);
        Class argHeldType = null;
        if (arg != null) {
            argHeldType = JavaUtils.getHolderValueType(arg.getClass());
        }
        if (arg instanceof Hex && destClass == (array$B == null ? (array$B = JavaUtils.class$("[B")) : array$B)) {
            return ((Hex)arg).getBytes();
        }
        if (arg instanceof byte[] && destClass == (class$org$apache$axis$encoding$Hex == null ? (class$org$apache$axis$encoding$Hex = JavaUtils.class$("org.apache.axis.encoding.Hex")) : class$org$apache$axis$encoding$Hex)) {
            return new Hex((byte[])arg);
        }
        if (arg instanceof Calendar && destClass == (class$java$util$Date == null ? (class$java$util$Date = JavaUtils.class$("java.util.Date")) : class$java$util$Date)) {
            return ((Calendar)arg).getTime();
        }
        if (arg instanceof HashMap && destClass == (class$java$util$Hashtable == null ? (class$java$util$Hashtable = JavaUtils.class$("java.util.Hashtable")) : class$java$util$Hashtable)) {
            return new Hashtable((HashMap)arg);
        }
        if (!(arg instanceof Collection) && (arg == null || !arg.getClass().isArray()) && (destHeldType == null && argHeldType == null || destHeldType != null && argHeldType != null)) {
            return arg;
        }
        if (destHeldType != null) {
            Object newArg = JavaUtils.convert(arg, destHeldType);
            Object argHolder = null;
            try {
                argHolder = destClass.newInstance();
                JavaUtils.setHolderValue(argHolder, newArg);
                return argHolder;
            }
            catch (Exception e) {
                return arg;
            }
        }
        if (argHeldType != null) {
            try {
                Object newArg = JavaUtils.getHolderValue(arg);
                return JavaUtils.convert(newArg, destClass);
            }
            catch (HolderException e) {
                return arg;
            }
        }
        if (arg instanceof ConvertCache && ((ConvertCache)arg).getDestClass() != destClass && (hintClass = ((ConvertCache)arg).getDestClass()) != null && hintClass.isArray() && destClass.isArray() && destClass.isAssignableFrom(hintClass) && (destValue = ((ConvertCache)arg).getConvertedValue(destClass = hintClass)) != null) {
            return destValue;
        }
        if (arg == null) {
            return arg;
        }
        int length = 0;
        length = arg.getClass().isArray() ? Array.getLength(arg) : ((Collection)arg).size();
        if (destClass.isArray()) {
            if (destClass.getComponentType().isPrimitive()) {
                Object array = Array.newInstance(destClass.getComponentType(), length);
                if (arg.getClass().isArray()) {
                    int i = 0;
                    while (i < length) {
                        Array.set(array, i, Array.get(arg, i));
                        ++i;
                    }
                } else {
                    int idx = 0;
                    Iterator i = ((Collection)arg).iterator();
                    while (i.hasNext()) {
                        Array.set(array, idx++, i.next());
                    }
                }
                destValue = array;
            } else {
                Object[] array;
                try {
                    array = (Object[])Array.newInstance(destClass.getComponentType(), length);
                }
                catch (Exception e) {
                    return arg;
                }
                if (arg.getClass().isArray()) {
                    int i = 0;
                    while (i < length) {
                        array[i] = JavaUtils.convert(Array.get(arg, i), destClass.getComponentType());
                        ++i;
                    }
                } else {
                    int idx = 0;
                    Iterator i = ((Collection)arg).iterator();
                    while (i.hasNext()) {
                        array[idx++] = JavaUtils.convert(i.next(), destClass.getComponentType());
                    }
                }
                destValue = array;
            }
        } else if ((class$java$util$Collection == null ? (class$java$util$Collection = JavaUtils.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(destClass)) {
            Collection newList = null;
            try {
                newList = destClass == (class$java$util$Collection == null ? (class$java$util$Collection = JavaUtils.class$("java.util.Collection")) : class$java$util$Collection) || destClass == (class$java$util$List == null ? (class$java$util$List = JavaUtils.class$("java.util.List")) : class$java$util$List) ? new ArrayList() : (destClass == (class$java$util$Set == null ? (class$java$util$Set = JavaUtils.class$("java.util.Set")) : class$java$util$Set) ? new HashSet() : (Collection)destClass.newInstance());
            }
            catch (Exception e) {
                return arg;
            }
            if (arg.getClass().isArray()) {
                int j = 0;
                while (j < length) {
                    newList.add(Array.get(arg, j));
                    ++j;
                }
            } else {
                Iterator j = ((Collection)arg).iterator();
                while (j.hasNext()) {
                    newList.add(j.next());
                }
            }
            destValue = newList;
        } else {
            destValue = arg;
        }
        if (arg instanceof ConvertCache) {
            ((ConvertCache)arg).setConvertedValue(destClass, destValue);
        }
        return destValue;
    }

    public static boolean isConvertable(Object obj, Class dest) {
        Class<?> src = null;
        if (obj != null) {
            src = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        }
        if (dest == null) {
            return false;
        }
        if (src != null) {
            if (dest.isAssignableFrom(src)) {
                return true;
            }
            if (JavaUtils.getWrapperClass(src) == dest) {
                return true;
            }
            if (JavaUtils.getWrapperClass(dest) == src) {
                return true;
            }
            if (((class$java$util$Collection == null ? (class$java$util$Collection = JavaUtils.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(src) || src.isArray()) && ((class$java$util$Collection == null ? (class$java$util$Collection = JavaUtils.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(dest) || dest.isArray())) {
                return true;
            }
            if (src == (class$org$apache$axis$encoding$Hex == null ? (class$org$apache$axis$encoding$Hex = JavaUtils.class$("org.apache.axis.encoding.Hex")) : class$org$apache$axis$encoding$Hex) && dest == (array$B == null ? (array$B = JavaUtils.class$("[B")) : array$B) || src == (array$B == null ? (array$B = JavaUtils.class$("[B")) : array$B) && dest == (class$org$apache$axis$encoding$Hex == null ? (class$org$apache$axis$encoding$Hex = JavaUtils.class$("org.apache.axis.encoding.Hex")) : class$org$apache$axis$encoding$Hex)) {
                return true;
            }
            if (src == (class$java$util$HashMap == null ? (class$java$util$HashMap = JavaUtils.class$("java.util.HashMap")) : class$java$util$HashMap) && dest == (class$java$util$Hashtable == null ? (class$java$util$Hashtable = JavaUtils.class$("java.util.Hashtable")) : class$java$util$Hashtable)) {
                return true;
            }
        }
        Class destHeld = JavaUtils.getHolderValueType(dest);
        if (src == null) {
            return destHeld != null;
        }
        if (destHeld != null && (destHeld.isAssignableFrom(src) || JavaUtils.isConvertable(src, destHeld))) {
            return true;
        }
        Class srcHeld = JavaUtils.getHolderValueType(src);
        return srcHeld != null && (dest.isAssignableFrom(srcHeld) || JavaUtils.isConvertable(srcHeld, dest));
    }

    public static boolean isJavaId(String id) {
        if (id == null || id.equals("") || JavaUtils.isJavaKeyword(id)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(id.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < id.length()) {
            if (!Character.isJavaIdentifierPart(id.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isJavaKeyword(String keyword) {
        return Arrays.binarySearch(keywords, keyword, englishCollator) >= 0;
    }

    public static String makeNonJavaKeyword(String keyword) {
        return '_' + keyword;
    }

    public static String getLoadableClassName(String text) {
        if (text == null || text.indexOf("[") < 0 || text.charAt(0) == '[') {
            return text;
        }
        String className = text.substring(0, text.indexOf("["));
        className = className.equals("byte") ? "B" : (className.equals("char") ? "C" : (className.equals("double") ? "D" : (className.equals("float") ? "F" : (className.equals("int") ? "I" : (className.equals("long") ? "J" : (className.equals("short") ? "S" : (className.equals("boolean") ? "Z" : "L" + className + ";")))))));
        int i = text.indexOf("]");
        while (i > 0) {
            className = "[" + className;
            i = text.indexOf("]", i + 1);
        }
        return className;
    }

    public static String getTextClassName(String text) {
        if (text == null || text.indexOf("[") != 0) {
            return text;
        }
        String className = "";
        int index = 0;
        while (index < text.length() && text.charAt(index) == '[') {
            ++index;
            className = className + "[]";
        }
        if (index < text.length()) {
            className = text.charAt(index) == 'B' ? "byte" + className : (text.charAt(index) == 'C' ? "char" + className : (text.charAt(index) == 'D' ? "double" + className : (text.charAt(index) == 'F' ? "float" + className : (text.charAt(index) == 'I' ? "int" + className : (text.charAt(index) == 'J' ? "long" + className : (text.charAt(index) == 'S' ? "short" + className : (text.charAt(index) == 'Z' ? "boolean" + className : text.substring(index + 1, text.indexOf(";")) + className)))))));
        }
        return className;
    }

    public static String xmlNameToJava(String name) {
        if (name == null || name.equals("")) {
            return name;
        }
        char[] nameArray = name.toCharArray();
        int nameLen = name.length();
        StringBuffer result = new StringBuffer(nameLen);
        boolean wordStart = false;
        int i = 0;
        while (i < nameLen && (JavaUtils.isPunctuation(nameArray[i]) || !Character.isJavaIdentifierStart(nameArray[i]))) {
            ++i;
        }
        if (i < nameLen) {
            result.append(nameArray[i]);
            wordStart = !Character.isLetter(nameArray[i]);
        } else if (Character.isJavaIdentifierPart(nameArray[0])) {
            result.append("_" + nameArray[0]);
        } else {
            result.append("_" + nameArray.length);
        }
        ++i;
        while (i < nameLen) {
            char c = nameArray[i];
            if (JavaUtils.isPunctuation(c) || !Character.isJavaIdentifierPart(c)) {
                wordStart = true;
            } else {
                if (wordStart && Character.isLowerCase(c)) {
                    result.append(Character.toUpperCase(c));
                } else {
                    result.append(c);
                }
                wordStart = !Character.isLetter(c);
            }
            ++i;
        }
        String newName = result.toString();
        if (Character.isUpperCase(newName.charAt(0))) {
            newName = Introspector.decapitalize(newName);
        }
        if (JavaUtils.isJavaKeyword(newName)) {
            newName = JavaUtils.makeNonJavaKeyword(newName);
        }
        return newName;
    }

    private static boolean isPunctuation(char c) {
        return '-' == c || '.' == c || ':' == c || '\u00b7' == c || '\u0387' == c || '\u06dd' == c || '\u06de' == c;
    }

    public static ResourceBundle getMessageResourceBundle() {
        if (messages == null) {
            JavaUtils.initializeMessages();
        }
        return messages;
    }

    public static String getMessage(String key) throws MissingResourceException {
        if (messages == null) {
            JavaUtils.initializeMessages();
        }
        return messages.getString(key);
    }

    public static String getMessage(String key, String var) throws MissingResourceException {
        Object[] args = new String[]{var};
        return MessageFormat.format(JavaUtils.getMessage(key), args);
    }

    public static String getMessage(String key, String var1, String var2) throws MissingResourceException {
        Object[] args = new String[]{var1, var2};
        return MessageFormat.format(JavaUtils.getMessage(key), args);
    }

    public static String getMessage(String key, String var1, String var2, String var3) throws MissingResourceException {
        return MessageFormat.format(JavaUtils.getMessage(key), var1, var2, var3);
    }

    public static String getMessage(String key, String[] vars) throws MissingResourceException {
        return MessageFormat.format(JavaUtils.getMessage(key), vars);
    }

    private static void initializeMessages() {
        messages = ResourceBundle.getBundle("org.apache.axis.utils.axisNLS");
    }

    public static final String replace(String name, String oldT, String newT) {
        if (name == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(name.length() * 2);
        int len = oldT.length();
        try {
            int start = 0;
            int i = name.indexOf(oldT, start);
            while (i >= 0) {
                sb.append(name.substring(start, i));
                sb.append(newT);
                start = i + len;
                i = name.indexOf(oldT, start);
            }
            if (start < name.length()) {
                sb.append(name.substring(start));
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        return new String(sb);
    }

    public static Class getHolderValueType(Class type) {
        if (type != null) {
            Field field;
            Class<?>[] intf = type.getInterfaces();
            boolean isHolder = false;
            int i = 0;
            while (i < intf.length) {
                if (intf[i] == (class$javax$xml$rpc$holders$Holder == null ? JavaUtils.class$("javax.xml.rpc.holders.Holder") : class$javax$xml$rpc$holders$Holder)) {
                    isHolder = true;
                }
                ++i;
            }
            if (!isHolder) {
                return null;
            }
            try {
                field = type.getField("value");
            }
            catch (Exception e) {
                field = null;
            }
            if (field != null) {
                return field.getType();
            }
        }
        return null;
    }

    public static Object getHolderValue(Object holder) throws HolderException {
        if (!(holder instanceof Holder)) {
            throw new HolderException(JavaUtils.getMessage("badHolder00"));
        }
        try {
            Field valueField = holder.getClass().getField("value");
            return valueField.get(holder);
        }
        catch (Exception e) {
            throw new HolderException(JavaUtils.getMessage("exception01", e.getMessage()));
        }
    }

    public static void setHolderValue(Object holder, Object value) throws HolderException {
        if (!(holder instanceof Holder)) {
            throw new HolderException(JavaUtils.getMessage("badHolder00"));
        }
        try {
            Field valueField = holder.getClass().getField("value");
            if (valueField.getType().isPrimitive()) {
                if (value != null) {
                    valueField.set(holder, value);
                }
            } else {
                valueField.set(holder, value);
            }
        }
        catch (Exception e) {
            throw new HolderException(JavaUtils.getMessage("exception01", e.getMessage()));
        }
    }

    public static boolean isEnumClass(Class cls) {
        try {
            Method m = cls.getMethod("getValue", null);
            Method m2 = cls.getMethod("toString", null);
            Method m3 = cls.getMethod("fromString", class$java$lang$String == null ? (class$java$lang$String = JavaUtils.class$("java.lang.String")) : class$java$lang$String);
            if (m != null && m2 != null && m3 != null && cls.getMethod("fromValue", m.getReturnType()) != null) {
                try {
                    return cls.getMethod("setValue", m.getReturnType()) == null;
                }
                catch (NoSuchMethodException e) {
                    return true;
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    public static String stackToString(Throwable e) {
        StringWriter sw = new StringWriter(1024);
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static final boolean isTrue(String value) {
        return !JavaUtils.isFalseExplicitly(value);
    }

    public static final boolean isTrueExplicitly(String value) {
        return value != null && (value.equalsIgnoreCase("true") || value.equals("1") || value.equalsIgnoreCase("yes"));
    }

    public static final boolean isTrueExplicitly(Object value, boolean defaultVal) {
        if (value == null) {
            return defaultVal;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Integer) {
            return (Integer)value != 0;
        }
        if (value instanceof String) {
            return JavaUtils.isTrueExplicitly((String)value);
        }
        return true;
    }

    public static final boolean isTrueExplicitly(Object value) {
        return JavaUtils.isTrueExplicitly(value, false);
    }

    public static final boolean isTrue(Object value, boolean defaultVal) {
        return !JavaUtils.isFalseExplicitly(value, !defaultVal);
    }

    public static final boolean isTrue(Object value) {
        return JavaUtils.isTrue(value, false);
    }

    public static final boolean isFalse(String value) {
        return JavaUtils.isFalseExplicitly(value);
    }

    public static final boolean isFalseExplicitly(String value) {
        return value == null || value.equalsIgnoreCase("false") || value.equals("0") || value.equalsIgnoreCase("no");
    }

    public static final boolean isFalseExplicitly(Object value, boolean defaultVal) {
        if (value == null) {
            return defaultVal;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof Integer) {
            return (Integer)value == 0;
        }
        if (value instanceof String) {
            return JavaUtils.isFalseExplicitly((String)value);
        }
        return false;
    }

    public static final boolean isFalseExplicitly(Object value) {
        return JavaUtils.isFalseExplicitly(value, true);
    }

    public static final boolean isFalse(Object value, boolean defaultVal) {
        return JavaUtils.isFalseExplicitly(value, defaultVal);
    }

    public static final boolean isFalse(Object value) {
        return JavaUtils.isFalse(value, true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class HolderException
    extends Exception {
        public HolderException(String msg) {
            super(msg);
        }
    }

    public static interface ConvertCache {
        public void setConvertedValue(Class var1, Object var2);

        public Object getConvertedValue(Class var1);

        public Class getDestClass();
    }
}

