/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Stack;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Mapping;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NSStack {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$utils$NSStack == null ? (class$org$apache$axis$utils$NSStack = NSStack.class$("org.apache.axis.utils.NSStack")) : class$org$apache$axis$utils$NSStack).getName());
    private static final ArrayList EMPTY = new ArrayList();
    private Stack stack = new Stack();
    private NSStack parent = null;
    static /* synthetic */ Class class$org$apache$axis$utils$NSStack;

    public NSStack() {
    }

    public NSStack(ArrayList table) {
        this.push(table);
    }

    public NSStack(NSStack parent) {
        this.parent = parent;
    }

    public void push() {
        if (this.stack == null) {
            this.stack = new Stack();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("NSPush (" + this.stack.size() + ")"));
        }
        this.stack.push(EMPTY);
    }

    public void push(ArrayList table) {
        if (this.stack == null) {
            this.stack = new Stack();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("NSPush (" + this.stack.size() + ")"));
        }
        if (table.size() == 0) {
            this.stack.push(EMPTY);
        } else {
            this.stack.push(table);
        }
    }

    public ArrayList peek() {
        if (this.stack.isEmpty()) {
            if (this.parent != null) {
                return this.parent.peek();
            }
            return EMPTY;
        }
        return (ArrayList)this.stack.peek();
    }

    public ArrayList pop() {
        if (this.stack.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("NSPop (" + JavaUtils.getMessage("empty00") + ")"));
            }
            if (this.parent != null) {
                return this.parent.pop();
            }
            return null;
        }
        if (log.isTraceEnabled()) {
            ArrayList t = (ArrayList)this.stack.pop();
            log.trace((Object)("NSPop (" + this.stack.size() + ")"));
            return t;
        }
        return (ArrayList)this.stack.pop();
    }

    public void add(String namespaceURI, String prefix) {
        ArrayList<Mapping> table;
        if (this.stack.isEmpty()) {
            this.push();
        }
        if ((table = this.peek()) == EMPTY) {
            table = new ArrayList<Mapping>();
            this.stack.pop();
            this.stack.push(table);
        }
        Iterator i = ((AbstractList)table).iterator();
        while (i.hasNext()) {
            Mapping mapping = (Mapping)i.next();
            if (!mapping.getPrefix().equals(prefix)) continue;
            mapping.setNamespaceURI(namespaceURI);
            return;
        }
        table.add(new Mapping(namespaceURI, prefix));
    }

    public String getPrefix(String namespaceURI, boolean noDefault) {
        if (namespaceURI == null || namespaceURI.equals("")) {
            return null;
        }
        if (!this.stack.isEmpty()) {
            int n = this.stack.size() - 1;
            while (n >= 0) {
                ArrayList t = (ArrayList)this.stack.get(n);
                int i = 0;
                while (i < t.size()) {
                    String possiblePrefix;
                    Mapping map = (Mapping)t.get(i);
                    if (map.getNamespaceURI().equals(namespaceURI) && this.getNamespaceURI(possiblePrefix = map.getPrefix()).equals(namespaceURI) && (!noDefault || !"".equals(possiblePrefix))) {
                        return possiblePrefix;
                    }
                    ++i;
                }
                --n;
            }
        }
        if (this.parent != null) {
            return this.parent.getPrefix(namespaceURI);
        }
        return null;
    }

    public String getPrefix(String namespaceURI) {
        return this.getPrefix(namespaceURI, false);
    }

    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        if (!this.stack.isEmpty()) {
            int n = this.stack.size() - 1;
            while (n >= 0) {
                ArrayList t = (ArrayList)this.stack.get(n);
                int i = 0;
                while (i < t.size()) {
                    Mapping map = (Mapping)t.get(i);
                    if (map.getPrefix().equals(prefix)) {
                        return map.getNamespaceURI();
                    }
                    ++i;
                }
                --n;
            }
        }
        if (this.parent != null) {
            return this.parent.getNamespaceURI(prefix);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("--" + JavaUtils.getMessage("noPrefix00", "" + this, prefix)));
            this.dump("--");
            log.trace((Object)("--" + JavaUtils.getMessage("end00")));
        }
        return null;
    }

    public boolean isDeclared(String namespaceURI) {
        if (!this.stack.isEmpty()) {
            int n = this.stack.size() - 1;
            while (n >= 0) {
                ArrayList t = (ArrayList)this.stack.get(n);
                if (t != null && t != EMPTY) {
                    int i = 0;
                    while (i < t.size()) {
                        if (((Mapping)t.get(i)).getNamespaceURI().equals(namespaceURI)) {
                            return true;
                        }
                        ++i;
                    }
                }
                --n;
            }
        }
        if (this.parent != null) {
            return this.parent.isDeclared(namespaceURI);
        }
        return false;
    }

    public void dump(String dumpPrefix) {
        Enumeration e = this.stack.elements();
        while (e.hasMoreElements()) {
            ArrayList list = (ArrayList)e.nextElement();
            if (list == null) {
                log.trace((Object)(dumpPrefix + JavaUtils.getMessage("nullTable00")));
                continue;
            }
            int i = 0;
            while (i < list.size()) {
                Mapping map = (Mapping)list.get(i);
                log.trace((Object)(dumpPrefix + map.getNamespaceURI() + " -> " + map.getPrefix()));
                ++i;
            }
        }
        if (this.parent != null) {
            log.trace((Object)(dumpPrefix + "--" + JavaUtils.getMessage("parent00")));
            this.parent.dump(dumpPrefix + "--");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

