/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.fromJava;

import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPBodyImpl;
import com.ibm.wsdl.extensions.soap.SOAPOperationImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.apache.axis.description.FaultDesc;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.DefaultSOAP12TypeMappingImpl;
import org.apache.axis.encoding.DefaultTypeMappingImpl;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.axis.wsdl.fromJava.Types;
import org.w3c.dom.Document;

public class Emitter {
    public static final int MODE_ALL = 0;
    public static final int MODE_INTERFACE = 1;
    public static final int MODE_IMPLEMENTATION = 2;
    public static final int MODE_RPC = 0;
    public static final int MODE_DOCUMENT = 1;
    private Class cls;
    private Class implCls;
    private Vector allowedMethods = null;
    private Vector disallowedMethods = null;
    private ArrayList stopClasses = new ArrayList();
    private boolean useInheritedMethods = false;
    private String intfNS;
    private String implNS;
    private String locationUrl;
    private String importUrl;
    private String servicePortName;
    private String serviceElementName;
    private String targetService = null;
    private String description;
    private int mode = 0;
    private TypeMapping tm = null;
    private TypeMapping defaultTM = null;
    private Namespaces namespaces = new Namespaces();
    private Map exceptionMsg = new HashMap();
    private ArrayList encodingList;
    private Types types;
    private String clsName;
    private String portTypeName;
    private ServiceDesc serviceDesc;
    private ServiceDesc serviceDesc2;
    private String soapAction = "DEFAULT";

    public void emit(String filename1, String filename2) throws Exception {
        Definition intf = this.getIntfWSDL();
        Definition impl = this.getImplWSDL();
        if (filename1 == null) {
            filename1 = this.getServicePortName() + "_interface.wsdl";
        }
        if (filename2 == null) {
            filename2 = this.getServicePortName() + "_implementation.wsdl";
        }
        Document doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(intf);
        this.types.insertTypesFragment(doc);
        this.prettyDocumentToFile(doc, filename1);
        doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(impl);
        this.prettyDocumentToFile(doc, filename2);
    }

    public void emit(String filename) throws Exception {
        this.emit(filename, 0);
    }

    public Document emit(int mode) throws Exception {
        Document doc = null;
        Definition def = null;
        switch (mode) {
            case 0: {
                def = this.getWSDL();
                doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(def);
                this.types.insertTypesFragment(doc);
                break;
            }
            case 1: {
                def = this.getIntfWSDL();
                doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(def);
                this.types.insertTypesFragment(doc);
                break;
            }
            case 2: {
                def = this.getImplWSDL();
                doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(def);
                break;
            }
            default: {
                throw new Exception("unrecognized output WSDL mode");
            }
        }
        return doc;
    }

    public String emitToString(int mode) throws Exception {
        Document doc = this.emit(mode);
        StringWriter sw = new StringWriter();
        XMLUtils.PrettyDocumentToWriter(doc, sw);
        return sw.toString();
    }

    public void emit(String filename, int mode) throws Exception {
        Document doc = this.emit(mode);
        if (filename == null) {
            filename = this.getServicePortName();
            switch (mode) {
                case 0: {
                    filename = filename + ".wsdl";
                    break;
                }
                case 1: {
                    filename = filename + "_interface.wsdl";
                    break;
                }
                case 2: {
                    filename = filename + "_implementation.wsdl";
                }
            }
        }
        this.prettyDocumentToFile(doc, filename);
    }

    public Definition getWSDL() throws Exception {
        this.init();
        Definition def = WSDLFactory.newInstance().newDefinition();
        this.writeDefinitions(def, this.intfNS);
        this.types = new Types(def, this.tm, this.defaultTM, this.namespaces, this.intfNS, this.stopClasses);
        Binding binding = this.writeBinding(def, true);
        this.writePortType(def, binding);
        this.writeService(def, binding);
        return def;
    }

    public Definition getIntfWSDL() throws Exception {
        this.init();
        Definition def = WSDLFactory.newInstance().newDefinition();
        this.writeDefinitions(def, this.intfNS);
        this.types = new Types(def, this.tm, this.defaultTM, this.namespaces, this.intfNS, this.stopClasses);
        Binding binding = this.writeBinding(def, true);
        this.writePortType(def, binding);
        return def;
    }

    public Definition getImplWSDL() throws Exception {
        this.init();
        Definition def = WSDLFactory.newInstance().newDefinition();
        this.writeDefinitions(def, this.implNS);
        this.writeImport(def, this.intfNS, this.importUrl);
        Binding binding = this.writeBinding(def, false);
        this.writeService(def, binding);
        return def;
    }

    private void init() throws Exception {
        TypeMappingRegistryImpl tmr;
        if (this.serviceDesc == null) {
            this.serviceDesc = new ServiceDesc();
            this.serviceDesc.setImplClass(this.cls);
            tmr = new TypeMappingRegistryImpl();
            this.serviceDesc.setTypeMapping((TypeMapping)tmr.getDefaultTypeMapping());
        }
        this.serviceDesc.setStopClasses(this.stopClasses);
        this.serviceDesc.setAllowedMethods(this.allowedMethods);
        this.serviceDesc.setDisallowedMethods(this.disallowedMethods);
        if (this.implCls != null && this.implCls != this.cls && this.serviceDesc2 == null) {
            this.serviceDesc2 = new ServiceDesc();
            this.serviceDesc2.setImplClass(this.implCls);
            tmr = new TypeMappingRegistryImpl();
            this.serviceDesc2.setTypeMapping((TypeMapping)tmr.getDefaultTypeMapping());
            this.serviceDesc2.setStopClasses(this.stopClasses);
            this.serviceDesc2.setAllowedMethods(this.allowedMethods);
            this.serviceDesc2.setDisallowedMethods(this.disallowedMethods);
        }
        if (this.encodingList == null) {
            this.clsName = this.cls.getName();
            this.clsName = this.clsName.substring(this.clsName.lastIndexOf(46) + 1);
            if (this.getPortTypeName() == null) {
                this.setPortTypeName(this.clsName);
            }
            if (this.getServiceElementName() == null) {
                this.setServiceElementName(this.getPortTypeName() + "Service");
            }
            if (this.getServicePortName() == null) {
                String name = this.getLocationUrl();
                if (name != null && (name = name.lastIndexOf(47) > 0 ? name.substring(name.lastIndexOf(47) + 1) : (name.lastIndexOf(92) > 0 ? name.substring(name.lastIndexOf(92) + 1) : null)) != null && name.endsWith(".jws")) {
                    name = name.substring(0, name.length() - ".jws".length());
                }
                if (name == null || name.equals("")) {
                    name = this.clsName;
                }
                this.setServicePortName(name);
            }
            this.encodingList = new ArrayList();
            this.encodingList.add("http://schemas.xmlsoap.org/soap/encoding/");
            if (this.defaultTM == null || this.defaultTM instanceof DefaultTypeMappingImpl) {
                this.defaultTM = DefaultSOAP12TypeMappingImpl.create();
            }
            if (this.intfNS == null) {
                Package pkg = this.cls.getPackage();
                this.intfNS = this.namespaces.getCreate(pkg == null ? null : pkg.getName());
            }
            if (this.implNS == null) {
                this.implNS = this.intfNS + "-impl";
            }
            this.namespaces.put(this.cls.getName(), this.intfNS, "intf");
            this.namespaces.putPrefix(this.implNS, "impl");
        }
    }

    private void writeDefinitions(Definition def, String tns) throws Exception {
        def.setTargetNamespace(tns);
        def.addNamespace("intf", this.intfNS);
        def.addNamespace("impl", this.implNS);
        def.addNamespace("wsdlsoap", "http://schemas.xmlsoap.org/wsdl/soap/");
        this.namespaces.putPrefix("http://schemas.xmlsoap.org/wsdl/soap/", "wsdlsoap");
        def.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        this.namespaces.putPrefix("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        def.addNamespace("soapenc", "http://schemas.xmlsoap.org/soap/encoding/");
        this.namespaces.putPrefix("http://schemas.xmlsoap.org/soap/encoding/", "soapenc");
        def.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        this.namespaces.putPrefix("http://www.w3.org/2001/XMLSchema", "xsd");
        def.addNamespace("apachesoap", "http://xml.apache.org/xml-soap");
        this.namespaces.putPrefix("http://xml.apache.org/xml-soap", "apachesoap");
    }

    private void writeImport(Definition def, String tns, String loc) throws Exception {
        Import imp = def.createImport();
        imp.setNamespaceURI(tns);
        if (loc != null && !loc.equals("")) {
            imp.setLocationURI(loc);
        }
        def.addImport(imp);
    }

    private Binding writeBinding(Definition def, boolean add) throws Exception {
        Binding binding = def.createBinding();
        binding.setUndefined(false);
        binding.setQName(new QName(this.intfNS, this.getServicePortName() + "SoapBinding"));
        SOAPBindingImpl soapBinding = new SOAPBindingImpl();
        String modeStr = this.mode == 0 ? "rpc" : "document";
        soapBinding.setStyle(modeStr);
        soapBinding.setTransportURI("http://schemas.xmlsoap.org/soap/http");
        binding.addExtensibilityElement((ExtensibilityElement)soapBinding);
        if (add) {
            def.addBinding(binding);
        }
        return binding;
    }

    private void writeService(Definition def, Binding binding) {
        Service service = def.createService();
        service.setQName(new QName(this.implNS, this.getServiceElementName()));
        def.addService(service);
        Port port = def.createPort();
        port.setBinding(binding);
        port.setName(this.getServicePortName());
        SOAPAddressImpl addr = new SOAPAddressImpl();
        addr.setLocationURI(this.locationUrl);
        port.addExtensibilityElement((ExtensibilityElement)addr);
        service.addPort(port);
    }

    private void writePortType(Definition def, Binding binding) throws Exception {
        PortType portType = def.createPortType();
        portType.setUndefined(false);
        QName tempqn = new QName(this.intfNS, this.getPortTypeName());
        portType.setQName(tempqn);
        ArrayList operations = this.serviceDesc.getOperations();
        Iterator i = ((AbstractList)operations).iterator();
        while (i.hasNext()) {
            OperationDesc thisOper = (OperationDesc)i.next();
            BindingOperation bindingOper = this.writeOperation(def, binding, thisOper);
            Operation oper = bindingOper.getOperation();
            OperationDesc messageOper = thisOper;
            if (this.serviceDesc2 != null) {
                OperationDesc[] operArray = this.serviceDesc2.getOperationsByName(thisOper.getName());
                boolean found = false;
                if (operArray != null) {
                    int j = 0;
                    while (j < operArray.length && !found) {
                        OperationDesc tryOper = operArray[j];
                        if (tryOper.getParameters().size() == thisOper.getParameters().size()) {
                            boolean parmsMatch = true;
                            int k = 0;
                            while (k < thisOper.getParameters().size() && parmsMatch) {
                                if (tryOper.getParameter(k).getMode() != thisOper.getParameter(k).getMode() || !tryOper.getParameter(k).getJavaType().equals(thisOper.getParameter(k).getJavaType())) {
                                    parmsMatch = false;
                                }
                                if (parmsMatch) {
                                    messageOper = tryOper;
                                    found = true;
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
            }
            this.writeMessages(def, oper, messageOper, bindingOper);
            portType.addOperation(oper);
        }
        def.addPortType(portType);
        binding.setPortType(portType);
    }

    private void writeMessages(Definition def, Operation oper, OperationDesc desc, BindingOperation bindingOper) throws Exception {
        Input input = def.createInput();
        Message msg = this.writeRequestMessage(def, desc);
        input.setMessage(msg);
        String name = msg.getQName().getLocalPart();
        input.setName(name);
        bindingOper.getBindingInput().setName(name);
        oper.setInput(input);
        def.addMessage(msg);
        msg = this.writeResponseMessage(def, desc);
        Output output = def.createOutput();
        output.setMessage(msg);
        name = msg.getQName().getLocalPart();
        output.setName(name);
        bindingOper.getBindingOutput().setName(name);
        oper.setOutput(output);
        def.addMessage(msg);
        ArrayList exceptions = desc.getFaults();
        int i = 0;
        while (exceptions != null && i < exceptions.size()) {
            FaultDesc faultDesc = (FaultDesc)exceptions.get(i);
            msg = this.writeFaultMessage(def, faultDesc);
            Fault fault = def.createFault();
            fault.setMessage(msg);
            fault.setName(faultDesc.getName());
            oper.addFault(fault);
            if (def.getMessage(msg.getQName()) == null) {
                def.addMessage(msg);
            }
            ++i;
        }
        ArrayList parameters = desc.getParameters();
        Vector<String> names = new Vector<String>();
        int i2 = 0;
        while (i2 < parameters.size()) {
            ParameterDesc param = (ParameterDesc)parameters.get(i2);
            names.add(param.getName());
            ++i2;
        }
        if (names.size() > 0) {
            oper.setParameterOrdering(names);
        }
    }

    private BindingOperation writeOperation(Definition def, Binding binding, OperationDesc desc) {
        Operation oper = def.createOperation();
        oper.setName(desc.getName());
        oper.setUndefined(false);
        return this.writeBindingOperation(def, binding, oper, desc);
    }

    private BindingOperation writeBindingOperation(Definition def, Binding binding, Operation oper, OperationDesc desc) {
        BindingOperation bindingOper = def.createBindingOperation();
        BindingInput bindingInput = def.createBindingInput();
        BindingOutput bindingOutput = def.createBindingOutput();
        bindingOper.setName(oper.getName());
        bindingOper.setOperation(oper);
        SOAPOperationImpl soapOper = new SOAPOperationImpl();
        String soapAction = "";
        if (this.getSoapAction().equals("OPERATION")) {
            soapAction = oper.getName();
        } else if (this.getSoapAction().equals("NONE")) {
            soapAction = "";
        } else {
            soapAction = desc.getSoapAction();
            if (soapAction == null) {
                soapAction = "";
            }
        }
        soapOper.setSoapActionURI(soapAction);
        bindingOper.addExtensibilityElement((ExtensibilityElement)soapOper);
        SOAPBodyImpl soapBodyIn = new SOAPBodyImpl();
        if (this.mode == 0) {
            soapBodyIn.setUse("encoded");
            soapBodyIn.setEncodingStyles((List)this.encodingList);
        } else {
            soapBodyIn.setUse("literal");
        }
        if (this.targetService == null) {
            soapBodyIn.setNamespaceURI(this.intfNS);
        } else {
            soapBodyIn.setNamespaceURI(this.targetService);
        }
        QName operQName = desc.getElementQName();
        if (operQName != null && !operQName.getNamespaceURI().equals("")) {
            soapBodyIn.setNamespaceURI(operQName.getNamespaceURI());
        }
        soapBodyIn.setEncodingStyles((List)this.encodingList);
        bindingInput.addExtensibilityElement((ExtensibilityElement)soapBodyIn);
        SOAPBodyImpl soapBodyOut = new SOAPBodyImpl();
        if (this.mode == 0) {
            soapBodyOut.setUse("encoded");
            soapBodyOut.setEncodingStyles((List)this.encodingList);
        } else {
            soapBodyOut.setUse("literal");
        }
        if (this.targetService == null) {
            soapBodyOut.setNamespaceURI(this.intfNS);
        } else {
            soapBodyOut.setNamespaceURI(this.targetService);
        }
        QName retQName = desc.getReturnQName();
        if (retQName != null && !retQName.getNamespaceURI().equals("")) {
            soapBodyOut.setNamespaceURI(retQName.getNamespaceURI());
        }
        bindingOutput.addExtensibilityElement((ExtensibilityElement)soapBodyOut);
        bindingOper.setBindingInput(bindingInput);
        bindingOper.setBindingOutput(bindingOutput);
        binding.addBindingOperation(bindingOper);
        return bindingOper;
    }

    private Message writeRequestMessage(Definition def, OperationDesc oper) throws Exception {
        Message msg = def.createMessage();
        QName qName = this.createMessageName(def, oper.getName(), "Request");
        msg.setQName(qName);
        msg.setUndefined(false);
        ArrayList parameters = oper.getParameters();
        int i = 0;
        while (i < parameters.size()) {
            ParameterDesc parameter = (ParameterDesc)parameters.get(i);
            this.writePartToMessage(def, msg, true, parameter);
            ++i;
        }
        return msg;
    }

    private Message writeResponseMessage(Definition def, OperationDesc desc) throws Exception {
        Message msg = def.createMessage();
        QName qName = this.createMessageName(def, desc.getName(), "Response");
        msg.setQName(qName);
        msg.setUndefined(false);
        ParameterDesc retParam = new ParameterDesc();
        if (desc.getReturnQName() == null) {
            retParam.setName("return");
        } else {
            retParam.setQName(desc.getReturnQName());
        }
        retParam.setTypeQName(desc.getReturnType());
        retParam.setJavaType(desc.getReturnClass());
        retParam.setMode((byte)2);
        this.writePartToMessage(def, msg, false, retParam);
        ArrayList parameters = desc.getParameters();
        Iterator i = ((AbstractList)parameters).iterator();
        while (i.hasNext()) {
            ParameterDesc param = (ParameterDesc)i.next();
            this.writePartToMessage(def, msg, false, param);
        }
        return msg;
    }

    private Message writeFaultMessage(Definition def, FaultDesc exception) throws Exception {
        String pkgAndClsName = exception.getName();
        String clsName = pkgAndClsName.substring(pkgAndClsName.lastIndexOf(46) + 1, pkgAndClsName.length());
        exception.setName(clsName);
        Message msg = (Message)this.exceptionMsg.get(pkgAndClsName);
        if (msg == null) {
            msg = def.createMessage();
            QName qName = this.createMessageName(def, clsName, "");
            msg.setQName(qName);
            msg.setUndefined(false);
            ArrayList parameters = exception.getParameters();
            int i = 0;
            while (i < parameters.size()) {
                ParameterDesc parameter = (ParameterDesc)parameters.get(i);
                this.writePartToMessage(def, msg, true, parameter);
                ++i;
            }
            this.exceptionMsg.put(pkgAndClsName, msg);
        }
        return msg;
    }

    public String writePartToMessage(Definition def, Message msg, boolean request, ParameterDesc param) throws Exception {
        if (param == null || param.getJavaType() == Void.TYPE) {
            return null;
        }
        if (request && param.getMode() == 2) {
            return null;
        }
        if (!request && param.getMode() == 1) {
            return null;
        }
        Part part = def.createPart();
        QName elemQName = null;
        if (this.mode != 0) {
            elemQName = param.getQName();
        }
        QName typeQName = this.types.writePartType(param.getJavaType(), elemQName);
        if (this.mode == 0) {
            if (typeQName != null) {
                part.setTypeName(typeQName);
                part.setName(param.getName());
                msg.addPart(part);
            }
        } else if (elemQName != null) {
            String namespaceURI = elemQName.getNamespaceURI();
            if (namespaceURI != null && !namespaceURI.equals("")) {
                def.addNamespace(this.namespaces.getCreatePrefix(namespaceURI), namespaceURI);
            }
            part.setElementName(elemQName);
            part.setName(param.getName());
            msg.addPart(part);
        }
        return param.getName();
    }

    private QName createMessageName(Definition def, String methodName, String suffix) {
        QName qName = new QName(this.intfNS, methodName.concat(suffix));
        int messageNumber = 1;
        while (def.getMessage(qName) != null) {
            StringBuffer namebuf = new StringBuffer(methodName.concat(suffix));
            namebuf.append(messageNumber);
            qName = new QName(this.intfNS, namebuf.toString());
            ++messageNumber;
        }
        return qName;
    }

    private void prettyDocumentToFile(Document doc, String filename) throws Exception {
        FileOutputStream fos = new FileOutputStream(new File(filename));
        XMLUtils.PrettyDocumentToStream(doc, fos);
        fos.close();
    }

    public Class getCls() {
        return this.cls;
    }

    public void setCls(Class cls) {
        this.cls = cls;
    }

    public void setClsSmart(Class cls, String location) {
        if (cls == null || location == null) {
            return;
        }
        if (location.lastIndexOf(47) > 0) {
            location = location.substring(location.lastIndexOf(47) + 1);
        } else if (location.lastIndexOf(92) > 0) {
            location = location.substring(location.lastIndexOf(92) + 1);
        }
        Constructor<?>[] constructors = cls.getDeclaredConstructors();
        Class<?> intf = null;
        int i = 0;
        while (i < constructors.length && intf == null) {
            Class<?>[] parms = constructors[i].getParameterTypes();
            if (parms.length == 1 && parms[0].isInterface() && parms[0].getName() != null && Types.getLocalNameFromFullName(parms[0].getName()).equals(location)) {
                intf = parms[0];
            }
            ++i;
        }
        if (intf != null) {
            this.setCls(intf);
            if (this.implCls == null) {
                this.setImplCls(cls);
            }
        } else {
            this.setCls(cls);
        }
    }

    public void setCls(String className) throws ClassNotFoundException {
        this.cls = ClassUtils.forName(className);
    }

    public Class getImplCls() {
        return this.implCls;
    }

    public void setImplCls(Class implCls) {
        this.implCls = implCls;
    }

    public void setImplCls(String className) {
        try {
            this.implCls = ClassUtils.forName(className);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getIntfNamespace() {
        return this.intfNS;
    }

    public void setIntfNamespace(String ns) {
        this.intfNS = ns;
    }

    public String getImplNamespace() {
        return this.implNS;
    }

    public void setImplNamespace(String ns) {
        this.implNS = ns;
    }

    public Vector getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(String text) {
        if (text != null) {
            StringTokenizer tokenizer = new StringTokenizer(text, " ,+");
            if (this.allowedMethods == null) {
                this.allowedMethods = new Vector();
            }
            while (tokenizer.hasMoreTokens()) {
                this.allowedMethods.add(tokenizer.nextToken());
            }
        }
    }

    public void setAllowedMethods(Vector allowedMethods) {
        if (this.allowedMethods == null) {
            this.allowedMethods = new Vector();
        }
        this.allowedMethods.addAll(allowedMethods);
    }

    public boolean getUseInheritedMethods() {
        return this.useInheritedMethods;
    }

    public void setUseInheritedMethods(boolean useInheritedMethods) {
        this.useInheritedMethods = useInheritedMethods;
    }

    public void setDisallowedMethods(Vector disallowedMethods) {
        if (this.disallowedMethods == null) {
            this.disallowedMethods = new Vector();
        }
        this.disallowedMethods.addAll(disallowedMethods);
    }

    public void setDisallowedMethods(String text) {
        if (text != null) {
            StringTokenizer tokenizer = new StringTokenizer(text, " ,+");
            if (this.disallowedMethods == null) {
                this.disallowedMethods = new Vector();
            }
            this.disallowedMethods = new Vector();
            while (tokenizer.hasMoreTokens()) {
                this.disallowedMethods.add(tokenizer.nextToken());
            }
        }
    }

    public Vector getDisallowedMethods() {
        return this.disallowedMethods;
    }

    public void setStopClasses(ArrayList stopClasses) {
        if (this.stopClasses == null) {
            this.stopClasses = new ArrayList();
        }
        this.stopClasses.addAll(stopClasses);
    }

    public void setStopClasses(String text) {
        if (text != null) {
            StringTokenizer tokenizer = new StringTokenizer(text, " ,+");
            if (this.stopClasses == null) {
                this.stopClasses = new ArrayList();
            }
            while (tokenizer.hasMoreTokens()) {
                this.stopClasses.add(tokenizer.nextToken());
            }
        }
    }

    public ArrayList getStopClasses() {
        return this.stopClasses;
    }

    public Map getNamespaceMap() {
        return this.namespaces;
    }

    public void setNamespaceMap(Map map) {
        if (map != null) {
            this.namespaces.putAll(map);
        }
    }

    public String getLocationUrl() {
        return this.locationUrl;
    }

    public void setLocationUrl(String locationUrl) {
        this.locationUrl = locationUrl;
    }

    public String getImportUrl() {
        return this.importUrl;
    }

    public void setImportUrl(String importUrl) {
        this.importUrl = importUrl;
    }

    public String getServicePortName() {
        return this.servicePortName;
    }

    public void setServicePortName(String servicePortName) {
        this.servicePortName = servicePortName;
    }

    public String getServiceElementName() {
        return this.serviceElementName;
    }

    public void setServiceElementName(String serviceElementName) {
        this.serviceElementName = serviceElementName;
    }

    public String getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(String portTypeName) {
        this.portTypeName = portTypeName;
    }

    public String getTargetService() {
        return this.targetService;
    }

    public void setTargetService(String targetService) {
        this.targetService = targetService;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String value) {
        this.soapAction = value;
    }

    public TypeMapping getTypeMapping() {
        return this.tm;
    }

    public void setTypeMapping(TypeMapping tm) {
        this.tm = tm;
    }

    public TypeMapping getDefaultTypeMapping() {
        return this.defaultTM;
    }

    public void setDefaultTypeMapping(TypeMapping defaultTM) {
        this.defaultTM = defaultTM;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public ServiceDesc getServiceDesc() {
        return this.serviceDesc;
    }

    public void setServiceDesc(ServiceDesc serviceDesc) {
        this.serviceDesc = serviceDesc;
    }
}

